/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.io.PersistentHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestStateStorage
implements Disposable {
    private static final File TEST_HISTORY_PATH = new File(PathManager.getSystemPath(), "testHistory");
    private static final Logger LOG = Logger.getInstance(TestStateStorage.class);
    private PersistentHashMap<String, Record> myMap;

    public static File getTestHistoryRoot(Project project) {
        return new File(TEST_HISTORY_PATH, project.getLocationHash());
    }

    public static TestStateStorage getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/TestStateStorage", "getInstance"));
        }
        return (TestStateStorage)ServiceManager.getService((Project)project, TestStateStorage.class);
    }

    public TestStateStorage(Project project) {
        File file = new File(TestStateStorage.getTestHistoryRoot(project).getPath() + "/testStateMap");
        FileUtilRt.createParentDirs((File)file);
        try {
            this.myMap = this.create(file);
        }
        catch (PersistentEnumeratorBase.CorruptedException e) {
            PersistentHashMap.deleteFilesStartingWith((File)file);
            try {
                this.myMap = this.create(file);
            }
            catch (IOException e1) {
                LOG.error((Throwable)e1);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        Disposer.register((Disposable)project, (Disposable)this);
    }

    @NotNull
    protected PersistentHashMap<String, Record> create(File file) throws IOException {
        PersistentHashMap persistentHashMap = new PersistentHashMap(file, (KeyDescriptor)new EnumeratorStringDescriptor(), (DataExternalizer)new DataExternalizer<Record>(){

            public void save(@NotNull DataOutput out, Record value) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/execution/TestStateStorage$1", "save"));
                }
                out.writeInt(value.magnitude);
                out.writeLong(value.date.getTime());
            }

            public Record read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/execution/TestStateStorage$1", "read"));
                }
                return new Record(in.readInt(), new Date(in.readLong()));
            }
        });
        if (persistentHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/TestStateStorage", "create"));
        }
        return persistentHashMap;
    }

    @Nullable
    public Record getState(String testUrl) {
        try {
            return this.myMap == null ? null : (Record)this.myMap.get((Object)testUrl);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public void writeState(@NotNull String testUrl, Record record) {
        if (testUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testUrl", "com/intellij/execution/TestStateStorage", "writeState"));
        }
        if (this.myMap == null) {
            return;
        }
        try {
            this.myMap.put((Object)testUrl, (Object)record);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public void dispose() {
        try {
            this.myMap.close();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public static class Record {
        public final int magnitude;
        public final Date date;

        public Record(int magnitude, Date date) {
            this.magnitude = magnitude;
            this.date = date;
        }
    }
}

