/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplexConsoleView<S extends ConsoleView, T extends ConsoleView>
extends JPanel
implements ConsoleView,
ObservableConsoleView {
    private static final String PRIMARY_CONSOLE_PANEL = "PRIMARY_CONSOLE_PANEL";
    private static final String SECONDARY_CONSOLE_PANEL = "SECONDARY_CONSOLE_PANEL";
    @NotNull
    private final S myPrimaryConsoleView;
    @NotNull
    private final T mySecondaryConsoleView;
    @Nullable
    private final String myStateStorageKey;
    private boolean myPrimary;
    @Nullable
    private ProcessHandler myProcessHandler;
    @NotNull
    private final SwitchDuplexConsoleViewAction mySwitchConsoleAction;

    public DuplexConsoleView(@NotNull S primaryConsoleView, @NotNull T secondaryConsoleView) {
        if (primaryConsoleView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primaryConsoleView", "com/intellij/execution/console/DuplexConsoleView", "<init>"));
        }
        if (secondaryConsoleView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "secondaryConsoleView", "com/intellij/execution/console/DuplexConsoleView", "<init>"));
        }
        this(primaryConsoleView, secondaryConsoleView, null);
    }

    public DuplexConsoleView(@NotNull S primaryConsoleView, @NotNull T secondaryConsoleView, @Nullable String stateStorageKey) {
        if (primaryConsoleView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primaryConsoleView", "com/intellij/execution/console/DuplexConsoleView", "<init>"));
        }
        if (secondaryConsoleView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "secondaryConsoleView", "com/intellij/execution/console/DuplexConsoleView", "<init>"));
        }
        super(new CardLayout());
        this.myPrimaryConsoleView = primaryConsoleView;
        this.mySecondaryConsoleView = secondaryConsoleView;
        this.myStateStorageKey = stateStorageKey;
        this.add((Component)this.myPrimaryConsoleView.getComponent(), PRIMARY_CONSOLE_PANEL);
        this.add((Component)this.mySecondaryConsoleView.getComponent(), SECONDARY_CONSOLE_PANEL);
        this.mySwitchConsoleAction = new SwitchDuplexConsoleViewAction();
        this.myPrimary = true;
        this.enableConsole(this.getStoredState());
        Disposer.register((Disposable)this, this.myPrimaryConsoleView);
        Disposer.register((Disposable)this, this.mySecondaryConsoleView);
    }

    public static <S extends ConsoleView, T extends ConsoleView> DuplexConsoleView<S, T> create(@NotNull S primary, @NotNull T secondary, @Nullable String stateStorageKey) {
        if (primary == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primary", "com/intellij/execution/console/DuplexConsoleView", "create"));
        }
        if (secondary == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "secondary", "com/intellij/execution/console/DuplexConsoleView", "create"));
        }
        return new DuplexConsoleView<S, T>(primary, secondary, stateStorageKey);
    }

    private void setStoredState(boolean primary) {
        if (this.myStateStorageKey != null) {
            PropertiesComponent.getInstance().setValue(this.myStateStorageKey, primary);
        }
    }

    private boolean getStoredState() {
        if (this.myStateStorageKey == null) {
            return false;
        }
        return PropertiesComponent.getInstance().getBoolean(this.myStateStorageKey);
    }

    public void enableConsole(boolean primary) {
        if (primary == this.myPrimary) {
            return;
        }
        CardLayout cl = (CardLayout)this.getLayout();
        cl.show(this, primary ? PRIMARY_CONSOLE_PANEL : SECONDARY_CONSOLE_PANEL);
        this.getSubConsoleView(primary).getComponent().requestFocus();
        this.myPrimary = primary;
    }

    public boolean isPrimaryConsoleEnabled() {
        return this.myPrimary;
    }

    @NotNull
    public S getPrimaryConsoleView() {
        S s = this.myPrimaryConsoleView;
        if (s == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/DuplexConsoleView", "getPrimaryConsoleView"));
        }
        return s;
    }

    @NotNull
    public T getSecondaryConsoleView() {
        T t = this.mySecondaryConsoleView;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/DuplexConsoleView", "getSecondaryConsoleView"));
        }
        return t;
    }

    public ConsoleView getSubConsoleView(boolean primary) {
        return primary ? this.getPrimaryConsoleView() : this.getSecondaryConsoleView();
    }

    public void print(@NotNull String s, @NotNull ConsoleViewContentType contentType) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/execution/console/DuplexConsoleView", "print"));
        }
        if (contentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentType", "com/intellij/execution/console/DuplexConsoleView", "print"));
        }
        this.myPrimaryConsoleView.print(s, contentType);
        this.mySecondaryConsoleView.print(s, contentType);
    }

    public void clear() {
        this.myPrimaryConsoleView.clear();
        this.mySecondaryConsoleView.clear();
    }

    public void scrollTo(int offset) {
        this.myPrimaryConsoleView.scrollTo(offset);
        this.mySecondaryConsoleView.scrollTo(offset);
    }

    public void attachToProcess(ProcessHandler processHandler2) {
        this.myProcessHandler = processHandler2;
        this.myPrimaryConsoleView.attachToProcess(processHandler2);
        this.mySecondaryConsoleView.attachToProcess(processHandler2);
    }

    public void setOutputPaused(boolean value) {
        this.myPrimaryConsoleView.setOutputPaused(value);
        this.mySecondaryConsoleView.setOutputPaused(value);
    }

    public boolean isOutputPaused() {
        return false;
    }

    public boolean hasDeferredOutput() {
        return this.myPrimaryConsoleView.hasDeferredOutput() && this.mySecondaryConsoleView.hasDeferredOutput();
    }

    public void performWhenNoDeferredOutput(Runnable runnable) {
    }

    public void setHelpId(String helpId) {
        this.myPrimaryConsoleView.setHelpId(helpId);
        this.mySecondaryConsoleView.setHelpId(helpId);
    }

    public void addMessageFilter(Filter filter) {
        this.myPrimaryConsoleView.addMessageFilter(filter);
        this.mySecondaryConsoleView.addMessageFilter(filter);
    }

    public void printHyperlink(String hyperlinkText, HyperlinkInfo info) {
        this.myPrimaryConsoleView.printHyperlink(hyperlinkText, info);
        this.mySecondaryConsoleView.printHyperlink(hyperlinkText, info);
    }

    public int getContentSize() {
        return this.myPrimaryConsoleView.getContentSize();
    }

    public boolean canPause() {
        return false;
    }

    @NotNull
    public AnAction[] createConsoleActions() {
        ConsoleHistoryController controller;
        ArrayList actions2 = Lists.newArrayList();
        actions2.addAll(Arrays.asList(this.myPrimaryConsoleView.createConsoleActions()));
        actions2.add(this.mySwitchConsoleAction);
        LanguageConsoleView langConsole = (LanguageConsoleView)ContainerUtil.findInstance(Arrays.asList(this.myPrimaryConsoleView, this.mySecondaryConsoleView), LanguageConsoleView.class);
        ConsoleHistoryController consoleHistoryController = controller = langConsole != null ? ConsoleHistoryController.getController(langConsole) : null;
        if (controller != null) {
            actions2.add(controller.getBrowseHistory());
        }
        AnAction[] anActionArray = (AnAction[])ArrayUtil.toObjectArray((Collection)actions2, AnAction.class);
        if (anActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/DuplexConsoleView", "createConsoleActions"));
        }
        return anActionArray;
    }

    public void allowHeavyFilters() {
        this.myPrimaryConsoleView.allowHeavyFilters();
    }

    public JComponent getComponent() {
        return this;
    }

    public JComponent getPreferredFocusableComponent() {
        return this;
    }

    public void dispose() {
    }

    public void addChangeListener(@NotNull ObservableConsoleView.ChangeListener listener, @NotNull Disposable parent) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/execution/console/DuplexConsoleView", "addChangeListener"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/execution/console/DuplexConsoleView", "addChangeListener"));
        }
        if (this.myPrimaryConsoleView instanceof ObservableConsoleView) {
            ((ObservableConsoleView)this.myPrimaryConsoleView).addChangeListener(listener, parent);
        }
        if (this.mySecondaryConsoleView instanceof ObservableConsoleView) {
            ((ObservableConsoleView)this.mySecondaryConsoleView).addChangeListener(listener, parent);
        }
    }

    @NotNull
    public Presentation getSwitchConsoleActionPresentation() {
        Presentation presentation = this.mySwitchConsoleAction.getTemplatePresentation();
        if (presentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/DuplexConsoleView", "getSwitchConsoleActionPresentation"));
        }
        return presentation;
    }

    private class SwitchDuplexConsoleViewAction
    extends ToggleAction
    implements DumbAware {
        public SwitchDuplexConsoleViewAction() {
            super(ExecutionBundle.message((String)"run.configuration.show.command.line.action.name", (Object[])new Object[0]), null, AllIcons.Debugger.ToolConsole);
        }

        public boolean isSelected(AnActionEvent event) {
            return !DuplexConsoleView.this.isPrimaryConsoleEnabled();
        }

        public void setSelected(final AnActionEvent event, boolean flag) {
            DuplexConsoleView.this.enableConsole(!flag);
            DuplexConsoleView.this.setStoredState(!flag);
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    SwitchDuplexConsoleViewAction.this.update(event);
                }
            });
        }

        public void update(@NotNull AnActionEvent event) {
            boolean isRunning;
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/console/DuplexConsoleView$SwitchDuplexConsoleViewAction", "update"));
            }
            super.update(event);
            Presentation presentation = event.getPresentation();
            boolean bl = isRunning = DuplexConsoleView.this.myProcessHandler != null && !DuplexConsoleView.this.myProcessHandler.isProcessTerminated();
            if (isRunning) {
                presentation.setEnabled(true);
            } else {
                DuplexConsoleView.this.enableConsole(true);
                presentation.putClientProperty("selected", (Object)false);
                presentation.setEnabled(false);
            }
        }
    }
}

