/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.rmi;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.rmi.RemoteDeadHand;
import com.intellij.execution.rmi.RemoteServer;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.execution.runners.DefaultProgramRunner;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.rmi.PortableRemoteObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RemoteProcessSupport<Target, EntryPoint, Parameters> {
    public static final Logger LOG = Logger.getInstance((String)("#" + RemoteProcessSupport.class));
    private final Class<EntryPoint> myValueClass;
    private final HashMap<Pair<Target, Parameters>, Info> myProcMap = new HashMap();

    public RemoteProcessSupport(Class<EntryPoint> valueClass) {
        this.myValueClass = valueClass;
    }

    protected abstract void fireModificationCountChanged();

    protected abstract String getName(Target var1);

    protected void logText(Parameters configuration, ProcessEvent event, Key outputType, Object info) {
    }

    public void stopAll() {
        this.stopAll(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAll(boolean wait) {
        ArrayList allHandlers = new ArrayList();
        Iterator iterator = this.myProcMap;
        synchronized (iterator) {
            for (Info o : this.myProcMap.values()) {
                ContainerUtil.addIfNotNull((Object)o.handler, allHandlers);
            }
        }
        for (ProcessHandler handler : allHandlers) {
            handler.destroyProcess();
        }
        if (wait) {
            for (ProcessHandler handler : allHandlers) {
                handler.waitFor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Parameters> getActiveConfigurations(@NotNull Target target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/execution/rmi/RemoteProcessSupport", "getActiveConfigurations"));
        }
        ArrayList<Object> result = new ArrayList<Object>();
        HashMap<Pair<Target, Parameters>, Info> hashMap = this.myProcMap;
        synchronized (hashMap) {
            for (Pair<Target, Parameters> pair : this.myProcMap.keySet()) {
                if (pair.first != target) continue;
                result.add(pair.second);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Pair<Target, Parameters>> getActiveConfigurations() {
        HashMap<Pair<Target, Parameters>, Info> hashMap = this.myProcMap;
        synchronized (hashMap) {
            return new HashSet(this.myProcMap.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryPoint acquire(@NotNull Target target, @NotNull Parameters configuration) throws Exception {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/execution/rmi/RemoteProcessSupport", "acquire"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/execution/rmi/RemoteProcessSupport", "acquire"));
        }
        ApplicationManagerEx.getApplicationEx().assertTimeConsuming();
        Ref ref = Ref.create(null);
        Pair key = Pair.create(target, configuration);
        if (!this.getExistingInfo((Ref<RunningInfo>)ref, key)) {
            this.startProcess(target, configuration, key);
            if (ref.isNull()) {
                try {
                    Ref ref2 = ref;
                    synchronized (ref2) {
                        while (ref.isNull()) {
                            ref.wait(1000L);
                            ProgressManager.checkCanceled();
                        }
                    }
                }
                catch (InterruptedException e) {
                    ProgressManager.checkCanceled();
                }
            }
        }
        if (ref.isNull()) {
            throw new RuntimeException("Unable to acquire remote proxy for: " + this.getName(target));
        }
        RunningInfo info = (RunningInfo)ref.get();
        if (info.handler == null) {
            String message = info.name;
            if (message != null && message.startsWith("ERROR: transport error 202:")) {
                message = "Unable to start java process in debug mode: -Xdebug parameters are already in use.";
            }
            throw new ExecutionException(message);
        }
        return this.acquire(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(@NotNull Target target, @Nullable Parameters configuration) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/execution/rmi/RemoteProcessSupport", "release"));
        }
        ArrayList handlers = new ArrayList();
        HashMap<Pair<Target, Parameters>, Info> hashMap = this.myProcMap;
        synchronized (hashMap) {
            for (Pair<Target, Parameters> key : this.myProcMap.keySet()) {
                if (key.first != target || configuration != null && key.second != configuration) continue;
                ContainerUtil.addIfNotNull((Object)this.myProcMap.get(key).handler, handlers);
            }
        }
        if (handlers.isEmpty()) {
            return;
        }
        for (ProcessHandler handler : handlers) {
            handler.destroyProcess();
        }
        this.fireModificationCountChanged();
    }

    private void startProcess(Target target, Parameters configuration, @NotNull Pair<Target, Parameters> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/execution/rmi/RemoteProcessSupport", "startProcess"));
        }
        DefaultProgramRunner runner = new DefaultProgramRunner(){

            @NotNull
            public String getRunnerId() {
                if ("MyRunner" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/rmi/RemoteProcessSupport$1", "getRunnerId"));
                }
                return "MyRunner";
            }

            public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
                if (executorId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/intellij/execution/rmi/RemoteProcessSupport$1", "canRun"));
                }
                if (profile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/execution/rmi/RemoteProcessSupport$1", "canRun"));
                }
                return true;
            }
        };
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        ProcessHandler processHandler2 = null;
        try {
            RunProfileState state = this.getRunProfileState(target, configuration, executor);
            ExecutionResult result = state.execute(executor, (ProgramRunner)runner);
            processHandler2 = result.getProcessHandler();
        }
        catch (Exception e) {
            this.dropProcessInfo(key, e instanceof ExecutionException ? e.getMessage() : ExceptionUtil.getUserStackTrace((Throwable)e, (Logger)LOG), processHandler2);
            return;
        }
        processHandler2.addProcessListener(this.getProcessListener(key));
        processHandler2.startNotify();
    }

    protected abstract RunProfileState getRunProfileState(Target var1, Parameters var2, Executor var3) throws ExecutionException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getExistingInfo(@NotNull Ref<RunningInfo> ref, @NotNull Pair<Target, Parameters> key) {
        Info info;
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/execution/rmi/RemoteProcessSupport", "getExistingInfo"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/execution/rmi/RemoteProcessSupport", "getExistingInfo"));
        }
        HashMap<Pair<Target, Parameters>, Info> hashMap = this.myProcMap;
        synchronized (hashMap) {
            info = this.myProcMap.get(key);
            try {
                while (info != null && (!(info instanceof RunningInfo) || info.handler.isProcessTerminating() || info.handler.isProcessTerminated())) {
                    this.myProcMap.wait(1000L);
                    ProgressManager.checkCanceled();
                    info = this.myProcMap.get(key);
                }
            }
            catch (InterruptedException e) {
                ProgressManager.checkCanceled();
            }
            if (info == null) {
                this.myProcMap.put(key, new PendingInfo(ref, null));
            }
        }
        if (info instanceof RunningInfo) {
            hashMap = ref;
            synchronized (hashMap) {
                ref.set((Object)((RunningInfo)info));
                ref.notifyAll();
            }
        }
        return info != null;
    }

    private EntryPoint acquire(final RunningInfo port) throws Exception {
        Object result;
        port.entryPointHardRef = result = RemoteUtil.executeWithClassLoader((ThrowableComputable)new ThrowableComputable<EntryPoint, Exception>(){

            public EntryPoint compute() throws Exception {
                Registry registry = LocateRegistry.getRegistry("localhost", port.port);
                Remote remote = (Remote)ObjectUtils.assertNotNull((Object)registry.lookup(port.name));
                if (Remote.class.isAssignableFrom(RemoteProcessSupport.this.myValueClass)) {
                    Object entryPoint = RemoteProcessSupport.narrowImpl(remote, RemoteProcessSupport.this.myValueClass);
                    if (entryPoint == null) {
                        return null;
                    }
                    return RemoteUtil.substituteClassLoader((Object)entryPoint, (ClassLoader)RemoteProcessSupport.this.myValueClass.getClassLoader());
                }
                return RemoteUtil.castToLocal((Object)remote, (Class)RemoteProcessSupport.this.myValueClass);
            }
        }, (ClassLoader)this.getClass().getClassLoader());
        return (EntryPoint)result;
    }

    @Nullable
    private static <T> T narrowImpl(@Nullable Remote remote, @NotNull Class<T> to) {
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/execution/rmi/RemoteProcessSupport", "narrowImpl"));
        }
        return (T)(to.isInstance(remote) ? remote : PortableRemoteObject.narrow((Object)remote, to));
    }

    private ProcessListener getProcessListener(final @NotNull Pair<Target, Parameters> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/execution/rmi/RemoteProcessSupport", "getProcessListener"));
        }
        return new ProcessListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void startNotified(ProcessEvent event) {
                ProcessHandler processHandler2 = event.getProcessHandler();
                processHandler2.putUserData(ProcessHandler.SILENTLY_DESTROY_ON_CLOSE, (Object)Boolean.TRUE);
                HashMap hashMap = RemoteProcessSupport.this.myProcMap;
                synchronized (hashMap) {
                    Info o = (Info)RemoteProcessSupport.this.myProcMap.get(key);
                    if (o instanceof PendingInfo) {
                        RemoteProcessSupport.this.myProcMap.put(key, new PendingInfo(((PendingInfo)o).ref, processHandler2));
                    }
                }
            }

            public void processTerminated(ProcessEvent event) {
                if (RemoteProcessSupport.this.dropProcessInfo(key, null, event.getProcessHandler())) {
                    RemoteProcessSupport.this.fireModificationCountChanged();
                }
            }

            public void processWillTerminate(ProcessEvent event, boolean willBeDestroyed) {
                if (RemoteProcessSupport.this.dropProcessInfo(key, null, event.getProcessHandler())) {
                    RemoteProcessSupport.this.fireModificationCountChanged();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onTextAvailable(ProcessEvent event, Key outputType) {
                PendingInfo info;
                String text = StringUtil.notNullize((String)event.getText());
                if (outputType == ProcessOutputTypes.STDERR) {
                    LOG.warn(text.trim());
                } else {
                    LOG.info(text.trim());
                }
                RunningInfo result = null;
                Ref<RunningInfo> ref = RemoteProcessSupport.this.myProcMap;
                synchronized (ref) {
                    Info o = (Info)RemoteProcessSupport.this.myProcMap.get(key);
                    RemoteProcessSupport.this.logText(key.second, event, outputType, o);
                    if (o instanceof PendingInfo) {
                        info = (PendingInfo)o;
                        if (outputType == ProcessOutputTypes.STDOUT) {
                            String prefix = "Port/ID:";
                            if (text.startsWith(prefix)) {
                                String pair = text.substring(prefix.length()).trim();
                                int idx = pair.indexOf("/");
                                result = new RunningInfo(info.handler, Integer.parseInt(pair.substring(0, idx)), pair.substring(idx + 1));
                                RemoteProcessSupport.this.myProcMap.put(key, result);
                                RemoteProcessSupport.this.myProcMap.notifyAll();
                            }
                        } else if (outputType == ProcessOutputTypes.STDERR) {
                            info.stderr.append(text);
                        }
                    } else {
                        info = null;
                    }
                }
                if (result != null) {
                    ref = info.ref;
                    synchronized (ref) {
                        info.ref.set(result);
                        info.ref.notifyAll();
                    }
                    RemoteProcessSupport.this.fireModificationCountChanged();
                    try {
                        RemoteDeadHand.TwoMinutesTurkish.startCooking((String)"localhost", (int)result.port);
                    }
                    catch (Exception e) {
                        LOG.warn("The cook failed to start due to " + ExceptionUtil.getRootCause((Throwable)e));
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dropProcessInfo(Pair<Target, Parameters> key, @Nullable String errorMessage, @Nullable ProcessHandler handler) {
        Info info;
        HashMap<Pair<Target, Parameters>, Info> hashMap = this.myProcMap;
        synchronized (hashMap) {
            info = this.myProcMap.get(key);
            if (info != null && (handler == null || info.handler == handler)) {
                this.myProcMap.remove(key);
                this.myProcMap.notifyAll();
            } else {
                info = null;
            }
        }
        if (info instanceof PendingInfo) {
            PendingInfo pendingInfo = (PendingInfo)info;
            if (pendingInfo.stderr.length() > 0 || pendingInfo.ref.isNull()) {
                if (errorMessage != null) {
                    pendingInfo.stderr.append(errorMessage);
                }
                pendingInfo.ref.set((Object)new RunningInfo(null, -1, pendingInfo.stderr.toString()));
            }
            Ref<RunningInfo> ref = pendingInfo.ref;
            synchronized (ref) {
                pendingInfo.ref.notifyAll();
            }
        }
        return info != null;
    }

    static {
        RemoteServer.setupRMI();
    }

    private static class RunningInfo
    extends Info {
        final int port;
        final String name;
        Object entryPointHardRef;

        RunningInfo(ProcessHandler handler, int port, String name) {
            super(handler);
            this.port = port;
            this.name = name;
        }
    }

    private static class PendingInfo
    extends Info {
        final Ref<RunningInfo> ref;
        final StringBuilder stderr = new StringBuilder();

        PendingInfo(Ref<RunningInfo> ref, ProcessHandler handler) {
            super(handler);
            this.ref = ref;
        }
    }

    private static class Info {
        final ProcessHandler handler;

        Info(ProcessHandler handler) {
            this.handler = handler;
        }
    }
}

