/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionHelper;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.console.ConsoleExecuteAction;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.console.ProcessBackedConsoleExecuteActionHandler;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.ide.CommonActionsManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.ui.JBColor;
import com.intellij.ui.SideBorder;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractConsoleRunnerWithHistory<T extends LanguageConsoleView> {
    private final String myConsoleTitle;
    private ProcessHandler myProcessHandler;
    private final String myWorkingDir;
    private T myConsoleView;
    @NotNull
    private final Project myProject;
    private ProcessBackedConsoleExecuteActionHandler myConsoleExecuteActionHandler;

    public AbstractConsoleRunnerWithHistory(@NotNull Project project, @NotNull String consoleTitle, @Nullable String workingDir) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/runners/AbstractConsoleRunnerWithHistory", "<init>"));
        }
        if (consoleTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleTitle", "com/intellij/execution/runners/AbstractConsoleRunnerWithHistory", "<init>"));
        }
        this.myProject = project;
        this.myConsoleTitle = consoleTitle;
        this.myWorkingDir = workingDir;
    }

    public void initAndRun() throws ExecutionException {
        final Process process = this.createProcess();
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                AbstractConsoleRunnerWithHistory.this.initConsoleUI(process);
            }
        });
    }

    private void initConsoleUI(Process process) {
        this.myConsoleView = this.createConsoleView();
        if (this.myConsoleView instanceof JComponent) {
            ((JComponent)this.myConsoleView).setBorder((Border)new SideBorder(JBColor.border(), 1));
        }
        this.myProcessHandler = this.createProcessHandler(process);
        this.myConsoleExecuteActionHandler = this.createExecuteActionHandler();
        ProcessTerminatedListener.attach((ProcessHandler)this.myProcessHandler);
        this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                AbstractConsoleRunnerWithHistory.this.finishConsole();
            }
        });
        this.myConsoleView.attachToProcess(this.myProcessHandler);
        this.createContentDescriptorAndActions();
        this.myProcessHandler.startNotify();
    }

    protected void createContentDescriptorAndActions() {
        Executor defaultExecutor = DefaultRunExecutor.getRunExecutorInstance();
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)toolbarActions, false);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)actionToolbar.getComponent(), "West");
        panel.add((Component)this.myConsoleView.getComponent(), "Center");
        actionToolbar.setTargetComponent((JComponent)panel);
        RunContentDescriptor contentDescriptor = new RunContentDescriptor(this.myConsoleView, this.myProcessHandler, (JComponent)panel, this.constructConsoleTitle(this.myConsoleTitle));
        contentDescriptor.setFocusComputable((Computable)new Computable<JComponent>(){

            public JComponent compute() {
                return AbstractConsoleRunnerWithHistory.this.getConsoleView().getConsoleEditor().getContentComponent();
            }
        });
        contentDescriptor.setAutoFocusContent(this.isAutoFocusContent());
        List<AnAction> actions2 = this.fillToolBarActions(toolbarActions, defaultExecutor, contentDescriptor);
        AbstractConsoleRunnerWithHistory.registerActionShortcuts(actions2, this.getConsoleView().getConsoleEditor().getComponent());
        AbstractConsoleRunnerWithHistory.registerActionShortcuts(actions2, panel);
        this.showConsole(defaultExecutor, contentDescriptor);
    }

    protected String constructConsoleTitle(@NotNull String consoleTitle) {
        if (consoleTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleTitle", "com/intellij/execution/runners/AbstractConsoleRunnerWithHistory", "constructConsoleTitle"));
        }
        if (this.shouldAddNumberToTitle()) {
            List<String> activeConsoleNames = this.getActiveConsoleNames(consoleTitle);
            int max = 0;
            for (String name : activeConsoleNames) {
                if (max == 0) {
                    max = 1;
                }
                try {
                    int num = Integer.parseInt(name.substring(consoleTitle.length() + 1, name.length() - 1));
                    if (num <= max) continue;
                    max = num;
                }
                catch (Exception exception) {}
            }
            if (max >= 1) {
                return consoleTitle + "(" + (max + 1) + ")";
            }
        }
        return consoleTitle;
    }

    public boolean isAutoFocusContent() {
        return true;
    }

    protected boolean shouldAddNumberToTitle() {
        return false;
    }

    protected void showConsole(Executor defaultExecutor, @NotNull RunContentDescriptor contentDescriptor) {
        if (contentDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentDescriptor", "com/intellij/execution/runners/AbstractConsoleRunnerWithHistory", "showConsole"));
        }
        ExecutionManager.getInstance((Project)this.myProject).getContentManager().showRunContent(defaultExecutor, contentDescriptor);
    }

    protected void finishConsole() {
        this.myConsoleView.setEditable(false);
    }

    protected abstract T createConsoleView();

    @Nullable
    protected abstract Process createProcess() throws ExecutionException;

    protected abstract OSProcessHandler createProcessHandler(Process var1);

    public static void registerActionShortcuts(List<AnAction> actions2, JComponent component) {
        for (AnAction action : actions2) {
            if (action.getShortcutSet() == null) continue;
            action.registerCustomShortcutSet(action.getShortcutSet(), component);
        }
    }

    protected List<AnAction> fillToolBarActions(DefaultActionGroup toolbarActions, Executor defaultExecutor, RunContentDescriptor contentDescriptor) {
        ArrayList actionList = ContainerUtil.newArrayList();
        actionList.add(this.createStopAction());
        actionList.add(this.createCloseAction(defaultExecutor, contentDescriptor));
        actionList.add(this.createConsoleExecAction(this.myConsoleExecuteActionHandler));
        actionList.add(CommonActionsManager.getInstance().createHelpAction("interactive_console"));
        toolbarActions.addAll((Collection)actionList);
        return actionList;
    }

    protected AnAction createCloseAction(Executor defaultExecutor, RunContentDescriptor myDescriptor) {
        return new CloseAction(defaultExecutor, myDescriptor, this.myProject);
    }

    protected AnAction createStopAction() {
        return ActionManager.getInstance().getAction("Stop");
    }

    protected AnAction createConsoleExecAction(@NotNull ProcessBackedConsoleExecuteActionHandler consoleExecuteActionHandler) {
        if (consoleExecuteActionHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleExecuteActionHandler", "com/intellij/execution/runners/AbstractConsoleRunnerWithHistory", "createConsoleExecAction"));
        }
        String emptyAction = consoleExecuteActionHandler.getEmptyExecuteAction();
        return new ConsoleExecuteAction((LanguageConsoleView)this.myConsoleView, consoleExecuteActionHandler, emptyAction, consoleExecuteActionHandler);
    }

    @NotNull
    protected abstract ProcessBackedConsoleExecuteActionHandler createExecuteActionHandler();

    public T getConsoleView() {
        return this.myConsoleView;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/runners/AbstractConsoleRunnerWithHistory", "getProject"));
        }
        return project;
    }

    public String getConsoleTitle() {
        return this.myConsoleTitle;
    }

    public String getWorkingDir() {
        return this.myWorkingDir;
    }

    public ProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    public ProcessBackedConsoleExecuteActionHandler getConsoleExecuteActionHandler() {
        return this.myConsoleExecuteActionHandler;
    }

    protected List<String> getActiveConsoleNames(String consoleTitle) {
        return this.getActiveConsolesFromRunToolWindow(consoleTitle);
    }

    protected List<String> getActiveConsolesFromRunToolWindow(final String consoleTitle) {
        List<RunContentDescriptor> consoles = ExecutionHelper.collectConsolesByDisplayName(this.myProject, new NotNullFunction<String, Boolean>(){

            @NotNull
            public Boolean fun(String dom) {
                Boolean bl = dom.contains(consoleTitle);
                if (bl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/runners/AbstractConsoleRunnerWithHistory$4", "fun"));
                }
                return bl;
            }
        });
        return FluentIterable.from(consoles).filter((Predicate)new Predicate<RunContentDescriptor>(){

            public boolean apply(RunContentDescriptor input) {
                ProcessHandler handler = input.getProcessHandler();
                return handler != null && !handler.isProcessTerminated();
            }
        }).transform((Function)new Function<RunContentDescriptor, String>(){

            public String apply(RunContentDescriptor input) {
                return input.getDisplayName();
            }
        }).toList();
    }
}

