/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.startup;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.startup.ProjectStartupConfigurationBase;
import com.intellij.execution.startup.ProjectStartupLocalConfiguration;
import com.intellij.execution.startup.ProjectStartupSharedConfiguration;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ProjectStartupTaskManager {
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.logOnlyGroup((String)"Project Startup Tasks Messages");
    @NonNls
    public static final String PREFIX = "Project Startup Tasks: ";
    private final Project myProject;
    private final ProjectStartupSharedConfiguration myShared;
    private final ProjectStartupLocalConfiguration myLocal;
    private final RunManagerEx myRunManager;

    public static ProjectStartupTaskManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/startup/ProjectStartupTaskManager", "getInstance"));
        }
        return (ProjectStartupTaskManager)ServiceManager.getService((Project)project, ProjectStartupTaskManager.class);
    }

    public ProjectStartupTaskManager(Project project, ProjectStartupSharedConfiguration shared, ProjectStartupLocalConfiguration local, @NotNull RunManager runManager) {
        if (runManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runManager", "com/intellij/execution/startup/ProjectStartupTaskManager", "<init>"));
        }
        this.myProject = project;
        this.myShared = shared;
        this.myLocal = local;
        this.myRunManager = (RunManagerEx)runManager;
        this.verifyState();
    }

    private void verifyState() {
        if (!this.myShared.isEmpty()) {
            Collection<RunnerAndConfigurationSettings> sharedConfigurations = this.getSharedConfigurations();
            ArrayList<RunnerAndConfigurationSettings> canNotBeShared = new ArrayList<RunnerAndConfigurationSettings>();
            Iterator<RunnerAndConfigurationSettings> iterator = sharedConfigurations.iterator();
            while (iterator.hasNext()) {
                RunnerAndConfigurationSettings configuration = iterator.next();
                if (this.myRunManager.isConfigurationShared(configuration)) continue;
                iterator.remove();
                canNotBeShared.add(configuration);
            }
            if (!canNotBeShared.isEmpty()) {
                canNotBeShared.addAll(this.getLocalConfigurations());
                this.setStartupConfigurations(sharedConfigurations, canNotBeShared);
            }
        }
    }

    public Collection<RunnerAndConfigurationSettings> getSharedConfigurations() {
        return this.getConfigurations(this.myShared);
    }

    public Collection<RunnerAndConfigurationSettings> getLocalConfigurations() {
        return this.getConfigurations(this.myLocal);
    }

    private Collection<RunnerAndConfigurationSettings> getConfigurations(ProjectStartupConfigurationBase configuration) {
        if (configuration.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RunnerAndConfigurationSettings> result = new ArrayList<RunnerAndConfigurationSettings>();
        List<ProjectStartupConfigurationBase.ConfigurationDescriptor> list = configuration.getList();
        for (ProjectStartupConfigurationBase.ConfigurationDescriptor descriptor : list) {
            RunnerAndConfigurationSettings settings = this.myRunManager.findConfigurationByName(descriptor.getName());
            if (settings != null && settings.getUniqueID().equals(descriptor.getId())) {
                result.add(settings);
                continue;
            }
            NOTIFICATION_GROUP.createNotification("Project Startup Tasks:  Run Configuration '" + descriptor.getName() + "' not found, removed from list.", MessageType.WARNING).notify(this.myProject);
        }
        return result;
    }

    public void rename(String oldId, RunnerAndConfigurationSettings settings) {
        if (this.myShared.rename(oldId, settings)) {
            return;
        }
        this.myLocal.rename(oldId, settings);
    }

    public void delete(String name) {
        if (this.myShared.deleteConfiguration(name)) {
            return;
        }
        this.myLocal.deleteConfiguration(name);
    }

    public void setStartupConfigurations(@NotNull Collection<RunnerAndConfigurationSettings> shared, @NotNull Collection<RunnerAndConfigurationSettings> local) {
        if (shared == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shared", "com/intellij/execution/startup/ProjectStartupTaskManager", "setStartupConfigurations"));
        }
        if (local == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "local", "com/intellij/execution/startup/ProjectStartupTaskManager", "setStartupConfigurations"));
        }
        this.myShared.setConfigurations(shared);
        this.myLocal.setConfigurations(local);
    }

    public boolean isEmpty() {
        return this.myShared.isEmpty() && this.myLocal.isEmpty();
    }

    public void checkOnChange(RunnerAndConfigurationSettings settings) {
        Collection<RunnerAndConfigurationSettings> sharedConfigurations;
        if (!this.myRunManager.isConfigurationShared(settings) && (sharedConfigurations = this.getSharedConfigurations()).remove(settings)) {
            ArrayList<RunnerAndConfigurationSettings> localConfigurations = new ArrayList<RunnerAndConfigurationSettings>(this.getLocalConfigurations());
            localConfigurations.add(settings);
            this.setStartupConfigurations(sharedConfigurations, localConfigurations);
            NOTIFICATION_GROUP.createNotification("Project Startup Tasks:  configuration was made \"not shared\", since included Run Configuration '" + settings.getName() + "' is not shared.", MessageType.WARNING).notify(this.myProject);
        }
    }
}

