/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.ui;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.TestStateStorage;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.LvcsHelper;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestTreeView;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.execution.testframework.ToolbarPanel;
import com.intellij.execution.testframework.TrackRunningTestUtil;
import com.intellij.execution.testframework.export.TestResultsXmlFormatter;
import com.intellij.execution.testframework.sm.SMRunnerUtil;
import com.intellij.execution.testframework.sm.TestHistoryConfiguration;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsListener;
import com.intellij.execution.testframework.sm.runner.SMTRunnerTreeBuilder;
import com.intellij.execution.testframework.sm.runner.SMTRunnerTreeStructure;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.history.ImportedTestConsoleProperties;
import com.intellij.execution.testframework.sm.runner.history.actions.AbstractImportTestsAction;
import com.intellij.execution.testframework.sm.runner.ui.PropagateSelectionHandler;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerTestTreeView;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerToolbarPanel;
import com.intellij.execution.testframework.sm.runner.ui.TestResultsViewer;
import com.intellij.execution.testframework.sm.runner.ui.TestsPresentationUtil;
import com.intellij.execution.testframework.sm.runner.ui.statistics.StatisticsPanel;
import com.intellij.execution.testframework.ui.TestResultsPanel;
import com.intellij.execution.testframework.ui.TestsProgressAnimator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.util.ColorProgressBar;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.JBColor;
import com.intellij.util.Alarm;
import com.intellij.util.PathUtil;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.update.Update;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SMTestRunnerResultsForm
extends TestResultsPanel
implements TestFrameworkRunningModel,
TestResultsViewer,
SMTRunnerEventsListener {
    @NonNls
    public static final String HISTORY_DATE_FORMAT = "yyyy.MM.dd 'at' HH'h' mm'm' ss's'";
    @NonNls
    private static final String DEFAULT_SM_RUNNER_SPLITTER_PROPERTY = "SMTestRunner.Splitter.Proportion";
    public static final Color DARK_YELLOW = JBColor.YELLOW.darker();
    private static final Logger LOG = Logger.getInstance((String)("#" + SMTestRunnerResultsForm.class.getName()));
    private SMTRunnerTestTreeView myTreeView;
    private TestsProgressAnimator myAnimator;
    private final SMTestProxy.SMRootTestProxy myTestsRootNode;
    private SMTRunnerTreeBuilder myTreeBuilder;
    private final List<TestResultsViewer.EventsListener> myEventListeners;
    private PropagateSelectionHandler myShowStatisticForProxyHandler;
    private final Project myProject;
    private int myTotalTestCount;
    private int myStartedTestCount;
    private int myFinishedTestCount;
    private int myFailedTestCount;
    private int myIgnoredTestCount;
    private long myStartTime;
    private long myEndTime;
    private StatisticsPanel myStatisticsPane;
    private String myCurrentCustomProgressCategory;
    private final Set<String> myMentionedCategories;
    private boolean myTestsRunning;
    private AbstractTestProxy myLastSelected;
    private Alarm myUpdateQueue;
    private Set<Update> myRequests;

    public SMTestRunnerResultsForm(@NotNull JComponent console, TestConsoleProperties consoleProperties) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm", "<init>"));
        }
        this(console, AnAction.EMPTY_ARRAY, consoleProperties, null);
    }

    public SMTestRunnerResultsForm(@NotNull JComponent console, AnAction[] consoleActions, TestConsoleProperties consoleProperties, @Nullable String splitterPropertyName) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm", "<init>"));
        }
        super(console, consoleActions, consoleProperties, StringUtil.notNullize((String)splitterPropertyName, (String)DEFAULT_SM_RUNNER_SPLITTER_PROPERTY), 0.2f);
        this.myEventListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myTotalTestCount = 0;
        this.myStartedTestCount = 0;
        this.myFinishedTestCount = 0;
        this.myFailedTestCount = 0;
        this.myIgnoredTestCount = 0;
        this.myMentionedCategories = new LinkedHashSet<String>();
        this.myTestsRunning = true;
        this.myRequests = Collections.synchronizedSet(new HashSet());
        this.myProject = consoleProperties.getProject();
        this.myTestsRootNode = new SMTestProxy.SMRootTestProxy();
    }

    @Override
    public void initUI() {
        super.initUI();
        if (Registry.is((String)"tests.view.old.statistics.panel")) {
            KeyStroke shiftEnterKey = KeyStroke.getKeyStroke(10, 1);
            SMRunnerUtil.registerAsAction(shiftEnterKey, "show-statistics-for-test-proxy", new Runnable(){

                @Override
                public void run() {
                    SMTestRunnerResultsForm.this.showStatisticsForSelectedProxy();
                }
            }, (JComponent)((Object)this.myTreeView));
        }
    }

    @Override
    protected ToolbarPanel createToolbarPanel() {
        return new SMTRunnerToolbarPanel(this.myProperties, this, this);
    }

    @Override
    protected JComponent createTestTreeView() {
        this.myTreeView = new SMTRunnerTestTreeView();
        this.myTreeView.setLargeModel(true);
        this.myTreeView.attachToModel(this);
        this.myTreeView.setTestResultsViewer(this);
        if (Registry.is((String)"tests.view.old.statistics.panel")) {
            this.addTestsTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    AbstractTestProxy selectedTest = SMTestRunnerResultsForm.this.getTreeView().getSelectedTest();
                    if (selectedTest instanceof SMTestProxy) {
                        SMTestRunnerResultsForm.this.myStatisticsPane.selectProxy((SMTestProxy)selectedTest, this, false);
                    }
                }
            });
        }
        SMTRunnerTreeStructure structure = new SMTRunnerTreeStructure(this.myProject, this.myTestsRootNode);
        this.myTreeBuilder = new SMTRunnerTreeBuilder((JTree)((Object)this.myTreeView), structure);
        this.myTreeBuilder.setTestsComparator(TestConsoleProperties.SORT_ALPHABETICALLY.value((AbstractProperty.AbstractPropertyContainer)this.myProperties));
        Disposer.register((Disposable)this, (Disposable)this.myTreeBuilder);
        this.myAnimator = new TestsProgressAnimator(this.myTreeBuilder);
        TrackRunningTestUtil.installStopListeners((JTree)((Object)this.myTreeView), this.myProperties, new Pass<AbstractTestProxy>(){

            public void pass(AbstractTestProxy testProxy) {
                AbstractTestProxy firstChild;
                List<? extends AbstractTestProxy> children;
                if (testProxy == null) {
                    return;
                }
                while (!testProxy.isLeaf() && !(children = testProxy.getChildren()).isEmpty() && (firstChild = children.get(0)) != null) {
                    testProxy = firstChild;
                }
                SMTestRunnerResultsForm.this.myLastSelected = testProxy;
            }
        });
        this.myUpdateQueue = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        return this.myTreeView;
    }

    @Override
    protected JComponent createStatisticsPanel() {
        StatisticsPanel statisticsPane = new StatisticsPanel(this.myProject, this);
        statisticsPane.addPropagateSelectionListener(this.createSelectMeListener());
        this.setShowStatisticForProxyHandler(statisticsPane.createSelectMeListener());
        this.myStatisticsPane = statisticsPane;
        return this.myStatisticsPane.getContentPane();
    }

    public StatisticsPanel getStatisticsPane() {
        return this.myStatisticsPane;
    }

    public void addTestsTreeSelectionListener(TreeSelectionListener listener) {
        this.myTreeView.getSelectionModel().addTreeSelectionListener(listener);
    }

    @Override
    public void setShowStatisticForProxyHandler(PropagateSelectionHandler handler) {
        this.myShowStatisticForProxyHandler = handler;
    }

    @Override
    public void onTestingStarted(@NotNull SMTestProxy.SMRootTestProxy testsRoot) {
        if (testsRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testsRoot", "com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm", "onTestingStarted"));
        }
        this.myAnimator.setCurrentTestCase(this.myTestsRootNode);
        this.myTreeBuilder.updateFromRoot();
        this.myStatusLine.setStatusColor(ColorProgressBar.GREEN);
        this.selectAndNotify(this.myTestsRootNode);
        this.myStartTime = System.currentTimeMillis();
        boolean printTestingStartedTime = true;
        if (this.myProperties instanceof SMTRunnerConsoleProperties) {
            printTestingStartedTime = ((SMTRunnerConsoleProperties)this.myProperties).isPrintTestingStartedTime();
        }
        if (printTestingStartedTime) {
            this.myTestsRootNode.addSystemOutput("Testing started at " + DateFormatUtil.formatTime((long)this.myStartTime) + " ...\n");
        }
        this.updateStatusLabel(false);
        this.fireOnTestingStarted();
    }

    @Override
    public void onTestingFinished(@NotNull SMTestProxy.SMRootTestProxy testsRoot) {
        if (testsRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testsRoot", "com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm", "onTestingFinished"));
        }
        this.myEndTime = System.currentTimeMillis();
        if (this.myTotalTestCount == 0) {
            this.myTotalTestCount = this.myStartedTestCount;
            this.myStatusLine.setFraction(1.0);
        }
        this.updateStatusLabel(true);
        this.updateIconProgress(true);
        this.myAnimator.stopMovie();
        this.myTreeBuilder.updateFromRoot();
        LvcsHelper.addLabel(this);
        Runnable onDone = new Runnable(){

            @Override
            public void run() {
                SMTestRunnerResultsForm.this.myTestsRunning = false;
                boolean sortByDuration = TestConsoleProperties.SORT_BY_DURATION.value((AbstractProperty.AbstractPropertyContainer)SMTestRunnerResultsForm.this.myProperties);
                if (sortByDuration) {
                    SMTestRunnerResultsForm.this.myTreeBuilder.setStatisticsComparator(SMTestRunnerResultsForm.this.myProperties, sortByDuration);
                }
            }
        };
        if (this.myLastSelected == null) {
            this.selectAndNotify(this.myTestsRootNode, onDone);
        } else {
            onDone.run();
        }
        this.fireOnTestingFinished();
        if (testsRoot.wasTerminated() && this.myStatusLine.getStatusColor() == ColorProgressBar.GREEN) {
            this.myStatusLine.setStatusColor((Color)JBColor.LIGHT_GRAY);
        }
        if (testsRoot.isEmptySuite() && testsRoot.isTestsReporterAttached() && this.myProperties instanceof SMTRunnerConsoleProperties && ((SMTRunnerConsoleProperties)this.myProperties).fixEmptySuite()) {
            return;
        }
        TestsUIUtil.TestResultPresentation presentation = new TestsUIUtil.TestResultPresentation(testsRoot, this.myStartTime > 0L, null).getPresentation(this.myFailedTestCount, this.myFinishedTestCount - this.myFailedTestCount - this.myIgnoredTestCount, this.myTotalTestCount - this.myFinishedTestCount, this.myIgnoredTestCount);
        TestsUIUtil.notifyByBalloon(this.myProperties.getProject(), testsRoot, this.myProperties, presentation);
        SMTestRunnerResultsForm.addToHistory(testsRoot, this.myProperties, this);
    }

    private static void addToHistory(SMTestProxy.SMRootTestProxy root, TestConsoleProperties consoleProperties, Disposable parentDisposable) {
        RunProfile configuration = consoleProperties.getConfiguration();
        if (configuration instanceof RunConfiguration && !(consoleProperties instanceof ImportedTestConsoleProperties)) {
            final MySaveHistoryTask backgroundable = new MySaveHistoryTask(consoleProperties, root, (RunConfiguration)configuration);
            final BackgroundableProcessIndicator processIndicator = new BackgroundableProcessIndicator(backgroundable);
            Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

                public void dispose() {
                    processIndicator.cancel();
                    backgroundable.dispose();
                }
            });
            Disposer.register((Disposable)parentDisposable, (Disposable)processIndicator);
            ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)backgroundable, (ProgressIndicator)processIndicator);
        }
    }

    @Override
    public void onTestsCountInSuite(int count) {
        this.updateCountersAndProgressOnTestCount(count, false);
    }

    @Override
    public void onTestStarted(@NotNull SMTestProxy testProxy) {
        if (testProxy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testProxy", "com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm", "onTestStarted"));
        }
        if (!testProxy.isConfig()) {
            this.updateOnTestStarted(false);
        }
        this._addTestOrSuite(testProxy);
        this.fireOnTestNodeAdded(testProxy);
    }

    @Override
    public void onSuiteTreeNodeAdded(SMTestProxy testProxy) {
        ++this.myTotalTestCount;
    }

    @Override
    public void onSuiteTreeStarted(SMTestProxy suite) {
    }

    @Override
    public void onTestFailed(@NotNull SMTestProxy test) {
        if (test == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "test", "com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm", "onTestFailed"));
        }
        this.updateOnTestFailed(false);
        if (test.isConfig()) {
            ++this.myStartedTestCount;
            ++this.myFinishedTestCount;
        }
        this.updateIconProgress(false);
        if (this.myLastSelected != null && TestConsoleProperties.TRACK_RUNNING_TEST.value((AbstractProperty.AbstractPropertyContainer)this.myProperties) && TestConsoleProperties.HIDE_PASSED_TESTS.value((AbstractProperty.AbstractPropertyContainer)this.myProperties)) {
            this.myTreeBuilder.expand(test, null);
        }
    }

    @Override
    public void onTestIgnored(@NotNull SMTestProxy test) {
        if (test == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "test", "com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm", "onTestIgnored"));
        }
        this.updateOnTestIgnored();
    }

    @Override
    public void onSuiteStarted(@NotNull SMTestProxy newSuite) {
        if (newSuite == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSuite", "com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm", "onSuiteStarted"));
        }
        this._addTestOrSuite(newSuite);
    }

    @Override
    public void onCustomProgressTestsCategory(@Nullable String categoryName, int testCount) {
        this.myCurrentCustomProgressCategory = categoryName;
        this.updateCountersAndProgressOnTestCount(testCount, true);
    }

    @Override
    public void onCustomProgressTestStarted() {
        this.updateOnTestStarted(true);
    }

    @Override
    public void onCustomProgressTestFailed() {
        this.updateOnTestFailed(true);
    }

    @Override
    public void onCustomProgressTestFinished() {
        this.updateOnTestFinished(true);
    }

    @Override
    public void onTestFinished(@NotNull SMTestProxy test) {
        if (test == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "test", "com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm", "onTestFinished"));
        }
        if (!test.isConfig()) {
            this.updateOnTestFinished(false);
        }
        this.updateIconProgress(false);
    }

    @Override
    public void onSuiteFinished(@NotNull SMTestProxy suite) {
        if (suite == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suite", "com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm", "onSuiteFinished"));
        }
    }

    @Override
    public SMTestProxy.SMRootTestProxy getTestsRootNode() {
        return this.myTestsRootNode;
    }

    @Override
    public TestConsoleProperties getProperties() {
        return this.myProperties;
    }

    @Override
    public void setFilter(Filter filter) {
        SMTRunnerTreeStructure treeStructure = this.myTreeBuilder.getSMRunnerTreeStructure();
        treeStructure.setFilter(filter);
        this.myTreeBuilder.queueUpdate();
    }

    @Override
    public boolean isRunning() {
        return this.myTestsRunning;
    }

    @Override
    public TestTreeView getTreeView() {
        return this.myTreeView;
    }

    @Override
    public SMTRunnerTreeBuilder getTreeBuilder() {
        return this.myTreeBuilder;
    }

    @Override
    public boolean hasTestSuites() {
        return this.getRoot().getChildren().size() > 0;
    }

    @Override
    @NotNull
    public AbstractTestProxy getRoot() {
        SMTestProxy.SMRootTestProxy sMRootTestProxy = this.myTestsRootNode;
        if (sMRootTestProxy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm", "getRoot"));
        }
        return sMRootTestProxy;
    }

    @Override
    public void selectAndNotify(AbstractTestProxy testProxy) {
        this.selectAndNotify(testProxy, null);
    }

    private void selectAndNotify(@Nullable AbstractTestProxy testProxy, @Nullable Runnable onDone) {
        this.selectWithoutNotify(testProxy, onDone);
        if (Registry.is((String)"tests.view.old.statistics.panel")) {
            this.showStatisticsForSelectedProxy(testProxy, false);
        }
    }

    @Override
    public void addEventsListener(final TestResultsViewer.EventsListener listener) {
        this.myEventListeners.add(listener);
        this.addTestsTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                SMTestProxy selectedProxy = (SMTestProxy)SMTestRunnerResultsForm.this.getTreeView().getSelectedTest();
                listener.onSelected(selectedProxy, SMTestRunnerResultsForm.this, SMTestRunnerResultsForm.this);
            }
        });
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myShowStatisticForProxyHandler = null;
        this.myEventListeners.clear();
        this.myStatisticsPane.doDispose();
    }

    @Override
    public void showStatisticsForSelectedProxy() {
        TestConsoleProperties.SHOW_STATISTICS.set((AbstractProperty.AbstractPropertyContainer)this.myProperties, (Object)true);
        AbstractTestProxy selectedProxy = this.myTreeView.getSelectedTest();
        this.showStatisticsForSelectedProxy(selectedProxy, true);
    }

    private void showStatisticsForSelectedProxy(AbstractTestProxy selectedProxy, boolean requestFocus) {
        if (selectedProxy instanceof SMTestProxy && this.myShowStatisticForProxyHandler != null) {
            this.myShowStatisticForProxyHandler.handlePropagateSelectionRequest((SMTestProxy)selectedProxy, this, requestFocus);
        }
    }

    protected int getTotalTestCount() {
        return this.myTotalTestCount;
    }

    protected int getStartedTestCount() {
        return this.myStartedTestCount;
    }

    protected int getFinishedTestCount() {
        return this.myFinishedTestCount;
    }

    protected int getFailedTestCount() {
        return this.myFailedTestCount;
    }

    protected int getIgnoredTestCount() {
        return this.myIgnoredTestCount;
    }

    protected Color getTestsStatusColor() {
        return this.myStatusLine.getStatusColor();
    }

    public Set<String> getMentionedCategories() {
        return this.myMentionedCategories;
    }

    protected long getStartTime() {
        return this.myStartTime;
    }

    protected long getEndTime() {
        return this.myEndTime;
    }

    private void _addTestOrSuite(@NotNull SMTestProxy newTestOrSuite) {
        if (newTestOrSuite == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTestOrSuite", "com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm", "_addTestOrSuite"));
        }
        final SMTestProxy parentSuite = newTestOrSuite.getParent();
        assert (parentSuite != null);
        Update update = new Update(parentSuite){

            public void run() {
                SMTestRunnerResultsForm.this.myRequests.remove((Object)this);
                SMTestRunnerResultsForm.this.myTreeBuilder.updateTestsSubtree(parentSuite);
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            update.run();
        } else if (this.myRequests.add(update) && !this.myUpdateQueue.isDisposed()) {
            this.myUpdateQueue.addRequest((Runnable)update, 100);
        }
        this.myTreeBuilder.repaintWithParents(newTestOrSuite);
        this.myAnimator.setCurrentTestCase(newTestOrSuite);
        if (TestConsoleProperties.TRACK_RUNNING_TEST.value((AbstractProperty.AbstractPropertyContainer)this.myProperties) && (this.myLastSelected == null || this.myLastSelected == newTestOrSuite)) {
            this.myLastSelected = null;
            this.selectAndNotify(newTestOrSuite);
        }
    }

    private void fireOnTestNodeAdded(SMTestProxy test) {
        for (TestResultsViewer.EventsListener eventListener : this.myEventListeners) {
            eventListener.onTestNodeAdded(this, test);
        }
    }

    private void fireOnTestingFinished() {
        for (TestResultsViewer.EventsListener eventListener : this.myEventListeners) {
            eventListener.onTestingFinished(this);
        }
    }

    private void fireOnTestingStarted() {
        for (TestResultsViewer.EventsListener eventListener : this.myEventListeners) {
            eventListener.onTestingStarted(this);
        }
    }

    private void selectWithoutNotify(final AbstractTestProxy testProxy, final @Nullable Runnable onDone) {
        if (testProxy == null) {
            return;
        }
        SMRunnerUtil.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                if (SMTestRunnerResultsForm.this.myTreeBuilder.isDisposed()) {
                    return;
                }
                SMTestRunnerResultsForm.this.myTreeBuilder.select(testProxy, onDone);
            }
        }, ModalityState.NON_MODAL);
    }

    private void updateStatusLabel(boolean testingFinished) {
        boolean launchedAndFinished;
        if (this.myFailedTestCount > 0) {
            this.myStatusLine.setStatusColor(ColorProgressBar.RED);
        }
        if (testingFinished && this.myTotalTestCount == 0) {
            this.myStatusLine.setStatusColor((Color)(this.myTestsRootNode.wasLaunched() || !this.myTestsRootNode.isTestsReporterAttached() ? JBColor.LIGHT_GRAY : ColorProgressBar.RED));
        }
        boolean bl = launchedAndFinished = this.myTestsRootNode.wasLaunched() && !this.myTestsRootNode.isInProgress();
        if (!TestsPresentationUtil.hasNonDefaultCategories(this.myMentionedCategories)) {
            this.myStatusLine.formatTestMessage(this.myTotalTestCount, this.myFinishedTestCount, this.myFailedTestCount, this.myIgnoredTestCount, this.myTestsRootNode.getDuration(), this.myEndTime);
        } else {
            this.myStatusLine.setText(TestsPresentationUtil.getProgressStatus_Text(this.myStartTime, this.myEndTime, this.myTotalTestCount, this.myFinishedTestCount, this.myFailedTestCount, this.myMentionedCategories, launchedAndFinished));
        }
    }

    public void performUpdate() {
        this.myTreeBuilder.performUpdate();
    }

    private void updateIconProgress(boolean updateWithAttention) {
        int doneTestCount;
        int totalTestCount;
        if (this.myTotalTestCount == 0) {
            totalTestCount = 2;
            doneTestCount = 1;
        } else {
            totalTestCount = this.myTotalTestCount;
            doneTestCount = this.myFinishedTestCount;
        }
        TestsUIUtil.showIconProgress(this.myProject, doneTestCount, totalTestCount, this.myFailedTestCount, updateWithAttention);
    }

    public PropagateSelectionHandler createSelectMeListener() {
        return new PropagateSelectionHandler(){

            @Override
            public void handlePropagateSelectionRequest(final @Nullable SMTestProxy selectedTestProxy, @NotNull Object sender, final boolean requestFocus) {
                if (sender == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sender", "com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm$9", "handlePropagateSelectionRequest"));
                }
                SMRunnerUtil.addToInvokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SMTestRunnerResultsForm.this.selectWithoutNotify(selectedTestProxy, null);
                        if (requestFocus) {
                            IdeFocusManager.getInstance((Project)SMTestRunnerResultsForm.this.myProject).requestFocus((Component)((Object)SMTestRunnerResultsForm.this.myTreeView), true);
                        }
                    }
                });
            }
        };
    }

    private void updateCountersAndProgressOnTestCount(int count, boolean isCustomMessage) {
        if (!this.isModeConsistent(isCustomMessage)) {
            return;
        }
        this.myTotalTestCount += count;
        this.updateStatusLabel(false);
    }

    private void updateOnTestStarted(boolean isCustomMessage) {
        if (!this.isModeConsistent(isCustomMessage)) {
            return;
        }
        this.myMentionedCategories.add(this.myCurrentCustomProgressCategory != null ? this.myCurrentCustomProgressCategory : "Tests");
        ++this.myStartedTestCount;
        if (this.myStartedTestCount > this.myTotalTestCount && this.myTotalTestCount != 0) {
            this.myTotalTestCount = this.myStartedTestCount;
        }
        this.updateStatusLabel(false);
    }

    private void updateProgressOnTestDone() {
        int doneTestCount = this.myFinishedTestCount;
        if (this.myTotalTestCount != 0) {
            this.myStatusLine.setFraction((double)doneTestCount / (double)this.myTotalTestCount);
        } else {
            this.myStatusLine.setFraction(doneTestCount > 0 ? 0.5 : 0.0);
        }
    }

    private void updateOnTestFailed(boolean isCustomMessage) {
        if (!this.isModeConsistent(isCustomMessage)) {
            return;
        }
        ++this.myFailedTestCount;
        this.updateProgressOnTestDone();
        this.updateStatusLabel(false);
    }

    private void updateOnTestFinished(boolean isCustomMessage) {
        if (!this.isModeConsistent(isCustomMessage)) {
            return;
        }
        ++this.myFinishedTestCount;
        this.updateProgressOnTestDone();
    }

    private void updateOnTestIgnored() {
        ++this.myIgnoredTestCount;
        this.updateProgressOnTestDone();
        this.updateStatusLabel(false);
    }

    private boolean isModeConsistent(boolean isCustomMessage) {
        return isCustomMessage != (this.myCurrentCustomProgressCategory == null);
    }

    private static class MySaveHistoryTask
    extends Task.Backgroundable {
        private final TestConsoleProperties myConsoleProperties;
        private SMTestProxy.SMRootTestProxy myRoot;
        private RunConfiguration myConfiguration;
        private File myOutputFile;

        public MySaveHistoryTask(TestConsoleProperties consoleProperties, SMTestProxy.SMRootTestProxy root, RunConfiguration configuration) {
            super(consoleProperties.getProject(), "Save Test Results", true);
            this.myConsoleProperties = consoleProperties;
            this.myRoot = root;
            this.myConfiguration = configuration;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm$MySaveHistoryTask", "run"));
            }
            this.writeState();
            DaemonCodeAnalyzer.getInstance((Project)this.getProject()).restart();
            try {
                SAXTransformerFactory transformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
                TransformerHandler handler = transformerFactory.newTransformerHandler();
                handler.getTransformer().setOutputProperty("indent", "yes");
                handler.getTransformer().setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                String configurationNameIncludedDate = PathUtil.suggestFileName((String)this.myConfiguration.getName()) + " - " + new SimpleDateFormat(SMTestRunnerResultsForm.HISTORY_DATE_FORMAT).format(new Date());
                this.myOutputFile = new File(TestStateStorage.getTestHistoryRoot(this.myProject), configurationNameIncludedDate + ".xml");
                FileUtilRt.createParentDirs((File)this.myOutputFile);
                handler.setResult(new StreamResult(new FileWriter(this.myOutputFile)));
                SMTestProxy.SMRootTestProxy root = this.myRoot;
                RunConfiguration configuration = this.myConfiguration;
                if (root != null && configuration != null) {
                    TestResultsXmlFormatter.execute(root, configuration, this.myConsoleProperties, handler);
                }
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.info("Export to history failed", (Throwable)e);
            }
        }

        private void writeState() {
            TestStateStorage storage2 = TestStateStorage.getInstance(this.getProject());
            List<SMTestProxy> tests = this.myRoot.getAllTests();
            for (SMTestProxy proxy : tests) {
                String url = proxy instanceof SMTestProxy.SMRootTestProxy ? ((SMTestProxy.SMRootTestProxy)proxy).getRootLocation() : proxy.getLocationUrl();
                if (url == null) continue;
                storage2.writeState(url, new TestStateStorage.Record(proxy.getMagnitude(), new Date()));
            }
        }

        public void onSuccess() {
            if (this.myOutputFile != null && this.myOutputFile.exists()) {
                AbstractImportTestsAction.adjustHistory(this.myProject);
                TestHistoryConfiguration.getInstance(this.myProject).registerHistoryItem(this.myOutputFile.getName(), this.myConfiguration.getName(), this.myConfiguration.getType().getId());
            }
        }

        public void dispose() {
            this.myConfiguration = null;
            this.myRoot = null;
            this.myOutputFile = null;
        }
    }
}

