/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.InplaceActionButtonLook;
import com.intellij.ui.Gray;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;

class SearchWrapper
extends NonOpaquePanel
implements PropertyChangeListener,
FocusListener {
    private final JTextComponent myToWrap;

    public SearchWrapper(JTextComponent toWrap, AnAction showHistoryAction) {
        this.myToWrap = toWrap;
        this.setBorder((Border)JBUI.Borders.empty((int)6, (int)6, (int)6, (int)8));
        this.setLayout(new BorderLayout(JBUI.scale((int)4), 0));
        this.myToWrap.addPropertyChangeListener("background", this);
        this.myToWrap.addFocusListener(this);
        this.myToWrap.setBorder(null);
        this.myToWrap.setOpaque(false);
        JBScrollPane scrollPane = new JBScrollPane((Component)this.myToWrap, 20, 30);
        scrollPane.getVerticalScrollBar().setBackground(UIUtil.TRANSPARENT_COLOR);
        scrollPane.getViewport().setBorder(null);
        scrollPane.getViewport().setOpaque(false);
        scrollPane.setBorder((Border)JBUI.Borders.emptyRight((int)2));
        scrollPane.setOpaque(false);
        ActionButton button = new ActionButton(showHistoryAction, showHistoryAction.getTemplatePresentation(), "unknown", new Dimension(JBUI.scale((int)16), JBUI.scale((int)16)));
        button.setLook(new InplaceActionButtonLook());
        NonOpaquePanel p = new NonOpaquePanel((LayoutManager)new BorderLayout());
        p.add((Component)button, "North");
        this.add((Component)p, "West");
        this.add((Component)scrollPane, "Center");
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.repaint();
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics.create();
        try {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            Rectangle r = new Rectangle(this.getSize());
            r.x += JBUI.scale((int)4);
            r.y += JBUI.scale((int)3);
            r.width -= JBUI.scale((int)9);
            r.height -= JBUI.scale((int)6);
            int arcSize = Math.min(25, r.height - 1) - 6;
            g.setColor(this.myToWrap.getBackground());
            boolean hasFocus = this.myToWrap.hasFocus();
            g.fillRoundRect(r.x, r.y + 1, r.width, r.height - 2, arcSize, arcSize);
            g.setColor((Color)(this.myToWrap.isEnabled() ? Gray._100 : Gray._83));
            if (hasFocus) {
                DarculaUIUtil.paintSearchFocusRing(g, r, arcSize + 6);
            } else {
                g.drawRoundRect(r.x, r.y, r.width, r.height - 1, arcSize, arcSize);
            }
        }
        finally {
            g.dispose();
        }
        super.paint(graphics);
    }
}

