/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.AbstractBlockWrapper;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.CompositeBlockWrapper;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.formatting.ProbablyIncreasingLowerboundAlgorithm;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AlignmentImpl
extends Alignment {
    private static final List<LeafBlockWrapper> EMPTY = Collections.emptyList();
    private final boolean myAllowBackwardShift;
    private final Alignment.Anchor myAnchor;
    private List<LeafBlockWrapper> myOffsetRespBlocks;
    private AlignmentImpl myParentAlignment;
    private ProbablyIncreasingLowerboundAlgorithm<LeafBlockWrapper> myOffsetRespBlocksCalculator;

    AlignmentImpl() {
        this(false, Alignment.Anchor.LEFT);
    }

    AlignmentImpl(boolean allowBackwardShift, @NotNull Alignment.Anchor anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/formatting/AlignmentImpl", "<init>"));
        }
        this.myOffsetRespBlocks = EMPTY;
        this.myAllowBackwardShift = allowBackwardShift;
        this.myAnchor = anchor;
        this.myOffsetRespBlocksCalculator = new ProbablyIncreasingLowerboundAlgorithm<LeafBlockWrapper>(this.myOffsetRespBlocks);
    }

    public boolean isAllowBackwardShift() {
        return this.myAllowBackwardShift;
    }

    @NotNull
    public Alignment.Anchor getAnchor() {
        Alignment.Anchor anchor = this.myAnchor;
        if (anchor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/AlignmentImpl", "getAnchor"));
        }
        return anchor;
    }

    public String getId() {
        return String.valueOf(System.identityHashCode((Object)this));
    }

    public void reset() {
        if (this.myOffsetRespBlocks != EMPTY) {
            this.myOffsetRespBlocks.clear();
        }
        this.myOffsetRespBlocksCalculator.reset();
    }

    public void setParent(Alignment base) {
        this.myParentAlignment = (AlignmentImpl)base;
    }

    @Nullable
    LeafBlockWrapper getOffsetRespBlockBefore(@Nullable AbstractBlockWrapper block) {
        if (!this.continueOffsetResponsibleBlockRetrieval(block)) {
            return null;
        }
        LeafBlockWrapper result = null;
        List<LeafBlockWrapper> leftBlocks = this.myOffsetRespBlocksCalculator.getLeftSubList(block);
        if (!leftBlocks.isEmpty()) {
            result = leftBlocks.get(0);
        }
        if (result == null && this.myParentAlignment != null) {
            return this.myParentAlignment.getOffsetRespBlockBefore(block);
        }
        return result;
    }

    void setOffsetRespBlock(LeafBlockWrapper block) {
        if (block == null) {
            return;
        }
        if (this.myOffsetRespBlocks == EMPTY) {
            this.myOffsetRespBlocks = new ArrayList<LeafBlockWrapper>(1);
            this.myOffsetRespBlocksCalculator.setBlocksList(this.myOffsetRespBlocks);
        }
        this.myOffsetRespBlocks.add(block);
    }

    @NotNull
    private static AbstractBlockWrapper extendBlockFromStart(@NotNull AbstractBlockWrapper block) {
        CompositeBlockWrapper parent;
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/formatting/AlignmentImpl", "extendBlockFromStart"));
        }
        while ((parent = block.getParent()) != null && parent.getStartOffset() == block.getStartOffset()) {
            block = parent;
        }
        AbstractBlockWrapper abstractBlockWrapper = block;
        if (abstractBlockWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/AlignmentImpl", "extendBlockFromStart"));
        }
        return abstractBlockWrapper;
    }

    @NotNull
    private static AbstractBlockWrapper extendBlockFromEnd(@NotNull AbstractBlockWrapper block) {
        CompositeBlockWrapper parent;
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/formatting/AlignmentImpl", "extendBlockFromEnd"));
        }
        while ((parent = block.getParent()) != null && parent.getEndOffset() == block.getEndOffset()) {
            block = parent;
        }
        AbstractBlockWrapper abstractBlockWrapper = block;
        if (abstractBlockWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/AlignmentImpl", "extendBlockFromEnd"));
        }
        return abstractBlockWrapper;
    }

    private boolean continueOffsetResponsibleBlockRetrieval(@Nullable AbstractBlockWrapper block) {
        if (!this.myAllowBackwardShift && block != null && !block.getWhiteSpace().containsLineFeeds()) {
            return false;
        }
        if (block != null) {
            AbstractBlockWrapper prevAlignBlock = this.myOffsetRespBlocksCalculator.getLeftRespNeighbor(block);
            if (!AlignmentImpl.onDifferentLines(prevAlignBlock, block)) {
                return false;
            }
            if (this.myAllowBackwardShift && this.myAnchor == Alignment.Anchor.RIGHT && prevAlignBlock != null && prevAlignBlock.getWhiteSpace().containsLineFeeds()) {
                AbstractBlockWrapper prev;
                prevAlignBlock = AlignmentImpl.extendBlockFromStart(prevAlignBlock);
                AbstractBlockWrapper current = block;
                do {
                    if (current.getStartOffset() < prevAlignBlock.getEndOffset()) {
                        return false;
                    }
                    if (current.getWhiteSpace().containsLineFeeds()) break;
                    prev = current.getPreviousBlock();
                    if (prev == null) continue;
                    prev = AlignmentImpl.extendBlockFromEnd(prev);
                } while ((current = prev) != null);
                if (current == null) {
                    return false;
                }
            }
        }
        return this.myParentAlignment == null || this.myParentAlignment.continueOffsetResponsibleBlockRetrieval(block);
    }

    private static boolean onDifferentLines(AbstractBlockWrapper block1, AbstractBlockWrapper block2) {
        AbstractBlockWrapper rightBlock;
        if (block1 == null || block2 == null) {
            return true;
        }
        AbstractBlockWrapper leftBlock = block1.getStartOffset() <= block2.getStartOffset() ? block1 : block2;
        AbstractBlockWrapper abstractBlockWrapper = rightBlock = block1.getStartOffset() > block2.getStartOffset() ? block1 : block2;
        while (rightBlock != null && rightBlock.getStartOffset() > leftBlock.getStartOffset()) {
            if (rightBlock.getWhiteSpace().containsLineFeeds()) {
                return true;
            }
            rightBlock = rightBlock.getPreviousBlock();
        }
        return false;
    }

    public String toString() {
        return "Align: " + System.identityHashCode((Object)this) + "," + this.getAnchor() + (this.isAllowBackwardShift() ? "<" : "");
    }
}

