/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.impl.DesktopLayout;

public class HideAllToolWindowsAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (project == null) {
            return;
        }
        HideAllToolWindowsAction.performAction(project);
    }

    public static void performAction(Project project) {
        ToolWindowManagerEx toolWindowManager = ToolWindowManagerEx.getInstanceEx(project);
        DesktopLayout layout = new DesktopLayout();
        layout.copyFrom(toolWindowManager.getLayout());
        toolWindowManager.clearSideStack();
        String[] ids = toolWindowManager.getToolWindowIds();
        boolean hasVisible = false;
        for (String id : ids) {
            ToolWindow toolWindow = toolWindowManager.getToolWindow(id);
            if (!toolWindow.isVisible() || toolWindow.getType() == ToolWindowType.WINDOWED) continue;
            toolWindow.hide(null);
            hasVisible = true;
        }
        if (hasVisible) {
            toolWindowManager.setLayoutToRestoreLater(layout);
            toolWindowManager.activateEditorComponent();
        } else {
            DesktopLayout restoredLayout = toolWindowManager.getLayoutToRestoreLater();
            if (restoredLayout != null) {
                toolWindowManager.setLayoutToRestoreLater(null);
                toolWindowManager.setLayout(restoredLayout);
            }
        }
    }

    public void update(AnActionEvent event) {
        String[] ids;
        Presentation presentation = event.getPresentation();
        Project project = (Project)CommonDataKeys.PROJECT.getData(event.getDataContext());
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        ToolWindowManagerEx toolWindowManager = ToolWindowManagerEx.getInstanceEx(project);
        for (String id : ids = toolWindowManager.getToolWindowIds()) {
            ToolWindow toolWindow = toolWindowManager.getToolWindow(id);
            if (!toolWindow.isVisible() || toolWindow.getType() == ToolWindowType.WINDOWED) continue;
            presentation.setEnabled(true);
            presentation.setText(IdeBundle.message((String)"action.hide.all.windows", (Object[])new Object[0]), true);
            return;
        }
        DesktopLayout layout = toolWindowManager.getLayoutToRestoreLater();
        if (layout != null) {
            presentation.setEnabled(true);
            presentation.setText(IdeBundle.message((String)"action.restore.windows", (Object[])new Object[0]));
            return;
        }
        presentation.setEnabled(false);
    }
}

