/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView.smartPointerPsiNodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ProjectViewNodeDecorator;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PackageElement;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.PsiElementNavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class BaseSmartPointerPsiNode<Type extends SmartPsiElementPointer>
extends ProjectViewNode<Type>
implements PsiElementNavigationItem {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.projectView.impl.nodes.BasePsiNode");

    protected BaseSmartPointerPsiNode(Project project, Type value, ViewSettings viewSettings) {
        super(project, value, viewSettings);
    }

    @NotNull
    public final Collection<AbstractTreeNode> getChildren() {
        PsiElement value = this.getPsiElement();
        if (value == null) {
            ArrayList<AbstractTreeNode> arrayList = new ArrayList<AbstractTreeNode>();
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/smartPointerPsiNodes/BaseSmartPointerPsiNode", "getChildren"));
            }
            return arrayList;
        }
        LOG.assertTrue(value.isValid());
        Collection<AbstractTreeNode> collection = this.getChildrenImpl();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/smartPointerPsiNodes/BaseSmartPointerPsiNode", "getChildren"));
        }
        return collection;
    }

    @NotNull
    protected abstract Collection<AbstractTreeNode> getChildrenImpl();

    protected boolean isMarkReadOnly() {
        Object parentValue = this.getParentValue();
        return parentValue instanceof PsiDirectory || parentValue instanceof PackageElement;
    }

    public PsiElement getTargetElement() {
        VirtualFile file = this.getVirtualFileForValue();
        if (file == null) {
            return null;
        }
        return file.isDirectory() ? PsiManager.getInstance((Project)this.getProject()).findDirectory(file) : PsiManager.getInstance((Project)this.getProject()).findFile(file);
    }

    private VirtualFile getVirtualFileForValue() {
        PsiElement value = this.getPsiElement();
        if (value == null) {
            return null;
        }
        return PsiUtilCore.getVirtualFile((PsiElement)value);
    }

    protected abstract void updateImpl(PresentationData var1);

    public void update(PresentationData data2) {
        PsiElement value = this.getPsiElement();
        if (value == null || !value.isValid()) {
            this.setValue(null);
        }
        if (this.getPsiElement() == null) {
            return;
        }
        int flags = 1;
        if (this.isMarkReadOnly()) {
            flags |= 2;
        }
        LOG.assertTrue(value.isValid());
        Icon icon = value.getIcon(flags);
        data2.setIcon(icon);
        data2.setPresentableText(this.myName);
        if (this.isDeprecated()) {
            data2.setAttributesKey(CodeInsightColors.DEPRECATED_ATTRIBUTES);
        }
        this.updateImpl(data2);
        for (ProjectViewNodeDecorator decorator : (ProjectViewNodeDecorator[])Extensions.getExtensions(ProjectViewNodeDecorator.EP_NAME, (AreaInstance)this.myProject)) {
            decorator.decorate(this, data2);
        }
    }

    private boolean isDeprecated() {
        PsiElement element = this.getPsiElement();
        return element instanceof PsiDocCommentOwner && element.isValid() && ((PsiDocCommentOwner)element).isDeprecated();
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/favoritesTreeView/smartPointerPsiNodes/BaseSmartPointerPsiNode", "contains"));
        }
        if (this.getPsiElement() == null) {
            return false;
        }
        PsiFile containingFile = this.getPsiElement().getContainingFile();
        return file.equals(containingFile.getVirtualFile());
    }

    public void navigate(boolean requestFocus) {
        if (this.canNavigate()) {
            ((NavigationItem)this.getPsiElement()).navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        return this.getPsiElement() instanceof NavigationItem && ((NavigationItem)this.getPsiElement()).canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.getPsiElement() instanceof NavigationItem && ((NavigationItem)this.getPsiElement()).canNavigateToSource();
    }

    protected PsiElement getPsiElement() {
        SmartPsiElementPointer value = (SmartPsiElementPointer)this.getValue();
        return value == null ? null : value.getElement();
    }
}

