/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.call;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.hierarchy.call.CallHierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.call.CallReferenceProcessor;
import com.intellij.ide.hierarchy.call.JavaCallHierarchyData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class CallerMethodsTreeStructure
extends HierarchyTreeStructure {
    private final String myScopeType;

    public CallerMethodsTreeStructure(@NotNull Project project, @NotNull PsiMethod method, String scopeType) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/hierarchy/call/CallerMethodsTreeStructure", "<init>"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/ide/hierarchy/call/CallerMethodsTreeStructure", "<init>"));
        }
        super(project, new CallHierarchyNodeDescriptor(project, null, (PsiElement)method, true, false));
        this.myScopeType = scopeType;
    }

    @Override
    @NotNull
    protected final Object[] buildChildren(@NotNull HierarchyNodeDescriptor descriptor) {
        PsiClass clazz;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/hierarchy/call/CallerMethodsTreeStructure", "buildChildren"));
        }
        PsiMember enclosingElement = ((CallHierarchyNodeDescriptor)descriptor).getEnclosingElement();
        HierarchyNodeDescriptor nodeDescriptor = this.getBaseDescriptor();
        if (enclosingElement instanceof PsiMethod && CallerMethodsTreeStructure.isLocalOrAnonymousClass((PsiMember)(clazz = enclosingElement.getContainingClass()))) {
            PsiElement grandParent;
            PsiElement parent = clazz.getParent();
            PsiElement psiElement = grandParent = parent instanceof PsiNewExpression ? parent.getParent() : null;
            if (grandParent instanceof PsiExpressionList) {
                enclosingElement = CallHierarchyNodeDescriptor.getEnclosingElement(grandParent);
            }
        }
        if (!(enclosingElement instanceof PsiMethod) || nodeDescriptor == null) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/hierarchy/call/CallerMethodsTreeStructure", "buildChildren"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        PsiMethod method = (PsiMethod)enclosingElement;
        PsiMethod baseMethod = (PsiMethod)((CallHierarchyNodeDescriptor)nodeDescriptor).getTargetElement();
        SearchScope searchScope = this.getSearchScope(this.myScopeType, (PsiElement)baseMethod.getContainingClass());
        PsiClass originalClass = method.getContainingClass();
        assert (originalClass != null);
        PsiClassType originalType = JavaPsiFacade.getElementFactory((Project)this.myProject).createType(originalClass);
        HashSet<PsiMethod> methodsToFind = new HashSet<PsiMethod>();
        methodsToFind.add(method);
        ContainerUtil.addAll(methodsToFind, (Object[])method.findDeepestSuperMethods());
        HashMap methodToDescriptorMap = new HashMap();
        for (PsiMethod methodToFind : methodsToFind) {
            final JavaCallHierarchyData data2 = new JavaCallHierarchyData(originalClass, methodToFind, originalType, method, methodsToFind, (NodeDescriptor)descriptor, (Map)methodToDescriptorMap, this.myProject);
            MethodReferencesSearch.search((PsiMethod)methodToFind, (SearchScope)searchScope, (boolean)true).forEach((Processor)new Processor<PsiReference>(){

                public boolean process(PsiReference reference) {
                    for (CallReferenceProcessor processor : (CallReferenceProcessor[])CallReferenceProcessor.EP_NAME.getExtensions()) {
                        if (!processor.process(reference, data2)) break;
                    }
                    return true;
                }
            });
        }
        Object[] objectArray = methodToDescriptorMap.values().toArray(new Object[methodToDescriptorMap.size()]);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/hierarchy/call/CallerMethodsTreeStructure", "buildChildren"));
        }
        return objectArray;
    }

    private static boolean isLocalOrAnonymousClass(PsiMember enclosingElement) {
        return enclosingElement instanceof PsiClass && ((PsiClass)enclosingElement).getQualifiedName() == null;
    }

    @Override
    public boolean isAlwaysShowPlus() {
        return true;
    }
}

