/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.scratch.LRUPopupBuilder;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.lang.Language;
import com.intellij.lang.PerFileMappings;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScratchFileActions {
    private static int ourCurrentBuffer = 0;

    static void doCreateNewScratch(@NotNull Project project, boolean buffer, @NotNull Language language, @NotNull String text) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/ScratchFileActions", "doCreateNewScratch"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/ide/scratch/ScratchFileActions", "doCreateNewScratch"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ide/scratch/ScratchFileActions", "doCreateNewScratch"));
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("scratch");
        String fileName = buffer ? "buffer" + ScratchFileActions.nextBufferIndex() : "scratch";
        ScratchFileService.Option option = buffer ? ScratchFileService.Option.create_if_missing : ScratchFileService.Option.create_new_always;
        VirtualFile f = ScratchRootType.getInstance().createScratchFile(project, fileName, language, text, option);
        if (f != null) {
            FileEditorManager.getInstance((Project)project).openFile(f, true);
        }
    }

    private static int nextBufferIndex() {
        ourCurrentBuffer = ourCurrentBuffer % Registry.intValue((String)"ide.scratch.buffers") + 1;
        return ourCurrentBuffer;
    }

    @Nullable
    static String getSelectionText(@Nullable Editor editor) {
        if (editor == null) {
            return null;
        }
        return editor.getSelectionModel().getSelectedText();
    }

    @Nullable
    static Language getLanguageFromCaret(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile psiFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/ScratchFileActions", "getLanguageFromCaret"));
        }
        if (editor == null || psiFile == null) {
            return null;
        }
        Caret caret = editor.getCaretModel().getPrimaryCaret();
        int offset = caret.getOffset();
        PsiElement element = InjectedLanguageManager.getInstance((Project)project).findInjectedElementAt(psiFile, offset);
        PsiFile file = element != null ? element.getContainingFile() : psiFile;
        return file.getLanguage();
    }

    @NotNull
    private static Function<VirtualFile, Language> SCRATCH_LANG(final ScratchFileService service2, final Project project) {
        Function<VirtualFile, Language> function = new Function<VirtualFile, Language>(){

            public Language fun(VirtualFile file) {
                Language lang = (Language)service2.getScratchesMapping().getMapping(file);
                if (lang == null) {
                    lang = LanguageSubstitutors.INSTANCE.substituteLanguage(((LanguageFileType)file.getFileType()).getLanguage(), file, project);
                }
                return lang;
            }
        };
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/ScratchFileActions", "SCRATCH_LANG"));
        }
        return function;
    }

    @NotNull
    private static Condition<VirtualFile> isScratch() {
        Condition<VirtualFile> condition = new Condition<VirtualFile>(){

            public boolean value(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/ScratchFileActions$2", "value"));
                }
                return ScratchRootType.getInstance().isScratchFile(file);
            }
        };
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/ScratchFileActions", "isScratch"));
        }
        return condition;
    }

    public static class LanguageAction
    extends DumbAwareAction {
        public void update(AnActionEvent e) {
            Project project = e.getProject();
            JBIterable files = JBIterable.of((Object[])((Object[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)));
            if (project == null || files.isEmpty()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            ScratchFileService fileService = ScratchFileService.getInstance();
            Condition isScratch = ScratchFileActions.isScratch();
            if (!files.filter(Conditions.not((Condition)isScratch)).isEmpty()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            Set langs = (Set)files.filter(isScratch).transform(ScratchFileActions.SCRATCH_LANG(fileService, project)).filter(Conditions.notNull()).addAllTo((Collection)ContainerUtil.newLinkedHashSet());
            String langName = langs.size() == 1 ? ((Language)langs.iterator().next()).getDisplayName() : langs.size() + " different";
            e.getPresentation().setText("Change Language (" + langName + ")...");
            e.getPresentation().setEnabledAndVisible(true);
        }

        public void actionPerformed(AnActionEvent e) {
            Project project = e.getProject();
            ScratchFileService fileService = ScratchFileService.getInstance();
            JBIterable files = JBIterable.of((Object[])((Object[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY))).filter(ScratchFileActions.isScratch());
            if (project == null || files.isEmpty()) {
                return;
            }
            PerFileMappings<Language> mapping = fileService.getScratchesMapping();
            LRUPopupBuilder.forFileLanguages(project, (Iterable<VirtualFile>)files, mapping).showInBestPositionFor(e.getDataContext());
        }
    }

    public static class NewBufferAction
    extends DumbAwareAction {
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/scratch/ScratchFileActions$NewBufferAction", "update"));
            }
            boolean enabled = e.getProject() != null && Registry.is((String)"ide.scratch.enabled") && Registry.intValue((String)"ide.scratch.buffers") > 0;
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/scratch/ScratchFileActions$NewBufferAction", "actionPerformed"));
            }
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            String text = StringUtil.notNullize((String)ScratchFileActions.getSelectionText(editor));
            Language language = text.isEmpty() ? null : ScratchFileActions.getLanguageFromCaret(project, editor, file);
            ScratchFileActions.doCreateNewScratch(project, true, (Language)ObjectUtils.notNull((Object)language, (Object)StdLanguages.TEXT), text);
        }
    }

    public static class NewFileAction
    extends DumbAwareAction {
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/scratch/ScratchFileActions$NewFileAction", "update"));
            }
            boolean enabled = e.getProject() != null && Registry.is((String)"ide.scratch.enabled");
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/scratch/ScratchFileActions$NewFileAction", "actionPerformed"));
            }
            final Project project = e.getProject();
            if (project == null) {
                return;
            }
            PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            final String text = StringUtil.notNullize((String)ScratchFileActions.getSelectionText(editor));
            Language language = text.isEmpty() ? null : ScratchFileActions.getLanguageFromCaret(project, editor, file);
            Consumer<Language> consumer = new Consumer<Language>(){

                public void consume(Language language) {
                    ScratchFileActions.doCreateNewScratch(project, false, language, text);
                }
            };
            if (language != null) {
                consumer.consume((Object)language);
            } else {
                LRUPopupBuilder.forFileLanguages(project, null, consumer).showCenteredInCurrentWindow(project);
            }
        }
    }
}

