/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.frameworkSupport;

import com.intellij.CommonBundle;
import com.intellij.facet.impl.DefaultFacetsProvider;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModelImpl;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportUtil;
import com.intellij.ide.util.newProjectWizard.AddSupportForFrameworksPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbModePermission;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddFrameworkSupportDialog
extends DialogWrapper {
    private final AddSupportForFrameworksPanel myAddSupportPanel;
    private final Module myModule;

    private AddFrameworkSupportDialog(@NotNull Module module, @NotNull String contentRootPath, List<FrameworkSupportInModuleProvider> providers) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ide/util/frameworkSupport/AddFrameworkSupportDialog", "<init>"));
        }
        if (contentRootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentRootPath", "com/intellij/ide/util/frameworkSupport/AddFrameworkSupportDialog", "<init>"));
        }
        super(module.getProject(), true);
        this.setTitle(ProjectBundle.message((String)"dialog.title.add.frameworks.support", (Object[])new Object[0]));
        this.myModule = module;
        LibrariesContainer container = LibrariesContainerFactory.createContainer(module.getProject());
        FrameworkSupportModelImpl model = new FrameworkSupportModelImpl(module.getProject(), contentRootPath, container);
        this.myAddSupportPanel = new AddSupportForFrameworksPanel(providers, model, false, null){

            @Override
            protected void onFrameworkStateChanged() {
                AddFrameworkSupportDialog.this.setOKActionEnabled(AddFrameworkSupportDialog.this.isOKActionEnabled());
            }
        };
        this.setOKActionEnabled(this.isOKActionEnabled());
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myAddSupportPanel);
        this.init();
    }

    @Nullable
    public static AddFrameworkSupportDialog createDialog(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ide/util/frameworkSupport/AddFrameworkSupportDialog", "createDialog"));
        }
        VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        if (roots.length == 0) {
            return null;
        }
        List<FrameworkSupportInModuleProvider> providers = FrameworkSupportUtil.getProviders(module, DefaultFacetsProvider.INSTANCE);
        if (providers.isEmpty()) {
            return null;
        }
        return new AddFrameworkSupportDialog(module, roots[0].getPath(), providers);
    }

    public static boolean isAvailable(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ide/util/frameworkSupport/AddFrameworkSupportDialog", "isAvailable"));
        }
        VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        return roots.length != 0 && FrameworkSupportUtil.hasProviders(module, DefaultFacetsProvider.INSTANCE);
    }

    public boolean isOKActionEnabled() {
        return this.myAddSupportPanel.hasSelectedFrameworks();
    }

    protected void doOKAction() {
        if (this.myAddSupportPanel.hasSelectedFrameworks()) {
            int answer;
            if (!this.myAddSupportPanel.downloadLibraries() && (answer = Messages.showYesNoDialog((Component)this.myAddSupportPanel.getMainPanel(), (String)ProjectBundle.message((String)"warning.message.some.required.libraries.wasn.t.downloaded", (Object[])new Object[0]), (String)CommonBundle.getWarningTitle(), (Icon)Messages.getWarningIcon())) != 0) {
                return;
            }
            DumbService.allowStartingDumbModeInside((DumbModePermission)DumbModePermission.MAY_START_BACKGROUND, (Runnable)new Runnable(){

                @Override
                public void run() {
                    new WriteAction(){

                        protected void run(@NotNull Result result) {
                            if (result == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/ide/util/frameworkSupport/AddFrameworkSupportDialog$2$1", "run"));
                            }
                            ModifiableRootModel model = ModuleRootManager.getInstance((Module)AddFrameworkSupportDialog.this.myModule).getModifiableModel();
                            AddFrameworkSupportDialog.this.myAddSupportPanel.addSupport(AddFrameworkSupportDialog.this.myModule, model);
                            model.commit();
                        }
                    }.execute();
                }
            });
        }
        super.doOKAction();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.ide.util.frameworkSupport.AddFrameworkSupportDialog";
    }

    protected String getHelpId() {
        return "reference.frameworks.support.dialog";
    }

    protected JComponent createCenterPanel() {
        return this.myAddSupportPanel.getMainPanel();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myAddSupportPanel.getFrameworksTree();
    }
}

