/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.scopeChooser;

import com.intellij.ide.DataManager;
import com.intellij.ide.util.scopeChooser.EditScopesDialog;
import com.intellij.ide.util.scopeChooser.IgnoringComboBox;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.ide.util.scopeChooser.ScopeDescriptorProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.packageDependencies.ChangeListsScopesProvider;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.PredefinedSearchScopeProvider;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.ListCellRendererWrapper;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.jetbrains.annotations.Nullable;

public class ScopeChooserCombo
extends ComboboxWithBrowseButton
implements Disposable {
    private Project myProject;
    private boolean mySuggestSearchInLibs;
    private boolean myPrevSearchFiles;
    private NamedScopesHolder.ScopeListener myScopeListener;
    private NamedScopeManager myNamedScopeManager;
    private DependencyValidationManager myValidationManager;
    private boolean myCurrentSelection = true;
    private boolean myUsageView = true;
    private Condition<ScopeDescriptor> myScopeFilter;

    public ScopeChooserCombo() {
        super((JComboBox)new IgnoringComboBox(){

            @Override
            protected boolean isIgnored(Object item) {
                return item instanceof ScopeSeparator;
            }
        });
    }

    public ScopeChooserCombo(Project project, boolean suggestSearchInLibs, boolean prevSearchWholeFiles, String preselect) {
        this();
        this.init(project, suggestSearchInLibs, prevSearchWholeFiles, preselect);
    }

    public void init(Project project, String preselect) {
        this.init(project, false, true, preselect);
    }

    public void init(Project project, boolean suggestSearchInLibs, boolean prevSearchWholeFiles, String preselect) {
        this.init(project, suggestSearchInLibs, prevSearchWholeFiles, preselect, null);
    }

    public void init(Project project, boolean suggestSearchInLibs, boolean prevSearchWholeFiles, String preselect, @Nullable Condition<ScopeDescriptor> scopeFilter) {
        this.mySuggestSearchInLibs = suggestSearchInLibs;
        this.myPrevSearchFiles = prevSearchWholeFiles;
        this.myProject = project;
        this.myScopeListener = new NamedScopesHolder.ScopeListener(){

            public void scopesChanged() {
                SearchScope selectedScope = ScopeChooserCombo.this.getSelectedScope();
                ScopeChooserCombo.this.rebuildModel();
                if (selectedScope != null) {
                    ScopeChooserCombo.this.selectScope(selectedScope.getDisplayName());
                }
            }
        };
        this.myScopeFilter = scopeFilter;
        this.myNamedScopeManager = NamedScopeManager.getInstance((Project)project);
        this.myNamedScopeManager.addScopeListener(this.myScopeListener);
        this.myValidationManager = DependencyValidationManager.getInstance((Project)project);
        this.myValidationManager.addScopeListener(this.myScopeListener);
        this.addActionListener(this.createScopeChooserListener());
        JComboBox combo = this.getComboBox();
        combo.setRenderer(new ScopeDescriptionWithDelimiterRenderer());
        this.rebuildModel();
        this.selectScope(preselect);
    }

    public void setCurrentSelection(boolean currentSelection) {
        this.myCurrentSelection = currentSelection;
    }

    public void setUsageView(boolean usageView) {
        this.myUsageView = usageView;
    }

    public void dispose() {
        super.dispose();
        if (this.myValidationManager != null) {
            this.myValidationManager.removeScopeListener(this.myScopeListener);
            this.myValidationManager = null;
        }
        if (this.myNamedScopeManager != null) {
            this.myNamedScopeManager.removeScopeListener(this.myScopeListener);
            this.myNamedScopeManager = null;
        }
        this.myScopeListener = null;
    }

    private void selectScope(String preselect) {
        if (preselect != null) {
            JComboBox combo = this.getComboBox();
            DefaultComboBoxModel model = (DefaultComboBoxModel)combo.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                ScopeDescriptor descriptor = (ScopeDescriptor)model.getElementAt(i);
                if (!preselect.equals(descriptor.getDisplay())) continue;
                combo.setSelectedIndex(i);
                break;
            }
        }
    }

    private ActionListener createScopeChooserListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selection = ScopeChooserCombo.this.getSelectedScopeName();
                EditScopesDialog dlg = EditScopesDialog.showDialog(ScopeChooserCombo.this.myProject, selection);
                if (dlg.isOK()) {
                    ScopeChooserCombo.this.rebuildModel();
                    NamedScope namedScope = dlg.getSelectedScope();
                    if (namedScope != null) {
                        ScopeChooserCombo.this.selectScope(namedScope.getName());
                    }
                }
            }
        };
    }

    private void rebuildModel() {
        this.getComboBox().setModel(this.createModel());
    }

    private DefaultComboBoxModel createModel() {
        DefaultComboBoxModel<ScopeSeparator> model = new DefaultComboBoxModel<ScopeSeparator>();
        this.createPredefinedScopeDescriptors(model);
        List<NamedScope> changeLists = ChangeListsScopesProvider.getInstance(this.myProject).getCustomScopes();
        if (!changeLists.isEmpty()) {
            model.addElement(new ScopeSeparator("VCS Scopes"));
            for (NamedScope changeListScope : changeLists) {
                GlobalSearchScope scope = GlobalSearchScopesCore.filterScope((Project)this.myProject, (NamedScope)changeListScope);
                this.addScopeDescriptor(model, new ScopeDescriptor((SearchScope)scope));
            }
        }
        ArrayList<ScopeDescriptor> customScopes = new ArrayList<ScopeDescriptor>();
        NamedScopesHolder[] holders = NamedScopesHolder.getAllNamedScopeHolders((Project)this.myProject);
        for (NamedScopesHolder holder : holders) {
            NamedScope[] scopes;
            for (NamedScope scope : scopes = holder.getEditableScopes()) {
                GlobalSearchScope searchScope = GlobalSearchScopesCore.filterScope((Project)this.myProject, (NamedScope)scope);
                customScopes.add(new ScopeDescriptor((SearchScope)searchScope));
            }
        }
        if (!customScopes.isEmpty()) {
            model.addElement(new ScopeSeparator("Custom Scopes"));
            for (ScopeDescriptor scope : customScopes) {
                this.addScopeDescriptor(model, scope);
            }
        }
        return model;
    }

    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Dimension preferredSize = super.getPreferredSize();
        return new Dimension(Math.min(400, preferredSize.width), preferredSize.height);
    }

    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        Dimension minimumSize = super.getMinimumSize();
        return new Dimension(Math.min(200, minimumSize.width), minimumSize.height);
    }

    private void createPredefinedScopeDescriptors(DefaultComboBoxModel model) {
        DataContext context = DataManager.getInstance().getDataContext();
        for (SearchScope scope : PredefinedSearchScopeProvider.getInstance().getPredefinedScopes(this.myProject, context, this.mySuggestSearchInLibs, this.myPrevSearchFiles, this.myCurrentSelection, this.myUsageView)) {
            this.addScopeDescriptor(model, new ScopeDescriptor(scope));
        }
        for (ScopeDescriptorProvider provider : (ScopeDescriptorProvider[])Extensions.getExtensions(ScopeDescriptorProvider.EP_NAME)) {
            for (ScopeDescriptor scopeDescriptor : provider.getScopeDescriptors(this.myProject)) {
                if (this.myScopeFilter != null && !this.myScopeFilter.value((Object)scopeDescriptor)) continue;
                model.addElement(scopeDescriptor);
            }
        }
    }

    private void addScopeDescriptor(DefaultComboBoxModel model, ScopeDescriptor scopeDescriptor) {
        if (this.myScopeFilter == null || this.myScopeFilter.value((Object)scopeDescriptor)) {
            model.addElement(scopeDescriptor);
        }
    }

    @Nullable
    public SearchScope getSelectedScope() {
        JComboBox combo = this.getComboBox();
        int idx = combo.getSelectedIndex();
        return idx < 0 ? null : ((ScopeDescriptor)combo.getSelectedItem()).getScope();
    }

    @Nullable
    public String getSelectedScopeName() {
        JComboBox combo = this.getComboBox();
        int idx = combo.getSelectedIndex();
        return idx < 0 ? null : ((ScopeDescriptor)combo.getSelectedItem()).getDisplay();
    }

    private static class ScopeDescriptionWithDelimiterRenderer
    extends ListCellRendererWrapper<ScopeDescriptor> {
        private ScopeDescriptionWithDelimiterRenderer() {
        }

        public void customize(JList list, ScopeDescriptor value, int index, boolean selected, boolean hasFocus) {
            this.setText(value.getDisplay());
            if (value instanceof ScopeSeparator) {
                this.setSeparator();
            }
        }
    }

    private static class ScopeSeparator
    extends ScopeDescriptor {
        private final String myText;

        public ScopeSeparator(String text) {
            super(null);
            this.myText = text;
        }

        @Override
        public String getDisplay() {
            return this.myText;
        }
    }
}

