/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.injected.editor;

import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.injected.editor.CaretModelWindow;
import com.intellij.injected.editor.DocumentWindowImpl;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.injected.editor.FoldingModelWindow;
import com.intellij.injected.editor.ListenerWrapperMap;
import com.intellij.injected.editor.MarkupModelWindow;
import com.intellij.injected.editor.SelectionModelWindow;
import com.intellij.injected.editor.SoftWrapModelWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.IndentsModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.editor.ex.SoftWrapModelEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.LightHighlighterClient;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorGutterComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.TextDrawingCallback;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.containers.WeakList;
import com.intellij.util.ui.ButtonlessScrollBarUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorWindowImpl
extends UserDataHolderBase
implements EditorWindow,
EditorEx {
    private final DocumentWindowImpl myDocumentWindow;
    private final EditorImpl myDelegate;
    private volatile PsiFile myInjectedFile;
    private final boolean myOneLine;
    private final CaretModelWindow myCaretModelDelegate;
    private final SelectionModelWindow mySelectionModelDelegate;
    private static final List<EditorWindowImpl> allEditors = new WeakList();
    private boolean myDisposed;
    private final MarkupModelWindow myMarkupModelDelegate;
    private final FoldingModelWindow myFoldingModelWindow;
    private final SoftWrapModelWindow mySoftWrapModel;
    private final ListenerWrapperMap<EditorMouseListener> myEditorMouseListeners;
    private final ListenerWrapperMap<EditorMouseMotionListener> myEditorMouseMotionListeners;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Editor create(@NotNull DocumentWindowImpl documentRange, @NotNull EditorImpl editor, @NotNull PsiFile injectedFile) {
        EditorWindowImpl window;
        if (documentRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentRange", "com/intellij/injected/editor/EditorWindowImpl", "create"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/injected/editor/EditorWindowImpl", "create"));
        }
        if (injectedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedFile", "com/intellij/injected/editor/EditorWindowImpl", "create"));
        }
        assert (documentRange.isValid());
        assert (injectedFile.isValid());
        List<EditorWindowImpl> list = allEditors;
        synchronized (list) {
            for (EditorWindowImpl editorWindow : allEditors) {
                if (editorWindow.getDocument() == documentRange && editorWindow.getDelegate() == editor) {
                    editorWindow.myInjectedFile = injectedFile;
                    if (editorWindow.isValid()) {
                        return editorWindow;
                    }
                }
                if (!editorWindow.getDocument().areRangesEqual(documentRange)) continue;
            }
            window = new EditorWindowImpl(documentRange, editor, injectedFile, documentRange.isOneLine());
            allEditors.add(window);
        }
        assert (window.isValid());
        return window;
    }

    private EditorWindowImpl(@NotNull DocumentWindowImpl documentWindow, @NotNull EditorImpl delegate, @NotNull PsiFile injectedFile, boolean oneLine) {
        if (documentWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentWindow", "com/intellij/injected/editor/EditorWindowImpl", "<init>"));
        }
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/injected/editor/EditorWindowImpl", "<init>"));
        }
        if (injectedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedFile", "com/intellij/injected/editor/EditorWindowImpl", "<init>"));
        }
        this.myEditorMouseListeners = new ListenerWrapperMap();
        this.myEditorMouseMotionListeners = new ListenerWrapperMap();
        this.myDocumentWindow = documentWindow;
        this.myDelegate = delegate;
        this.myInjectedFile = injectedFile;
        this.myOneLine = oneLine;
        this.myCaretModelDelegate = new CaretModelWindow(this.myDelegate.getCaretModel(), this);
        this.mySelectionModelDelegate = new SelectionModelWindow(this.myDelegate, this.myDocumentWindow, this);
        this.myMarkupModelDelegate = new MarkupModelWindow(this.myDelegate.getMarkupModel(), this.myDocumentWindow);
        this.myFoldingModelWindow = new FoldingModelWindow(delegate.getFoldingModel(), documentWindow, this);
        this.mySoftWrapModel = new SoftWrapModelWindow(this);
    }

    public static void disposeInvalidEditors() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Iterator<EditorWindowImpl> iterator = allEditors.iterator();
        while (iterator.hasNext()) {
            EditorWindowImpl editorWindow = iterator.next();
            if (editorWindow.isValid()) continue;
            editorWindow.dispose();
            InjectedLanguageUtil.clearCaches(editorWindow.myInjectedFile, editorWindow.getDocument());
            iterator.remove();
        }
    }

    @Override
    public boolean isValid() {
        return !this.isDisposed() && !this.myInjectedFile.getProject().isDisposed() && this.myInjectedFile.isValid() && this.myDocumentWindow.isValid();
    }

    @Override
    @NotNull
    public PsiFile getInjectedFile() {
        PsiFile psiFile = this.myInjectedFile;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/EditorWindowImpl", "getInjectedFile"));
        }
        return psiFile;
    }

    @Override
    @NotNull
    public LogicalPosition hostToInjected(@NotNull LogicalPosition hPos) {
        LogicalPosition iPos;
        if (hPos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hPos", "com/intellij/injected/editor/EditorWindowImpl", "hostToInjected"));
        }
        assert (this.isValid());
        DocumentEx hostDocument = this.myDelegate.getDocument();
        int hLineEndOffset = hPos.line >= hostDocument.getLineCount() ? hostDocument.getTextLength() : hostDocument.getLineEndOffset(hPos.line);
        LogicalPosition hLineEndPos = this.myDelegate.offsetToLogicalPosition(hLineEndOffset);
        if (hLineEndPos.column < hPos.column && (iPos = this.myDocumentWindow.hostToInjectedInVirtualSpace(hPos)) != null) {
            LogicalPosition logicalPosition = iPos;
            if (logicalPosition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/EditorWindowImpl", "hostToInjected"));
            }
            return logicalPosition;
        }
        int hOffset = this.myDelegate.logicalPositionToOffset(hPos);
        int iOffset = this.myDocumentWindow.hostToInjected(hOffset);
        LogicalPosition logicalPosition = this.offsetToLogicalPosition(iOffset);
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/EditorWindowImpl", "hostToInjected"));
        }
        return logicalPosition;
    }

    @Override
    @NotNull
    public LogicalPosition injectedToHost(@NotNull LogicalPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/injected/editor/EditorWindowImpl", "injectedToHost"));
        }
        assert (this.isValid());
        int offset = this.logicalPositionToOffset(pos);
        LogicalPosition samePos = this.offsetToLogicalPosition(offset);
        int virtualSpaceDelta = offset < this.myDocumentWindow.getTextLength() && samePos.line == pos.line && samePos.column < pos.column ? pos.column - samePos.column : 0;
        LogicalPosition hostPos = this.myDelegate.offsetToLogicalPosition(this.myDocumentWindow.injectedToHost(offset));
        LogicalPosition logicalPosition = new LogicalPosition(hostPos.line, hostPos.column + virtualSpaceDelta);
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/EditorWindowImpl", "injectedToHost"));
        }
        return logicalPosition;
    }

    private void dispose() {
        assert (!this.myDisposed);
        this.myCaretModelDelegate.disposeModel();
        for (EditorMouseListener editorMouseListener : this.myEditorMouseListeners.wrappers()) {
            this.myDelegate.removeEditorMouseListener(editorMouseListener);
        }
        this.myEditorMouseListeners.clear();
        for (EditorMouseMotionListener editorMouseMotionListener : this.myEditorMouseMotionListeners.wrappers()) {
            this.myDelegate.removeEditorMouseMotionListener(editorMouseMotionListener);
        }
        this.myEditorMouseMotionListeners.clear();
        this.myDisposed = true;
        Disposer.dispose((Disposable)this.myDocumentWindow);
    }

    @Override
    public void setViewer(boolean isViewer) {
        this.myDelegate.setViewer(isViewer);
    }

    public boolean isViewer() {
        return this.myDelegate.isViewer();
    }

    @Override
    public boolean isRendererMode() {
        return this.myDelegate.isRendererMode();
    }

    @Override
    public void setRendererMode(boolean isRendererMode) {
        this.myDelegate.setRendererMode(isRendererMode);
    }

    @Override
    public void setFile(VirtualFile vFile) {
        this.myDelegate.setFile(vFile);
    }

    public void setHeaderComponent(@Nullable JComponent header) {
    }

    public boolean hasHeaderComponent() {
        return false;
    }

    @Nullable
    public JComponent getHeaderComponent() {
        return null;
    }

    @Override
    public TextDrawingCallback getTextDrawingCallback() {
        return this.myDelegate.getTextDrawingCallback();
    }

    @NotNull
    public SelectionModel getSelectionModel() {
        SelectionModelWindow selectionModelWindow = this.mySelectionModelDelegate;
        if (selectionModelWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/EditorWindowImpl", "getSelectionModel"));
        }
        return selectionModelWindow;
    }

    @Override
    @NotNull
    public MarkupModelEx getMarkupModel() {
        MarkupModelWindow markupModelWindow = this.myMarkupModelDelegate;
        if (markupModelWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/EditorWindowImpl", "getMarkupModel"));
        }
        return markupModelWindow;
    }

    @Override
    @NotNull
    public FoldingModelEx getFoldingModel() {
        FoldingModelWindow foldingModelWindow = this.myFoldingModelWindow;
        if (foldingModelWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/EditorWindowImpl", "getFoldingModel"));
        }
        return foldingModelWindow;
    }

    @NotNull
    public CaretModel getCaretModel() {
        CaretModelWindow caretModelWindow = this.myCaretModelDelegate;
        if (caretModelWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/EditorWindowImpl", "getCaretModel"));
        }
        return caretModelWindow;
    }

    @Override
    @NotNull
    public ScrollingModelEx getScrollingModel() {
        ScrollingModelEx scrollingModelEx = this.myDelegate.getScrollingModel();
        if (scrollingModelEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/EditorWindowImpl", "getScrollingModel"));
        }
        return scrollingModelEx;
    }

    @Override
    @NotNull
    public SoftWrapModelEx getSoftWrapModel() {
        SoftWrapModelWindow softWrapModelWindow = this.mySoftWrapModel;
        if (softWrapModelWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/EditorWindowImpl", "getSoftWrapModel"));
        }
        return softWrapModelWindow;
    }

    @NotNull
    public EditorSettings getSettings() {
        EditorSettings editorSettings = this.myDelegate.getSettings();
        if (editorSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/EditorWindowImpl", "getSettings"));
        }
        return editorSettings;
    }

    @Override
    public void reinitSettings() {
        this.myDelegate.reinitSettings();
    }

    @Override
    public void setFontSize(int fontSize) {
        this.myDelegate.setFontSize(fontSize);
    }

    @Override
    public void setHighlighter(@NotNull EditorHighlighter highlighter) {
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/injected/editor/EditorWindowImpl", "setHighlighter"));
        }
        this.myDelegate.setHighlighter(highlighter);
    }

    @Override
    @NotNull
    public EditorHighlighter getHighlighter() {
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        EditorHighlighter highlighter = HighlighterFactory.createHighlighter((VirtualFile)this.myInjectedFile.getVirtualFile(), (EditorColorsScheme)scheme, (Project)this.getProject());
        highlighter.setText((CharSequence)this.getDocument().getText());
        highlighter.setEditor((HighlighterClient)new LightHighlighterClient((Document)this.getDocument(), this.getProject()));
        EditorHighlighter editorHighlighter = highlighter;
        if (editorHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/EditorWindowImpl", "getHighlighter"));
        }
        return editorHighlighter;
    }

    @Override
    public JComponent getPermanentHeaderComponent() {
        return this.myDelegate.getPermanentHeaderComponent();
    }

    @Override
    public void setPermanentHeaderComponent(JComponent component) {
        this.myDelegate.setPermanentHeaderComponent(component);
    }

    @NotNull
    public JComponent getContentComponent() {
        EditorComponentImpl editorComponentImpl = this.myDelegate.getContentComponent();
        if (editorComponentImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/EditorWindowImpl", "getContentComponent"));
        }
        return editorComponentImpl;
    }

    @Override
    @NotNull
    public EditorGutterComponentEx getGutterComponentEx() {
        EditorGutterComponentImpl editorGutterComponentImpl = this.myDelegate.getGutterComponentEx();
        if (editorGutterComponentImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/EditorWindowImpl", "getGutterComponentEx"));
        }
        return editorGutterComponentImpl;
    }

    @Override
    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/injected/editor/EditorWindowImpl", "addPropertyChangeListener"));
        }
        this.myDelegate.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/injected/editor/EditorWindowImpl", "addPropertyChangeListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/injected/editor/EditorWindowImpl", "addPropertyChangeListener"));
        }
        this.myDelegate.addPropertyChangeListener(listener, parentDisposable);
    }

    @Override
    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/injected/editor/EditorWindowImpl", "removePropertyChangeListener"));
        }
        this.myDelegate.removePropertyChangeListener(listener);
    }

    @Override
    public void setInsertMode(boolean mode) {
        this.myDelegate.setInsertMode(mode);
    }

    public boolean isInsertMode() {
        return this.myDelegate.isInsertMode();
    }

    @Override
    public void setColumnMode(boolean mode) {
        this.myDelegate.setColumnMode(mode);
    }

    public boolean isColumnMode() {
        return this.myDelegate.isColumnMode();
    }

    @NotNull
    public VisualPosition xyToVisualPosition(@NotNull Point p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/injected/editor/EditorWindowImpl", "xyToVisualPosition"));
        }
        VisualPosition visualPosition = this.logicalToVisualPosition(this.xyToLogicalPosition(p));
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/EditorWindowImpl", "xyToVisualPosition"));
        }
        return visualPosition;
    }

    @NotNull
    public VisualPosition offsetToVisualPosition(int offset) {
        VisualPosition visualPosition = this.logicalToVisualPosition(this.offsetToLogicalPosition(offset));
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/EditorWindowImpl", "offsetToVisualPosition"));
        }
        return visualPosition;
    }

    @NotNull
    public VisualPosition offsetToVisualPosition(int offset, boolean leanForward, boolean beforeSoftWrap) {
        VisualPosition visualPosition = this.logicalToVisualPosition(this.offsetToLogicalPosition(offset).leanForward(leanForward));
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/EditorWindowImpl", "offsetToVisualPosition"));
        }
        return visualPosition;
    }

    @NotNull
    public LogicalPosition offsetToLogicalPosition(int offset) {
        LogicalPosition logicalPosition = this.offsetToLogicalPosition(offset, true);
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/EditorWindowImpl", "offsetToLogicalPosition"));
        }
        return logicalPosition;
    }

    @Override
    @NotNull
    public LogicalPosition offsetToLogicalPosition(int offset, boolean softWrapAware) {
        assert (this.isValid());
        int lineNumber = this.myDocumentWindow.getLineNumber(offset);
        int lineStartOffset = this.myDocumentWindow.getLineStartOffset(lineNumber);
        int column = this.calcLogicalColumnNumber(offset - lineStartOffset, lineNumber, lineStartOffset);
        LogicalPosition logicalPosition = new LogicalPosition(lineNumber, column);
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/EditorWindowImpl", "offsetToLogicalPosition"));
        }
        return logicalPosition;
    }

    @Override
    @NotNull
    public EditorColorsScheme createBoundColorSchemeDelegate(@Nullable EditorColorsScheme customGlobalScheme) {
        EditorColorsScheme editorColorsScheme = this.myDelegate.createBoundColorSchemeDelegate(customGlobalScheme);
        if (editorColorsScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/EditorWindowImpl", "createBoundColorSchemeDelegate"));
        }
        return editorColorsScheme;
    }

    @NotNull
    public LogicalPosition xyToLogicalPosition(@NotNull Point p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/injected/editor/EditorWindowImpl", "xyToLogicalPosition"));
        }
        assert (this.isValid());
        LogicalPosition hostPos = this.myDelegate.xyToLogicalPosition(p);
        LogicalPosition logicalPosition = this.hostToInjected(hostPos);
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/EditorWindowImpl", "xyToLogicalPosition"));
        }
        return logicalPosition;
    }

    @NotNull
    public Point logicalPositionToXY(@NotNull LogicalPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/injected/editor/EditorWindowImpl", "logicalPositionToXY"));
        }
        assert (this.isValid());
        LogicalPosition hostPos = this.injectedToHost(pos);
        Point point = this.myDelegate.logicalPositionToXY(hostPos);
        if (point == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/EditorWindowImpl", "logicalPositionToXY"));
        }
        return point;
    }

    @NotNull
    public Point visualPositionToXY(@NotNull VisualPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/injected/editor/EditorWindowImpl", "visualPositionToXY"));
        }
        assert (this.isValid());
        Point point = this.logicalPositionToXY(this.visualToLogicalPosition(pos));
        if (point == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/EditorWindowImpl", "visualPositionToXY"));
        }
        return point;
    }

    @Override
    public void repaint(int startOffset, int endOffset) {
        assert (this.isValid());
        this.myDelegate.repaint(this.myDocumentWindow.injectedToHost(startOffset), this.myDocumentWindow.injectedToHost(endOffset));
    }

    @Override
    @NotNull
    public DocumentWindowImpl getDocument() {
        DocumentWindowImpl documentWindowImpl = this.myDocumentWindow;
        if (documentWindowImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/EditorWindowImpl", "getDocument"));
        }
        return documentWindowImpl;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myDelegate.getComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/EditorWindowImpl", "getComponent"));
        }
        return jComponent;
    }

    public void addEditorMouseListener(final @NotNull EditorMouseListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/injected/editor/EditorWindowImpl", "addEditorMouseListener"));
        }
        assert (this.isValid());
        EditorMouseListener wrapper = new EditorMouseListener(){

            public void mousePressed(EditorMouseEvent e) {
                listener.mousePressed(new EditorMouseEvent((Editor)EditorWindowImpl.this, e.getMouseEvent(), e.getArea()));
            }

            public void mouseClicked(EditorMouseEvent e) {
                listener.mouseClicked(new EditorMouseEvent((Editor)EditorWindowImpl.this, e.getMouseEvent(), e.getArea()));
            }

            public void mouseReleased(EditorMouseEvent e) {
                listener.mouseReleased(new EditorMouseEvent((Editor)EditorWindowImpl.this, e.getMouseEvent(), e.getArea()));
            }

            public void mouseEntered(EditorMouseEvent e) {
                listener.mouseEntered(new EditorMouseEvent((Editor)EditorWindowImpl.this, e.getMouseEvent(), e.getArea()));
            }

            public void mouseExited(EditorMouseEvent e) {
                listener.mouseExited(new EditorMouseEvent((Editor)EditorWindowImpl.this, e.getMouseEvent(), e.getArea()));
            }
        };
        this.myEditorMouseListeners.registerWrapper(listener, wrapper);
        this.myDelegate.addEditorMouseListener(wrapper);
    }

    public void removeEditorMouseListener(@NotNull EditorMouseListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/injected/editor/EditorWindowImpl", "removeEditorMouseListener"));
        }
        EditorMouseListener wrapper = this.myEditorMouseListeners.removeWrapper(listener);
        if (wrapper != null) {
            this.myDelegate.removeEditorMouseListener(wrapper);
        }
    }

    public void addEditorMouseMotionListener(final @NotNull EditorMouseMotionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/injected/editor/EditorWindowImpl", "addEditorMouseMotionListener"));
        }
        assert (this.isValid());
        EditorMouseMotionListener wrapper = new EditorMouseMotionListener(){

            public void mouseMoved(EditorMouseEvent e) {
                listener.mouseMoved(new EditorMouseEvent((Editor)EditorWindowImpl.this, e.getMouseEvent(), e.getArea()));
            }

            public void mouseDragged(EditorMouseEvent e) {
                listener.mouseDragged(new EditorMouseEvent((Editor)EditorWindowImpl.this, e.getMouseEvent(), e.getArea()));
            }
        };
        this.myEditorMouseMotionListeners.registerWrapper(listener, wrapper);
        this.myDelegate.addEditorMouseMotionListener(wrapper);
    }

    public void removeEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/injected/editor/EditorWindowImpl", "removeEditorMouseMotionListener"));
        }
        EditorMouseMotionListener wrapper = this.myEditorMouseMotionListeners.removeWrapper(listener);
        if (wrapper != null) {
            this.myDelegate.removeEditorMouseMotionListener(wrapper);
        }
    }

    public boolean isDisposed() {
        return this.myDisposed || this.myDelegate.isDisposed();
    }

    @Override
    public void setBackgroundColor(Color color) {
        this.myDelegate.setBackgroundColor(color);
    }

    @Override
    public Color getBackgroundColor() {
        return this.myDelegate.getBackgroundColor();
    }

    @Override
    public int getMaxWidthInRange(int startOffset, int endOffset) {
        return this.myDelegate.getMaxWidthInRange(startOffset, endOffset);
    }

    public int getLineHeight() {
        return this.myDelegate.getLineHeight();
    }

    @Override
    public Dimension getContentSize() {
        return this.myDelegate.getContentSize();
    }

    @Override
    @NotNull
    public JScrollPane getScrollPane() {
        JScrollPane jScrollPane = this.myDelegate.getScrollPane();
        if (jScrollPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/EditorWindowImpl", "getScrollPane"));
        }
        return jScrollPane;
    }

    public void setBorder(Border border) {
        this.myDelegate.setBorder(border);
    }

    public Insets getInsets() {
        return this.myDelegate.getInsets();
    }

    public int logicalPositionToOffset(@NotNull LogicalPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/injected/editor/EditorWindowImpl", "logicalPositionToOffset"));
        }
        return this.logicalPositionToOffset(pos, true);
    }

    @Override
    public int logicalPositionToOffset(@NotNull LogicalPosition pos, boolean softWrapAware) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/injected/editor/EditorWindowImpl", "logicalPositionToOffset"));
        }
        int lineStartOffset = this.myDocumentWindow.getLineStartOffset(pos.line);
        return this.calcOffset(pos.column, pos.line, lineStartOffset);
    }

    private int calcLogicalColumnNumber(int offsetInLine, int lineNumber, int lineStartOffset) {
        if (this.myDocumentWindow.getTextLength() == 0) {
            return 0;
        }
        if (offsetInLine == 0) {
            return 0;
        }
        int end = this.myDocumentWindow.getLineEndOffset(lineNumber);
        if (offsetInLine > end - lineStartOffset) {
            offsetInLine = end - lineStartOffset;
        }
        CharSequence text = this.myDocumentWindow.getCharsSequence();
        return EditorUtil.calcColumnNumber(this, text, lineStartOffset, lineStartOffset + offsetInLine);
    }

    private int calcOffset(int col, int lineNumber, int lineStartOffset) {
        int x;
        if (this.myDocumentWindow.getTextLength() == 0) {
            return 0;
        }
        int end = this.myDocumentWindow.getLineEndOffset(lineNumber);
        int n = x = this.getDocument().getLineNumber(lineStartOffset) == 0 ? this.getPrefixTextWidthInPixels() : 0;
        if (col <= 0) {
            return lineStartOffset;
        }
        int result = EditorUtil.calcSoftWrapUnawareOffset(this, this.myDocumentWindow.getCharsSequence(), lineStartOffset, end, col, EditorUtil.getTabSize(this.myDelegate), x, new int[]{0}, null);
        if (result >= 0) {
            return result;
        }
        return end;
    }

    @Override
    public void setLastColumnNumber(int val) {
        this.myDelegate.setLastColumnNumber(val);
    }

    @Override
    public int getLastColumnNumber() {
        return this.myDelegate.getLastColumnNumber();
    }

    @Override
    @NotNull
    public VisualPosition logicalToVisualPosition(@NotNull LogicalPosition logicalPos, boolean softWrapAware) {
        if (logicalPos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalPos", "com/intellij/injected/editor/EditorWindowImpl", "logicalToVisualPosition"));
        }
        assert (this.isValid());
        VisualPosition visualPosition = new VisualPosition(logicalPos.line, logicalPos.column);
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/EditorWindowImpl", "logicalToVisualPosition"));
        }
        return visualPosition;
    }

    @NotNull
    public VisualPosition logicalToVisualPosition(@NotNull LogicalPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/injected/editor/EditorWindowImpl", "logicalToVisualPosition"));
        }
        VisualPosition visualPosition = this.logicalToVisualPosition(pos, false);
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/EditorWindowImpl", "logicalToVisualPosition"));
        }
        return visualPosition;
    }

    @NotNull
    public LogicalPosition visualToLogicalPosition(@NotNull VisualPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/injected/editor/EditorWindowImpl", "visualToLogicalPosition"));
        }
        LogicalPosition logicalPosition = this.visualToLogicalPosition(pos, true);
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/EditorWindowImpl", "visualToLogicalPosition"));
        }
        return logicalPosition;
    }

    @Override
    @NotNull
    public LogicalPosition visualToLogicalPosition(@NotNull VisualPosition pos, boolean softWrapAware) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/injected/editor/EditorWindowImpl", "visualToLogicalPosition"));
        }
        assert (this.isValid());
        LogicalPosition logicalPosition = new LogicalPosition(pos.line, pos.column);
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/EditorWindowImpl", "visualToLogicalPosition"));
        }
        return logicalPosition;
    }

    @Override
    @NotNull
    public DataContext getDataContext() {
        DataContext dataContext = this.myDelegate.getDataContext();
        if (dataContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/EditorWindowImpl", "getDataContext"));
        }
        return dataContext;
    }

    public EditorMouseEventArea getMouseEventArea(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/injected/editor/EditorWindowImpl", "getMouseEventArea"));
        }
        return this.myDelegate.getMouseEventArea(e);
    }

    @Override
    public boolean setCaretVisible(boolean b) {
        return this.myDelegate.setCaretVisible(b);
    }

    @Override
    public boolean setCaretEnabled(boolean enabled) {
        return this.myDelegate.setCaretEnabled(enabled);
    }

    @Override
    public void addFocusListener(@NotNull FocusChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/injected/editor/EditorWindowImpl", "addFocusListener"));
        }
        this.myDelegate.addFocusListener(listener);
    }

    @Override
    public void addFocusListener(@NotNull FocusChangeListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/injected/editor/EditorWindowImpl", "addFocusListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/injected/editor/EditorWindowImpl", "addFocusListener"));
        }
        this.myDelegate.addFocusListener(listener, parentDisposable);
    }

    public Project getProject() {
        return this.myDelegate.getProject();
    }

    public boolean isOneLineMode() {
        return this.myOneLine;
    }

    @Override
    public void setOneLineMode(boolean isOneLineMode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmbeddedIntoDialogWrapper() {
        return this.myDelegate.isEmbeddedIntoDialogWrapper();
    }

    @Override
    public void setEmbeddedIntoDialogWrapper(boolean b) {
        this.myDelegate.setEmbeddedIntoDialogWrapper(b);
    }

    @Override
    public VirtualFile getVirtualFile() {
        return this.myDelegate.getVirtualFile();
    }

    @Override
    public CopyProvider getCopyProvider() {
        return this.myDelegate.getCopyProvider();
    }

    @Override
    public CutProvider getCutProvider() {
        return this.myDelegate.getCutProvider();
    }

    @Override
    public PasteProvider getPasteProvider() {
        return this.myDelegate.getPasteProvider();
    }

    @Override
    public DeleteProvider getDeleteProvider() {
        return this.myDelegate.getDeleteProvider();
    }

    @Override
    public void setColorsScheme(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/injected/editor/EditorWindowImpl", "setColorsScheme"));
        }
        this.myDelegate.setColorsScheme(scheme);
    }

    @NotNull
    public EditorColorsScheme getColorsScheme() {
        EditorColorsScheme editorColorsScheme = this.myDelegate.getColorsScheme();
        if (editorColorsScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/EditorWindowImpl", "getColorsScheme"));
        }
        return editorColorsScheme;
    }

    @Override
    public void setVerticalScrollbarOrientation(int type) {
        this.myDelegate.setVerticalScrollbarOrientation(type);
    }

    @Override
    public int getVerticalScrollbarOrientation() {
        return this.myDelegate.getVerticalScrollbarOrientation();
    }

    @Override
    public void setVerticalScrollbarVisible(boolean b) {
        this.myDelegate.setVerticalScrollbarVisible(b);
    }

    @Override
    public void setHorizontalScrollbarVisible(boolean b) {
        this.myDelegate.setHorizontalScrollbarVisible(b);
    }

    @Override
    public boolean processKeyTyped(@NotNull KeyEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/injected/editor/EditorWindowImpl", "processKeyTyped"));
        }
        return this.myDelegate.processKeyTyped(e);
    }

    @NotNull
    public EditorGutter getGutter() {
        EditorGutter editorGutter = this.myDelegate.getGutter();
        if (editorGutter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/EditorWindowImpl", "getGutter"));
        }
        return editorGutter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EditorWindowImpl that = (EditorWindowImpl)o;
        DocumentWindowImpl thatWindow = that.getDocument();
        return this.myDelegate.equals(that.myDelegate) && this.myDocumentWindow.equals(thatWindow);
    }

    public int hashCode() {
        return this.myDocumentWindow.hashCode();
    }

    @Override
    @NotNull
    public Editor getDelegate() {
        EditorImpl editorImpl = this.myDelegate;
        if (editorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/EditorWindowImpl", "getDelegate"));
        }
        return editorImpl;
    }

    @Override
    public int calcColumnNumber(@NotNull CharSequence text, int start, int offset, int tabSize) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/injected/editor/EditorWindowImpl", "calcColumnNumber"));
        }
        int hostStart = this.myDocumentWindow.injectedToHost(start);
        int hostOffset = this.myDocumentWindow.injectedToHost(offset);
        return this.myDelegate.calcColumnNumber(this.myDelegate.getDocument().getText(), hostStart, hostOffset, tabSize);
    }

    @Override
    public int calcColumnNumber(int offset, int lineIndex) {
        return this.myDelegate.calcColumnNumber(this.myDocumentWindow.injectedToHost(offset), this.myDocumentWindow.injectedToHostLine(lineIndex));
    }

    @NotNull
    public IndentsModel getIndentsModel() {
        IndentsModel indentsModel = this.myDelegate.getIndentsModel();
        if (indentsModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/EditorWindowImpl", "getIndentsModel"));
        }
        return indentsModel;
    }

    @Override
    public void setSoftWrapAppliancePlace(@NotNull SoftWrapAppliancePlaces place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/injected/editor/EditorWindowImpl", "setSoftWrapAppliancePlace"));
        }
        this.myDelegate.setSoftWrapAppliancePlace(place);
    }

    @Override
    public void setPlaceholder(@Nullable CharSequence text) {
        this.myDelegate.setPlaceholder(text);
    }

    @Override
    public void setPlaceholderAttributes(@Nullable TextAttributes attributes) {
        this.myDelegate.setPlaceholderAttributes(attributes);
    }

    @Override
    public void setShowPlaceholderWhenFocused(boolean show) {
        this.myDelegate.setShowPlaceholderWhenFocused(show);
    }

    @Override
    public boolean isStickySelection() {
        return this.myDelegate.isStickySelection();
    }

    @Override
    public void setStickySelection(boolean enable) {
        this.myDelegate.setStickySelection(enable);
    }

    @Override
    public boolean isPurePaintingMode() {
        return this.myDelegate.isPurePaintingMode();
    }

    @Override
    public void setPurePaintingMode(boolean enabled) {
        this.myDelegate.setPurePaintingMode(enabled);
    }

    @Override
    public void registerScrollBarRepaintCallback(@Nullable ButtonlessScrollBarUI.ScrollbarRepaintCallback callback) {
        this.myDelegate.registerScrollBarRepaintCallback(callback);
    }

    @Override
    public void setPrefixTextAndAttributes(@Nullable String prefixText, @Nullable TextAttributes attributes) {
        this.myDelegate.setPrefixTextAndAttributes(prefixText, attributes);
    }

    @Override
    public int getPrefixTextWidthInPixels() {
        return this.myDelegate.getPrefixTextWidthInPixels();
    }

    public String toString() {
        return super.toString() + "[disposed=" + this.myDisposed + "; valid=" + this.isValid() + "]";
    }

    @Override
    public int getExpectedCaretOffset() {
        return this.myDocumentWindow.hostToInjected(this.myDelegate.getExpectedCaretOffset());
    }

    @Override
    public void setContextMenuGroupId(@Nullable String groupId) {
        this.myDelegate.setContextMenuGroupId(groupId);
    }

    @Override
    @Nullable
    public String getContextMenuGroupId() {
        return this.myDelegate.getContextMenuGroupId();
    }
}

