/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.injected.editor;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.injected.editor.FoldingRegionWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import java.awt.Point;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FoldingModelWindow
implements FoldingModelEx {
    private final FoldingModelEx myDelegate;
    private final DocumentWindow myDocumentWindow;
    private final EditorWindow myEditorWindow;
    private static final Key<FoldingRegionWindow> FOLD_REGION_WINDOW = Key.create((String)"FOLD_REGION_WINDOW");

    FoldingModelWindow(@NotNull FoldingModelEx delegate, @NotNull DocumentWindow documentWindow, @NotNull EditorWindow editorWindow) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/injected/editor/FoldingModelWindow", "<init>"));
        }
        if (documentWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentWindow", "com/intellij/injected/editor/FoldingModelWindow", "<init>"));
        }
        if (editorWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorWindow", "com/intellij/injected/editor/FoldingModelWindow", "<init>"));
        }
        this.myDelegate = delegate;
        this.myDocumentWindow = documentWindow;
        this.myEditorWindow = editorWindow;
    }

    @Override
    public void setFoldingEnabled(boolean isEnabled) {
        this.myDelegate.setFoldingEnabled(isEnabled);
    }

    @Override
    public boolean isFoldingEnabled() {
        return this.myDelegate.isFoldingEnabled();
    }

    @Override
    public FoldRegion getFoldingPlaceholderAt(Point p) {
        return this.myDelegate.getFoldingPlaceholderAt(p);
    }

    @Override
    public boolean intersectsRegion(int startOffset, int endOffset) {
        int hostStart = this.myDocumentWindow.injectedToHost(startOffset);
        int hostEnd = this.myDocumentWindow.injectedToHost(endOffset);
        return this.myDelegate.intersectsRegion(hostStart, hostEnd);
    }

    public FoldRegion addFoldRegion(int startOffset, int endOffset, @NotNull String placeholderText) {
        if (placeholderText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeholderText", "com/intellij/injected/editor/FoldingModelWindow", "addFoldRegion"));
        }
        FoldRegion region = this.createFoldRegion(startOffset, endOffset, placeholderText, null, false);
        if (region == null) {
            return null;
        }
        if (!this.addFoldRegion(region)) {
            region.dispose();
            return null;
        }
        return region;
    }

    public boolean addFoldRegion(@NotNull FoldRegion region) {
        if (region == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "region", "com/intellij/injected/editor/FoldingModelWindow", "addFoldRegion"));
        }
        return this.myDelegate.addFoldRegion((FoldRegion)((FoldingRegionWindow)region).getDelegate());
    }

    public void removeFoldRegion(@NotNull FoldRegion region) {
        if (region == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "region", "com/intellij/injected/editor/FoldingModelWindow", "removeFoldRegion"));
        }
        this.myDelegate.removeFoldRegion((FoldRegion)((FoldingRegionWindow)region).getDelegate());
    }

    @NotNull
    public FoldRegion[] getAllFoldRegions() {
        FoldRegion[] all2 = this.myDelegate.getAllFoldRegions();
        ArrayList<FoldingRegionWindow> result = new ArrayList<FoldingRegionWindow>();
        for (FoldRegion region : all2) {
            FoldingRegionWindow window = (FoldingRegionWindow)region.getUserData(FOLD_REGION_WINDOW);
            if (window == null || window.getEditor() != this.myEditorWindow) continue;
            result.add(window);
        }
        FoldRegion[] foldRegionArray = result.toArray(new FoldRegion[result.size()]);
        if (foldRegionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/FoldingModelWindow", "getAllFoldRegions"));
        }
        return foldRegionArray;
    }

    public boolean isOffsetCollapsed(int offset) {
        return this.myDelegate.isOffsetCollapsed(this.myDocumentWindow.injectedToHost(offset));
    }

    public FoldRegion getCollapsedRegionAtOffset(int offset) {
        FoldRegion host = this.myDelegate.getCollapsedRegionAtOffset(this.myDocumentWindow.injectedToHost(offset));
        return host;
    }

    @Nullable
    public FoldRegion getFoldRegion(int startOffset, int endOffset) {
        TextRange range = new TextRange(startOffset, endOffset);
        TextRange hostRange = this.myDocumentWindow.injectedToHost(range);
        FoldRegion hostRegion = this.myDelegate.getFoldRegion(hostRange.getStartOffset(), hostRange.getEndOffset());
        if (hostRegion == null) {
            return null;
        }
        FoldingRegionWindow window = (FoldingRegionWindow)hostRegion.getUserData(FOLD_REGION_WINDOW);
        return window != null && window.getEditor() == this.myEditorWindow ? window : null;
    }

    public void runBatchFoldingOperation(@NotNull Runnable operation) {
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/injected/editor/FoldingModelWindow", "runBatchFoldingOperation"));
        }
        this.myDelegate.runBatchFoldingOperation(operation);
    }

    public void runBatchFoldingOperation(@NotNull Runnable operation, boolean moveCaretFromCollapsedRegion) {
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/injected/editor/FoldingModelWindow", "runBatchFoldingOperation"));
        }
        this.myDelegate.runBatchFoldingOperation(operation, moveCaretFromCollapsedRegion);
    }

    public void runBatchFoldingOperationDoNotCollapseCaret(@NotNull Runnable operation) {
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/injected/editor/FoldingModelWindow", "runBatchFoldingOperationDoNotCollapseCaret"));
        }
        this.myDelegate.runBatchFoldingOperationDoNotCollapseCaret(operation);
    }

    @Override
    public FoldRegion fetchOutermost(int offset) {
        FoldRegion host = this.myDelegate.fetchOutermost(this.myDocumentWindow.injectedToHost(offset));
        return host;
    }

    @Override
    public int getLastCollapsedRegionBefore(int offset) {
        return -1;
    }

    @Override
    public TextAttributes getPlaceholderAttributes() {
        return this.myDelegate.getPlaceholderAttributes();
    }

    @Override
    public FoldRegion[] fetchTopLevel() {
        return FoldRegion.EMPTY_ARRAY;
    }

    @Override
    public FoldRegion createFoldRegion(int startOffset, int endOffset, @NotNull String placeholder, FoldingGroup group, boolean neverExpands) {
        if (placeholder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeholder", "com/intellij/injected/editor/FoldingModelWindow", "createFoldRegion"));
        }
        TextRange hostRange = this.myDocumentWindow.injectedToHost(new TextRange(startOffset, endOffset));
        if (hostRange.getLength() < 2) {
            return null;
        }
        FoldRegion hostRegion = this.myDelegate.createFoldRegion(hostRange.getStartOffset(), hostRange.getEndOffset(), placeholder, group, neverExpands);
        int startShift = Math.max(0, this.myDocumentWindow.hostToInjected(hostRange.getStartOffset()) - startOffset);
        int endShift = Math.max(0, endOffset - this.myDocumentWindow.hostToInjected(hostRange.getEndOffset()) - startShift);
        FoldingRegionWindow window = new FoldingRegionWindow(this.myDocumentWindow, this.myEditorWindow, hostRegion, startShift, endShift);
        hostRegion.putUserData(FOLD_REGION_WINDOW, (Object)window);
        return window;
    }

    @Override
    public void addListener(@NotNull FoldingListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/injected/editor/FoldingModelWindow", "addListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/injected/editor/FoldingModelWindow", "addListener"));
        }
        this.myDelegate.addListener(listener, parentDisposable);
    }

    @Override
    public void rebuild() {
        this.myDelegate.rebuild();
    }

    @Override
    public void clearFoldRegions() {
        this.myDelegate.clearFoldRegions();
    }
}

