/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.internal.ImageDuplicateResultsDialog;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ShowImageDuplicatesAction
extends AnAction {
    private static final List<String> IMAGE_EXTENSIONS = Arrays.asList("png", "jpg", "jpeg", "gif", "tiff", "bmp");

    public void actionPerformed(AnActionEvent e) {
        final Project project = ShowImageDuplicatesAction.getEventProject((AnActionEvent)e);
        assert (project != null);
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                ShowImageDuplicatesAction.collectAndShowDuplicates(project);
            }
        }, "Gathering images", true, project);
    }

    private static void collectAndShowDuplicates(Project project) {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null && !indicator.isCanceled()) {
            indicator.setText("Collecting project images...");
            indicator.setIndeterminate(false);
            ArrayList<VirtualFile> images = new ArrayList<VirtualFile>();
            for (String ext : IMAGE_EXTENSIONS) {
                images.addAll(FilenameIndex.getAllFilesByExt(project, ext));
            }
            HashMap<Long, Set<VirtualFile>> duplicates = new HashMap<Long, Set<VirtualFile>>();
            HashMap<Long, VirtualFile> all2 = new HashMap<Long, VirtualFile>();
            for (int i = 0; i < images.size(); ++i) {
                indicator.setFraction((double)(i + 1) / (double)images.size());
                VirtualFile file = (VirtualFile)images.get(i);
                if (!(file.getFileSystem() instanceof LocalFileSystem)) continue;
                long length = file.getLength();
                if (all2.containsKey(length)) {
                    if (!duplicates.containsKey(length)) {
                        HashSet files = new HashSet();
                        files.add(all2.get(length));
                        duplicates.put(length, files);
                    }
                    ((Set)duplicates.get(length)).add(file);
                } else {
                    all2.put(length, file);
                }
                indicator.checkCanceled();
            }
            ShowImageDuplicatesAction.showResults(project, images, duplicates, all2);
        }
    }

    private static void showResults(final Project project, final List<VirtualFile> images, Map<Long, Set<VirtualFile>> duplicates, Map<Long, VirtualFile> all2) {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator == null || indicator.isCanceled()) {
            return;
        }
        indicator.setText("MD5 check");
        int count = 0;
        for (Set<VirtualFile> set : duplicates.values()) {
            count += set.size();
        }
        final HashMap realDuplicates = new HashMap();
        int seek = 0;
        for (Set<VirtualFile> files : duplicates.values()) {
            for (VirtualFile file : files) {
                indicator.setFraction((double)(++seek) / (double)count);
                try {
                    String md5 = ShowImageDuplicatesAction.getMD5Checksum(file.getInputStream());
                    if (realDuplicates.containsKey(md5)) {
                        ((Set)realDuplicates.get(md5)).add(file);
                        continue;
                    }
                    HashSet<VirtualFile> set = new HashSet<VirtualFile>();
                    set.add(file);
                    realDuplicates.put(md5, set);
                }
                catch (Exception exception) {}
            }
        }
        count = 0;
        for (String key : new ArrayList(realDuplicates.keySet())) {
            int size = ((Set)realDuplicates.get(key)).size();
            if (size == 1) {
                realDuplicates.remove(key);
                continue;
            }
            count += size;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                new ImageDuplicateResultsDialog(project, images, realDuplicates).show();
            }
        });
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(ShowImageDuplicatesAction.getEventProject((AnActionEvent)e) != null);
    }

    public static byte[] createChecksum(InputStream fis) throws Exception {
        int read;
        byte[] buffer = new byte[1024];
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        while ((read = fis.read(buffer)) > 0) {
            md5.update(buffer, 0, read);
        }
        fis.close();
        return md5.digest();
    }

    public static String getMD5Checksum(InputStream fis) throws Exception {
        byte[] bytes = ShowImageDuplicatesAction.createChecksum(fis);
        String md5 = "";
        for (byte b : bytes) {
            md5 = md5 + Integer.toString((b & 0xFF) + 256, 16).substring(1);
        }
        return md5;
    }
}

