/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentsPackage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.components.impl.stores.UnknownMacroNotification;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.ProjectMacrosUtil;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StorageUtil {
    public static final String DEFAULT_EXT = ".xml";
    private static final Logger LOG = Logger.getInstance(StorageUtil.class);
    public static String DEBUG_LOG = null;

    private StorageUtil() {
    }

    public static void checkUnknownMacros(final @NotNull ComponentManager componentManager, final @NotNull Project project) {
        if (componentManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentManager", "com/intellij/openapi/components/impl/stores/StorageUtil", "checkUnknownMacros"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/components/impl/stores/StorageUtil", "checkUnknownMacros"));
        }
        Application application = ApplicationManager.getApplication();
        if (application.isHeadlessEnvironment() || application.isUnitTestMode()) {
            return;
        }
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(new Runnable(){

            @Override
            public void run() {
                StorageUtil.notifyUnknownMacros(ComponentsPackage.getStateStore(componentManager), project, null);
            }
        });
    }

    public static void notifyUnknownMacros(final @NotNull IComponentStore store, final @NotNull Project project, final @Nullable String componentName) {
        if (store == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "store", "com/intellij/openapi/components/impl/stores/StorageUtil", "notifyUnknownMacros"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/components/impl/stores/StorageUtil", "notifyUnknownMacros"));
        }
        TrackingPathMacroSubstitutor substitutor = store.getStateStorageManager().getMacroSubstitutor();
        if (substitutor == null) {
            return;
        }
        final LinkedHashSet<String> macros = new LinkedHashSet<String>(substitutor.getUnknownMacros(componentName));
        if (macros.isEmpty()) {
            return;
        }
        AppUIUtil.invokeOnEdt(new Runnable(){

            @Override
            public void run() {
                SmartList notified = null;
                NotificationsManager manager = NotificationsManager.getNotificationsManager();
                for (UnknownMacroNotification notification : (UnknownMacroNotification[])manager.getNotificationsOfType(UnknownMacroNotification.class, project)) {
                    if (notified == null) {
                        notified = new SmartList();
                    }
                    notified.addAll(notification.getMacros());
                }
                if (!ContainerUtil.isEmpty(notified)) {
                    macros.removeAll((Collection<?>)notified);
                }
                if (macros.isEmpty()) {
                    return;
                }
                LOG.debug("Reporting unknown path macros " + macros + " in component " + componentName);
                String format = "<p><i>%s</i> %s undefined. <a href=\"define\">Fix it</a></p>";
                String productName = ApplicationNamesInfo.getInstance().getProductName();
                String content = String.format(format, StringUtil.join((Collection)macros, (String)", "), macros.size() == 1 ? "is" : "are") + "<br>Path variables are used to substitute absolute paths " + "in " + productName + " project files " + "and allow project file sharing in version control systems.<br>" + "Some of the files describing the current project settings contain unknown path variables " + "and " + productName + " cannot restore those paths.";
                new UnknownMacroNotification("Load Error", "Load error: undefined path variables", content, NotificationType.ERROR, new NotificationListener(){

                    public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                        if (notification == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/openapi/components/impl/stores/StorageUtil$2$1", "hyperlinkUpdate"));
                        }
                        if (event == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/components/impl/stores/StorageUtil$2$1", "hyperlinkUpdate"));
                        }
                        StorageUtil.checkUnknownMacros(store, project, true);
                    }
                }, macros).notify(project);
            }
        }, project.getDisposed());
    }

    public static void checkUnknownMacros(@NotNull IComponentStore store, @NotNull Project project, boolean showDialog) {
        if (store == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "store", "com/intellij/openapi/components/impl/stores/StorageUtil", "checkUnknownMacros"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/components/impl/stores/StorageUtil", "checkUnknownMacros"));
        }
        List<Object> substitutors = store instanceof IProjectStore ? ((IProjectStore)store).getSubstitutors() : Collections.emptyList();
        THashSet unknownMacros = new THashSet();
        for (TrackingPathMacroSubstitutor trackingPathMacroSubstitutor : substitutors) {
            unknownMacros.addAll(trackingPathMacroSubstitutor.getUnknownMacros(null));
        }
        if (unknownMacros.isEmpty() || showDialog && !ProjectMacrosUtil.checkMacros(project, (Set<String>)new THashSet((Collection)unknownMacros))) {
            return;
        }
        PathMacros pathMacros = PathMacros.getInstance();
        THashSet tHashSet = new THashSet((Collection)unknownMacros);
        Iterator it = tHashSet.iterator();
        while (it.hasNext()) {
            String macro = (String)it.next();
            if (!StringUtil.isEmptyOrSpaces((String)pathMacros.getValue(macro)) || pathMacros.isIgnoredMacroName(macro)) continue;
            it.remove();
        }
        if (tHashSet.isEmpty()) {
            return;
        }
        THashSet components = new THashSet();
        for (TrackingPathMacroSubstitutor trackingPathMacroSubstitutor : substitutors) {
            components.addAll(trackingPathMacroSubstitutor.getComponents((Collection<String>)tHashSet));
        }
        if (store.isReloadPossible((Set<String>)components)) {
            for (TrackingPathMacroSubstitutor trackingPathMacroSubstitutor : substitutors) {
                trackingPathMacroSubstitutor.invalidateUnknownMacros((Set<String>)tHashSet);
            }
            for (UnknownMacroNotification notification : (UnknownMacroNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(UnknownMacroNotification.class, project)) {
                if (!tHashSet.containsAll(notification.getMacros())) continue;
                notification.expire();
            }
            store.reloadStates((Set<String>)components, project.getMessageBus());
        } else if (Messages.showYesNoDialog((Project)project, (String)"Component could not be reloaded. Reload project?", (String)"Configuration Changed", (Icon)Messages.getQuestionIcon()) == 0) {
            ProjectManagerEx.getInstanceEx().reloadProject(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static VirtualFile getOrCreateVirtualFile(@Nullable Object requestor, @NotNull File file) throws IOException {
        VirtualFile parentVirtualFile;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/components/impl/stores/StorageUtil", "getOrCreateVirtualFile"));
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
        if (virtualFile != null) {
            VirtualFile virtualFile2 = virtualFile;
            if (virtualFile2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageUtil", "getOrCreateVirtualFile"));
            }
            return virtualFile2;
        }
        File absoluteFile = file.getAbsoluteFile();
        FileUtil.createParentDirs((File)absoluteFile);
        File parentFile = absoluteFile.getParentFile();
        VirtualFile virtualFile3 = parentVirtualFile = StringUtil.isEmpty((String)parentFile.getPath()) ? null : LocalFileSystem.getInstance().refreshAndFindFileByIoFile(parentFile);
        if (parentVirtualFile == null) {
            throw new IOException(ProjectBundle.message((String)"project.configuration.save.file.not.found", (Object[])new Object[]{parentFile}));
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            VirtualFile virtualFile4 = parentVirtualFile.createChildData(requestor, file.getName());
            if (virtualFile4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageUtil", "getOrCreateVirtualFile"));
            }
            return virtualFile4;
        }
        AccessToken token = WriteAction.start();
        VirtualFile virtualFile5 = parentVirtualFile.createChildData(requestor, file.getName());
        VirtualFile virtualFile6 = virtualFile5;
        if (virtualFile6 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageUtil", "getOrCreateVirtualFile"));
        }
        return virtualFile6;
        finally {
            token.finish();
        }
    }
}

