/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import org.jetbrains.annotations.Nullable;

class NextPrevWordHandler
extends EditorActionHandler {
    private final boolean myNext;
    private final boolean myWithSelection;
    private final boolean myInDifferentHumpsMode;

    NextPrevWordHandler(boolean next, boolean withSelection, boolean inDifferentHumpsMode) {
        super(true);
        this.myNext = next;
        this.myWithSelection = withSelection;
        this.myInDifferentHumpsMode = inDifferentHumpsMode;
    }

    protected void doExecute(Editor editor, @Nullable Caret caret, DataContext dataContext) {
        assert (caret != null);
        VisualPosition currentPosition = caret.getVisualPosition();
        if (caret.isAtBidiRunBoundary() && this.myNext ^ currentPosition.leansRight) {
            int selectionStartOffset = caret.getLeadSelectionOffset();
            VisualPosition selectionStartPosition = caret.getLeadSelectionPosition();
            caret.moveToVisualPosition(currentPosition.leanRight(!currentPosition.leansRight));
            if (this.myWithSelection) {
                caret.setSelection(selectionStartPosition, selectionStartOffset, caret.getVisualPosition(), caret.getOffset());
            }
        } else if (this.myNext ^ caret.isAtRtlLocation()) {
            EditorActionUtil.moveCaretToNextWord(editor, this.myWithSelection, this.myInDifferentHumpsMode ^ editor.getSettings().isCamelWords());
        } else {
            EditorActionUtil.moveCaretToPreviousWord(editor, this.myWithSelection, this.myInDifferentHumpsMode ^ editor.getSettings().isCamelWords());
        }
    }
}

