/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.impl.OrderEntryBaseImpl;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class LibraryOrderEntryBaseImpl
extends OrderEntryBaseImpl
implements LibraryOrSdkOrderEntry {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.LibraryOrderEntryBaseImpl");
    protected final ProjectRootManagerImpl myProjectRootManagerImpl;
    @NotNull
    protected DependencyScope myScope;
    @Nullable
    private RootProvider myCurrentlySubscribedRootProvider;

    LibraryOrderEntryBaseImpl(@NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager) {
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/openapi/roots/impl/LibraryOrderEntryBaseImpl", "<init>"));
        }
        if (projectRootManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectRootManager", "com/intellij/openapi/roots/impl/LibraryOrderEntryBaseImpl", "<init>"));
        }
        super(rootModel);
        this.myScope = DependencyScope.COMPILE;
        this.myCurrentlySubscribedRootProvider = null;
        this.myProjectRootManagerImpl = projectRootManager;
    }

    protected final void init() {
        this.updateFromRootProviderAndSubscribe();
    }

    @NotNull
    public VirtualFile[] getFiles(@NotNull OrderRootType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/roots/impl/LibraryOrderEntryBaseImpl", "getFiles"));
        }
        VirtualFile[] virtualFileArray = this.getRootFiles(type);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/LibraryOrderEntryBaseImpl", "getFiles"));
        }
        return virtualFileArray;
    }

    @NotNull
    public String[] getUrls(@NotNull OrderRootType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/roots/impl/LibraryOrderEntryBaseImpl", "getUrls"));
        }
        LOG.assertTrue(!this.getRootModel().getModule().isDisposed());
        String[] stringArray = this.getRootUrls(type);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/LibraryOrderEntryBaseImpl", "getUrls"));
        }
        return stringArray;
    }

    public VirtualFile[] getRootFiles(@NotNull OrderRootType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/roots/impl/LibraryOrderEntryBaseImpl", "getRootFiles"));
        }
        RootProvider rootProvider = this.getRootProvider();
        return rootProvider != null ? rootProvider.getFiles(type) : VirtualFile.EMPTY_ARRAY;
    }

    @Nullable
    protected abstract RootProvider getRootProvider();

    @NotNull
    public String[] getRootUrls(@NotNull OrderRootType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/roots/impl/LibraryOrderEntryBaseImpl", "getRootUrls"));
        }
        RootProvider rootProvider = this.getRootProvider();
        String[] stringArray = rootProvider == null ? ArrayUtil.EMPTY_STRING_ARRAY : rootProvider.getUrls(type);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/LibraryOrderEntryBaseImpl", "getRootUrls"));
        }
        return stringArray;
    }

    @NotNull
    public final Module getOwnerModule() {
        Module module = this.getRootModel().getModule();
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/LibraryOrderEntryBaseImpl", "getOwnerModule"));
        }
        return module;
    }

    protected void updateFromRootProviderAndSubscribe() {
        this.getRootModel().makeExternalChange(new Runnable(){

            @Override
            public void run() {
                LibraryOrderEntryBaseImpl.this.resubscribe(LibraryOrderEntryBaseImpl.this.getRootProvider());
            }
        });
    }

    private void resubscribe(RootProvider wrapper) {
        this.unsubscribe();
        this.subscribe(wrapper);
    }

    private void subscribe(@Nullable RootProvider wrapper) {
        if (wrapper != null) {
            this.myProjectRootManagerImpl.subscribeToRootProvider(this, wrapper);
        }
        this.myCurrentlySubscribedRootProvider = wrapper;
    }

    private void unsubscribe() {
        if (this.myCurrentlySubscribedRootProvider != null) {
            this.myProjectRootManagerImpl.unsubscribeFromRootProvider(this, this.myCurrentlySubscribedRootProvider);
        }
        this.myCurrentlySubscribedRootProvider = null;
    }

    @Override
    public void dispose() {
        this.unsubscribe();
        super.dispose();
    }
}

