/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.actions.AbstractVcsAction;
import com.intellij.openapi.vcs.actions.DiffActionExecutor;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.impl.BackgroundableActionEnabledHandler;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractShowDiffAction
extends AbstractVcsAction {
    @Override
    protected void update(VcsContext vcsContext, Presentation presentation) {
        AbstractShowDiffAction.updateDiffAction(presentation, vcsContext, this.getKey());
    }

    protected static void updateDiffAction(Presentation presentation, VcsContext vcsContext, VcsBackgroundableActions actionKey) {
        presentation.setEnabled(AbstractShowDiffAction.isEnabled(vcsContext, actionKey) != null);
        presentation.setVisible(AbstractShowDiffAction.isVisible(vcsContext));
    }

    protected boolean forceSyncUpdate(AnActionEvent e) {
        return true;
    }

    protected abstract VcsBackgroundableActions getKey();

    protected static boolean isVisible(VcsContext vcsContext) {
        AbstractVcs[] vcss;
        Project project = vcsContext.getProject();
        if (project == null) {
            return false;
        }
        for (AbstractVcs vcs : vcss = ProjectLevelVcsManager.getInstance((Project)project).getAllActiveVcss()) {
            if (vcs.getDiffProvider() == null) continue;
            return true;
        }
        return false;
    }

    @Nullable
    protected static AbstractVcs isEnabled(VcsContext vcsContext, @Nullable VcsBackgroundableActions actionKey) {
        BackgroundableActionEnabledHandler handler;
        if (!AbstractShowDiffAction.isVisible(vcsContext)) {
            return null;
        }
        Project project = vcsContext.getProject();
        if (project == null) {
            return null;
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        VirtualFile[] selectedFilePaths = vcsContext.getSelectedFiles();
        if (selectedFilePaths.length != 1) {
            return null;
        }
        VirtualFile selectedFile = selectedFilePaths[0];
        if (selectedFile.isDirectory()) {
            return null;
        }
        if (actionKey != null && (handler = ((ProjectLevelVcsManagerImpl)vcsManager).getBackgroundableActionHandler(actionKey)).isInProgress(VcsBackgroundableActions.keyFrom(selectedFile))) {
            return null;
        }
        AbstractVcs vcs = vcsManager.getVcsFor(selectedFile);
        if (vcs == null) {
            return null;
        }
        DiffProvider diffProvider = vcs.getDiffProvider();
        if (diffProvider == null) {
            return null;
        }
        if (AbstractVcs.fileInVcsByFileStatus((Project)project, (FilePath)VcsUtil.getFilePath((VirtualFile)selectedFile))) {
            return vcs;
        }
        return null;
    }

    @Override
    protected void actionPerformed(@NotNull VcsContext vcsContext) {
        if (vcsContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsContext", "com/intellij/openapi/vcs/actions/AbstractShowDiffAction", "actionPerformed"));
        }
        Project project = vcsContext.getProject();
        if (project == null) {
            return;
        }
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification("Can not " + vcsContext.getActionName() + " now")) {
            return;
        }
        VirtualFile selectedFile = vcsContext.getSelectedFiles()[0];
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        AbstractVcs vcs = vcsManager.getVcsFor(selectedFile);
        DiffProvider diffProvider = vcs.getDiffProvider();
        DiffActionExecutor actionExecutor = this.getExecutor(diffProvider, selectedFile, project);
        actionExecutor.showDiff();
    }

    protected DiffActionExecutor getExecutor(DiffProvider diffProvider, VirtualFile selectedFile, Project project) {
        return new DiffActionExecutor.CompareToCurrentExecutor(diffProvider, selectedFile, project, this.getKey());
    }
}

