/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListEditHandler;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.OpenTHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalChangeListImpl
extends LocalChangeList {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.ChangeList");
    private final Project myProject;
    private Collection<Change> myChanges = new HashSet<Change>();
    private Collection<Change> myReadChangesCache = null;
    private String myId;
    @NotNull
    private String myName;
    private String myComment = "";
    @Nullable
    private Object myData;
    private boolean myIsDefault = false;
    private boolean myIsReadOnly = false;
    private OpenTHashSet<Change> myChangesBeforeUpdate;

    @NotNull
    public static LocalChangeListImpl createEmptyChangeListImpl(Project project, String name) {
        LocalChangeListImpl localChangeListImpl = new LocalChangeListImpl(project, name);
        if (localChangeListImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "createEmptyChangeListImpl"));
        }
        return localChangeListImpl;
    }

    private LocalChangeListImpl(Project project, String name) {
        this.myProject = project;
        this.myId = UUID.randomUUID().toString();
        this.setNameImpl(name);
    }

    private LocalChangeListImpl(LocalChangeListImpl origin) {
        this.myId = origin.getId();
        this.myProject = origin.myProject;
        this.setNameImpl(origin.myName);
    }

    public Collection<Change> getChanges() {
        this.createReadChangesCache();
        return this.myReadChangesCache;
    }

    private void createReadChangesCache() {
        if (this.myReadChangesCache == null) {
            this.myReadChangesCache = Collections.unmodifiableCollection(new HashSet<Change>(this.myChanges));
        }
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "getId"));
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "getName"));
        }
        return string;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "setName"));
        }
        if (!this.myName.equals(name)) {
            this.setNameImpl(name);
        }
    }

    public String getComment() {
        return this.myComment;
    }

    public void setComment(String comment) {
        if (!Comparing.equal((String)comment, (String)this.myComment)) {
            this.myComment = comment != null ? comment : "";
        }
    }

    void setNameImpl(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "setNameImpl"));
        }
        if (StringUtil.isEmptyOrSpaces((String)name) && Registry.is((String)"vcs.log.empty.change.list.creation")) {
            LOG.info("Creating a changelist with empty name");
        }
        this.myName = name;
    }

    void setCommentImpl(String comment) {
        this.myComment = comment;
    }

    public boolean isDefault() {
        return this.myIsDefault;
    }

    void setDefault(boolean isDefault) {
        this.myIsDefault = isDefault;
    }

    public boolean isReadOnly() {
        return this.myIsReadOnly;
    }

    public void setReadOnly(boolean isReadOnly) {
        this.myIsReadOnly = isReadOnly;
    }

    void setData(@Nullable Object data) {
        this.myData = data;
    }

    @Nullable
    public Object getData() {
        return this.myData;
    }

    void addChange(Change change) {
        this.myReadChangesCache = null;
        this.myChanges.add(change);
    }

    Change removeChange(Change change) {
        for (Change localChange : this.myChanges) {
            if (!localChange.equals((Object)change)) continue;
            this.myChanges.remove(localChange);
            this.myReadChangesCache = null;
            return localChange;
        }
        return null;
    }

    Collection<Change> startProcessingChanges(Project project, @Nullable VcsDirtyScope scope) {
        this.createReadChangesCache();
        ArrayList<Change> result = new ArrayList<Change>();
        this.myChangesBeforeUpdate = new OpenTHashSet(this.myChanges);
        for (Change oldBoy : this.myChangesBeforeUpdate) {
            ContentRevision before = oldBoy.getBeforeRevision();
            ContentRevision after = oldBoy.getAfterRevision();
            if (!(scope == null || before != null && scope.belongsTo(before.getFile()) || after != null && scope.belongsTo(after.getFile())) && !LocalChangeListImpl.isIgnoredChange(oldBoy, project)) continue;
            result.add(oldBoy);
            this.myChanges.remove(oldBoy);
            this.myReadChangesCache = null;
        }
        return result;
    }

    private static boolean isIgnoredChange(@NotNull Change change, @NotNull Project project) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "isIgnoredChange"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "isIgnoredChange"));
        }
        boolean beforeRevIgnored = change.getBeforeRevision() == null || LocalChangeListImpl.isIgnoredRevision(change.getBeforeRevision(), project);
        boolean afterRevIgnored = change.getAfterRevision() == null || LocalChangeListImpl.isIgnoredRevision(change.getAfterRevision(), project);
        return beforeRevIgnored && afterRevIgnored;
    }

    private static boolean isIgnoredRevision(final @NotNull ContentRevision revision, final @NotNull Project project) {
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "isIgnoredRevision"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "isIgnoredRevision"));
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                if (project.isDisposed()) {
                    return false;
                }
                VirtualFile vFile = revision.getFile().getVirtualFile();
                return vFile != null && ProjectLevelVcsManager.getInstance((Project)project).isIgnored(vFile);
            }
        });
    }

    boolean processChange(Change change) {
        LOG.debug("[process change] for '" + this.myName + "' isDefault: " + this.myIsDefault + " change: " + ChangesUtil.getFilePath((Change)change).getPath());
        if (this.myIsDefault) {
            LOG.debug("[process change] adding because default");
            this.addChange(change);
            return true;
        }
        for (Change oldChange : this.myChangesBeforeUpdate) {
            if (!Comparing.equal((Object)oldChange, (Object)change)) continue;
            LOG.debug("[process change] adding bacuae equal to old: " + ChangesUtil.getFilePath((Change)oldChange).getPath());
            this.addChange(change);
            return true;
        }
        LOG.debug("[process change] not found");
        return false;
    }

    boolean doneProcessingChanges(List<Change> removedChanges, List<Change> addedChanges) {
        boolean changesDetected = this.myChanges.size() != this.myChangesBeforeUpdate.size();
        for (Change newChange : this.myChanges) {
            Change oldChange = this.findOldChange(newChange);
            if (oldChange != null) continue;
            addedChanges.add(newChange);
        }
        changesDetected |= !addedChanges.isEmpty();
        ArrayList<Change> removed = new ArrayList<Change>((Collection<Change>)this.myChangesBeforeUpdate);
        removed.removeAll(this.myChanges);
        removedChanges.addAll(removed);
        changesDetected = changesDetected || !removedChanges.isEmpty();
        this.myReadChangesCache = null;
        return changesDetected;
    }

    @Nullable
    private Change findOldChange(Change newChange) {
        Change oldChange = (Change)this.myChangesBeforeUpdate.get((Object)newChange);
        if (oldChange != null && LocalChangeListImpl.sameBeforeRevision(oldChange, newChange) && newChange.getFileStatus().equals(oldChange.getFileStatus())) {
            return oldChange;
        }
        return null;
    }

    private static boolean sameBeforeRevision(Change change1, Change change2) {
        ContentRevision b1 = change1.getBeforeRevision();
        ContentRevision b2 = change2.getBeforeRevision();
        if (b1 != null && b2 != null) {
            VcsRevisionNumber rn1 = b1.getRevisionNumber();
            VcsRevisionNumber rn2 = b2.getRevisionNumber();
            boolean isBinary1 = b1 instanceof BinaryContentRevision;
            boolean isBinary2 = b2 instanceof BinaryContentRevision;
            return rn1 != VcsRevisionNumber.NULL && rn2 != VcsRevisionNumber.NULL && rn1.compareTo((Object)rn2) == 0 && isBinary1 == isBinary2;
        }
        return b1 == null && b2 == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LocalChangeListImpl list = (LocalChangeListImpl)((Object)o);
        return this.myName.equals(list.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public String toString() {
        return this.myName.trim();
    }

    public LocalChangeList copy() {
        LocalChangeListImpl copy = new LocalChangeListImpl(this);
        copy.myComment = this.myComment;
        copy.myIsDefault = this.myIsDefault;
        copy.myIsReadOnly = this.myIsReadOnly;
        copy.myData = this.myData;
        if (this.myChanges != null) {
            copy.myChanges = new HashSet<Change>(this.myChanges);
        }
        if (this.myChangesBeforeUpdate != null) {
            copy.myChangesBeforeUpdate = new OpenTHashSet(this.myChangesBeforeUpdate);
        }
        if (this.myReadChangesCache != null) {
            copy.myReadChangesCache = new HashSet<Change>(this.myReadChangesCache);
        }
        return copy;
    }

    @Nullable
    public ChangeListEditHandler getEditHandler() {
        return null;
    }

    public void setId(String id) {
        this.myId = id;
    }
}

