/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyPatchMergeRequest
extends MergeRequest {
    @Nullable
    private final Project myProject;
    @NotNull
    private final Document myDocument;
    @NotNull
    private final CharSequence myOriginalContent;
    @NotNull
    private final String myLocalContent;
    @NotNull
    private final String myPatchedContent;
    @NotNull
    private final String myWindowTitle;
    @NotNull
    private final String myLocalTitle;
    @NotNull
    private final String myPatchedTitle;
    @Nullable
    private final Consumer<MergeResult> myCallback;

    public ApplyPatchMergeRequest(@Nullable Project project, @NotNull Document document, @NotNull String localContent, @NotNull String patchedContent, @NotNull String windowTitle, @NotNull String localTitle, @NotNull String patchedTitle, @Nullable Consumer<MergeResult> callback) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/vcs/changes/patch/ApplyPatchMergeRequest", "<init>"));
        }
        if (localContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localContent", "com/intellij/openapi/vcs/changes/patch/ApplyPatchMergeRequest", "<init>"));
        }
        if (patchedContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patchedContent", "com/intellij/openapi/vcs/changes/patch/ApplyPatchMergeRequest", "<init>"));
        }
        if (windowTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "windowTitle", "com/intellij/openapi/vcs/changes/patch/ApplyPatchMergeRequest", "<init>"));
        }
        if (localTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localTitle", "com/intellij/openapi/vcs/changes/patch/ApplyPatchMergeRequest", "<init>"));
        }
        if (patchedTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patchedTitle", "com/intellij/openapi/vcs/changes/patch/ApplyPatchMergeRequest", "<init>"));
        }
        this.myProject = project;
        this.myDocument = document;
        this.myOriginalContent = (CharSequence)ApplicationManager.getApplication().runReadAction((Computable)new Computable<CharSequence>(){

            public CharSequence compute() {
                return ApplyPatchMergeRequest.this.myDocument.getImmutableCharSequence();
            }
        });
        this.myLocalContent = localContent;
        this.myPatchedContent = patchedContent;
        this.myWindowTitle = windowTitle;
        this.myLocalTitle = localTitle;
        this.myPatchedTitle = patchedTitle;
        this.myCallback = callback;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public Document getDocument() {
        Document document = this.myDocument;
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ApplyPatchMergeRequest", "getDocument"));
        }
        return document;
    }

    @NotNull
    public String getLocalContent() {
        String string = this.myLocalContent;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ApplyPatchMergeRequest", "getLocalContent"));
        }
        return string;
    }

    @NotNull
    public String getPatchedContent() {
        String string = this.myPatchedContent;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ApplyPatchMergeRequest", "getPatchedContent"));
        }
        return string;
    }

    @Nullable
    public String getTitle() {
        return this.myWindowTitle;
    }

    @NotNull
    public String getLocalTitle() {
        String string = this.myLocalTitle;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ApplyPatchMergeRequest", "getLocalTitle"));
        }
        return string;
    }

    @NotNull
    public String getPatchedTitle() {
        String string = this.myPatchedTitle;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ApplyPatchMergeRequest", "getPatchedTitle"));
        }
        return string;
    }

    public void applyResult(@NotNull MergeResult result) {
        CharSequence applyContent;
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/vcs/changes/patch/ApplyPatchMergeRequest", "applyResult"));
        }
        switch (result) {
            case CANCEL: {
                applyContent = this.myOriginalContent;
                break;
            }
            case LEFT: {
                applyContent = this.myLocalContent;
                break;
            }
            case RIGHT: {
                applyContent = this.myPatchedContent;
                break;
            }
            case RESOLVED: {
                applyContent = null;
                break;
            }
            default: {
                throw new IllegalArgumentException(result.name());
            }
        }
        if (applyContent != null) {
            new WriteCommandAction.Simple(this.myProject, new PsiFile[0]){

                protected void run() throws Throwable {
                    ApplyPatchMergeRequest.this.myDocument.setText(applyContent);
                }
            }.execute();
        }
        if (this.myCallback != null) {
            this.myCallback.consume((Object)result);
        }
    }
}

