/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.UnknownFileTypeDiffRequest;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.impl.patch.PatchReader;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.SimpleContentRevision;
import com.intellij.openapi.vcs.changes.patch.AbstractFilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchForBaseRevisionTexts;
import com.intellij.openapi.vcs.changes.patch.FilePatchStatus;
import com.intellij.openapi.vcs.changes.patch.LazyPatchContentRevision;
import com.intellij.openapi.vcs.changes.patch.PatchDiffRequestFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class TextFilePatchInProgress
extends AbstractFilePatchInProgress<TextFilePatch> {
    protected TextFilePatchInProgress(TextFilePatch patch, Collection<VirtualFile> autoBases, VirtualFile baseDir) {
        super(patch.pathsOnlyCopy(), autoBases, baseDir);
    }

    @Override
    public ContentRevision getNewContentRevision() {
        if (FilePatchStatus.DELETED.equals((Object)this.myStatus)) {
            return null;
        }
        if (this.myNewContentRevision == null) {
            this.myConflicts = null;
            if (FilePatchStatus.ADDED.equals((Object)this.myStatus)) {
                FilePath newFilePath = VcsUtil.getFilePath((File)this.myIoCurrentBase, (boolean)false);
                String content = ((TextFilePatch)this.myPatch).getNewFileText();
                this.myNewContentRevision = new SimpleContentRevision(content, newFilePath, ((TextFilePatch)this.myPatch).getAfterVersionId());
            } else {
                FilePath newFilePath = this.detectNewFilePathForMovedOrModified();
                this.myNewContentRevision = new LazyPatchContentRevision(this.myCurrentBase, newFilePath, ((TextFilePatch)this.myPatch).getAfterVersionId(), (TextFilePatch)this.myPatch);
                if (this.myCurrentBase != null) {
                    ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                        @Override
                        public void run() {
                            ((LazyPatchContentRevision)TextFilePatchInProgress.this.myNewContentRevision).getContent();
                        }
                    });
                }
            }
        }
        return this.myNewContentRevision;
    }

    @Override
    @NotNull
    public DiffRequestProducer getDiffRequestProducers(final Project project, final PatchReader patchReader) {
        AbstractFilePatchInProgress.PatchChange change = this.getChange();
        Object patch = this.getPatch();
        final String path = patch.getBeforeName() == null ? patch.getAfterName() : patch.getBeforeName();
        Getter<CharSequence> baseContentGetter = new Getter<CharSequence>(){

            public CharSequence get() {
                return patchReader.getBaseRevision(project, path);
            }
        };
        DiffRequestProducer diffRequestProducer = new DiffRequestProducer((Getter)baseContentGetter, change){
            final /* synthetic */ Getter val$baseContentGetter;
            final /* synthetic */ AbstractFilePatchInProgress.PatchChange val$change;
            {
                this.val$baseContentGetter = getter;
                this.val$change = patchChange;
            }

            @NotNull
            public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/patch/TextFilePatchInProgress$3", "process"));
                }
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/patch/TextFilePatchInProgress$3", "process"));
                }
                if (TextFilePatchInProgress.this.myCurrentBase != null && TextFilePatchInProgress.this.myCurrentBase.getFileType() == UnknownFileType.INSTANCE) {
                    UnknownFileTypeDiffRequest unknownFileTypeDiffRequest = new UnknownFileTypeDiffRequest(TextFilePatchInProgress.this.myCurrentBase, this.getName());
                    if (unknownFileTypeDiffRequest == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/TextFilePatchInProgress$3", "process"));
                    }
                    return unknownFileTypeDiffRequest;
                }
                if (TextFilePatchInProgress.this.isConflictingChange()) {
                    final VirtualFile file = TextFilePatchInProgress.this.getCurrentBase();
                    Getter<ApplyPatchForBaseRevisionTexts> getter = new Getter<ApplyPatchForBaseRevisionTexts>(){

                        public ApplyPatchForBaseRevisionTexts get() {
                            return ApplyPatchForBaseRevisionTexts.create(project, file, VcsUtil.getFilePath((VirtualFile)file), (TextFilePatch)TextFilePatchInProgress.this.getPatch(), (Getter<CharSequence>)val$baseContentGetter);
                        }
                    };
                    String afterTitle = ((TextFilePatch)TextFilePatchInProgress.this.getPatch()).getAfterVersionId();
                    if (afterTitle == null) {
                        afterTitle = "Patched Version";
                    }
                    DiffRequest diffRequest = PatchDiffRequestFactory.createConflictDiffRequest(project, file, afterTitle, getter, this.getName(), context, indicator);
                    if (diffRequest == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/TextFilePatchInProgress$3", "process"));
                    }
                    return diffRequest;
                }
                DiffRequest diffRequest = PatchDiffRequestFactory.createDiffRequest(project, this.val$change, this.getName(), context, indicator);
                if (diffRequest == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/TextFilePatchInProgress$3", "process"));
                }
                return diffRequest;
            }

            @NotNull
            public String getName() {
                File ioCurrentBase = TextFilePatchInProgress.this.getIoCurrentBase();
                String string = ioCurrentBase == null ? TextFilePatchInProgress.this.getCurrentPath() : ioCurrentBase.getPath();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/TextFilePatchInProgress$3", "getName"));
                }
                return string;
            }
        };
        if (diffRequestProducer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/TextFilePatchInProgress", "getDiffRequestProducers"));
        }
        return diffRequestProducer;
    }
}

