/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CurrentBinaryContentRevision;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShelvedBinaryFile
implements JDOMExternalizable {
    public String BEFORE_PATH;
    public String AFTER_PATH;
    @Nullable
    public String SHELVED_PATH;

    public ShelvedBinaryFile() {
    }

    public ShelvedBinaryFile(String beforePath, String afterPath, @Nullable String shelvedPath) {
        assert (beforePath != null || afterPath != null);
        this.BEFORE_PATH = ShelvedBinaryFile.convertToSystemIndependent(beforePath);
        this.AFTER_PATH = ShelvedBinaryFile.convertToSystemIndependent(afterPath);
        this.SHELVED_PATH = ShelvedBinaryFile.convertToSystemIndependent(shelvedPath);
    }

    @Nullable
    private static String convertToSystemIndependent(@Nullable String beforePath) {
        return beforePath != null ? FileUtil.toSystemIndependentName((String)beforePath) : null;
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
    }

    public FileStatus getFileStatus() {
        if (this.BEFORE_PATH == null) {
            return FileStatus.ADDED;
        }
        if (this.SHELVED_PATH == null) {
            return FileStatus.DELETED;
        }
        return FileStatus.MODIFIED;
    }

    public Change createChange(Project project) {
        FilePath file;
        CurrentBinaryContentRevision before = null;
        ShelvedBinaryContentRevision after = null;
        File baseDir = new File(project.getBaseDir().getPath());
        if (this.BEFORE_PATH != null) {
            file = VcsUtil.getFilePath((File)new File(baseDir, this.BEFORE_PATH), (boolean)false);
            before = new CurrentBinaryContentRevision(file){

                @NotNull
                public VcsRevisionNumber getRevisionNumber() {
                    TextRevisionNumber textRevisionNumber = new TextRevisionNumber(VcsBundle.message((String)"local.version.title", (Object[])new Object[0]));
                    if (textRevisionNumber == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelvedBinaryFile$1", "getRevisionNumber"));
                    }
                    return textRevisionNumber;
                }
            };
        }
        if (this.AFTER_PATH != null) {
            file = VcsUtil.getFilePath((File)new File(baseDir, this.AFTER_PATH), (boolean)false);
            after = new ShelvedBinaryContentRevision(file, this.SHELVED_PATH);
        }
        return new Change(before, after);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShelvedBinaryFile that = (ShelvedBinaryFile)o;
        if (this.AFTER_PATH != null ? !this.AFTER_PATH.equals(that.AFTER_PATH) : that.AFTER_PATH != null) {
            return false;
        }
        if (this.BEFORE_PATH != null ? !this.BEFORE_PATH.equals(that.BEFORE_PATH) : that.BEFORE_PATH != null) {
            return false;
        }
        return !(this.SHELVED_PATH != null ? !this.SHELVED_PATH.equals(that.SHELVED_PATH) : that.SHELVED_PATH != null);
    }

    public int hashCode() {
        int result = this.BEFORE_PATH != null ? this.BEFORE_PATH.hashCode() : 0;
        result = 31 * result + (this.AFTER_PATH != null ? this.AFTER_PATH.hashCode() : 0);
        result = 31 * result + (this.SHELVED_PATH != null ? this.SHELVED_PATH.hashCode() : 0);
        return result;
    }
}

