/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListEditHandler;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeListImpl;
import com.intellij.openapi.vcs.changes.ui.ChangeListChooserPanel;
import com.intellij.util.NullableConsumer;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeListChooser
extends DialogWrapper {
    private final Project myProject;
    private LocalChangeList mySelectedList;
    private final ChangeListChooserPanel myPanel;

    public ChangeListChooser(@NotNull Project project, @NotNull Collection<? extends ChangeList> changelists, @Nullable ChangeList defaultSelection, String title, @Nullable String defaultName) {
        ChangeList changelist;
        ChangeListEditHandler handler;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/ChangeListChooser", "<init>"));
        }
        if (changelists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changelists", "com/intellij/openapi/vcs/changes/ui/ChangeListChooser", "<init>"));
        }
        super(project, false);
        this.myProject = project;
        Iterator<? extends ChangeList> iterator = changelists.iterator();
        while (iterator.hasNext() && (handler = ((LocalChangeListImpl)(changelist = iterator.next())).getEditHandler()) == null) {
        }
        this.myPanel = new ChangeListChooserPanel(this.myProject, new NullableConsumer<String>(){

            public void consume(@Nullable String errorMessage) {
                ChangeListChooser.this.setOKActionEnabled(errorMessage == null);
                ChangeListChooser.this.setErrorText(errorMessage);
            }
        });
        this.myPanel.init();
        this.myPanel.setChangeLists(changelists);
        this.myPanel.setDefaultSelection((ChangeList)(changelists.size() <= 1 && this.onlyOneListInProject() ? null : defaultSelection));
        this.setTitle(title);
        if (defaultName != null) {
            this.myPanel.setDefaultName(defaultName);
        }
        this.init();
    }

    private boolean onlyOneListInProject() {
        return ChangeListManager.getInstance((Project)this.myProject).getChangeListsNumber() <= 1;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPanel.getPreferredFocusedComponent();
    }

    protected String getDimensionServiceKey() {
        return "VCS.ChangelistChooser";
    }

    protected void doOKAction() {
        this.mySelectedList = this.myPanel.getSelectedList(this.myProject);
        if (this.mySelectedList != null) {
            super.doOKAction();
        }
    }

    public LocalChangeList getSelectedList() {
        return this.mySelectedList;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }
}

