/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.SeverityUtil;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ModifiableModel;
import com.intellij.codeInspection.ex.AppInspectionProfilesVisibleTreeState;
import com.intellij.codeInspection.ex.Descriptor;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ProjectInspectionProfilesVisibleTreeState;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.VisibleTreeState;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.ApplicationProfileManager;
import com.intellij.profile.DefaultProjectProfileManager;
import com.intellij.profile.Profile;
import com.intellij.profile.ProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.SeverityProvider;
import com.intellij.profile.codeInspection.ui.AdvancedSettingsAction;
import com.intellij.profile.codeInspection.ui.InspectionsAggregationUtil;
import com.intellij.profile.codeInspection.ui.LevelChooserAction;
import com.intellij.profile.codeInspection.ui.ScopesChooser;
import com.intellij.profile.codeInspection.ui.ToolDescriptors;
import com.intellij.profile.codeInspection.ui.filter.InspectionFilterAction;
import com.intellij.profile.codeInspection.ui.filter.InspectionsFilter;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionConfigTreeNode;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionsConfigTreeComparator;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionsConfigTreeRenderer;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionsConfigTreeTable;
import com.intellij.profile.codeInspection.ui.table.ScopesAndSeveritiesTable;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.FilterComponent;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.HintHint;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.UserActivityListener;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.Queue;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleInspectionProfilePanel
extends JPanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ex.InspectionToolsPanel");
    @NonNls
    private static final String INSPECTION_FILTER_HISTORY = "INSPECTION_FILTER_HISTORY";
    private static final String UNDER_CONSTRUCTION = InspectionsBundle.message((String)"inspection.tool.description.under.construction.text", (Object[])new Object[0]);
    @NonNls
    private static final String EMPTY_HTML = "<html><body></body></html>";
    private static final float DIVIDER_PROPORTION_DEFAULT = 0.5f;
    private final List<ToolDescriptors> myInitialToolDescriptors;
    private final InspectionConfigTreeNode myRoot;
    private final Alarm myAlarm;
    private final InspectionProjectProfileManager myProjectProfileManager;
    @NotNull
    private Profile myOriginal;
    private InspectionProfileImpl mySelectedProfile;
    private JEditorPane myBrowser;
    private JPanel myOptionsPanel;
    private JPanel myInspectionProfilePanel;
    private FilterComponent myProfileFilter;
    private final InspectionsFilter myInspectionsFilter;
    private boolean myModified;
    private InspectionsConfigTreeTable myTreeTable;
    private TreeExpander myTreeExpander;
    @NotNull
    private String myCurrentProfileName;
    private boolean myIsInRestore;
    private boolean myIsProjectLevel;
    private JBSplitter myRightSplitter;
    private JBSplitter myMainSplitter;
    private String[] myInitialScopesOrder;
    private Disposable myDisposable;

    public SingleInspectionProfilePanel(@NotNull InspectionProjectProfileManager projectProfileManager, @NotNull String inspectionProfileName, @NotNull ModifiableModel profile, @NotNull Profile original) {
        if (projectProfileManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectProfileManager", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel", "<init>"));
        }
        if (inspectionProfileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionProfileName", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel", "<init>"));
        }
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel", "<init>"));
        }
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel", "<init>"));
        }
        super(new BorderLayout());
        this.myInitialToolDescriptors = new ArrayList<ToolDescriptors>();
        this.myRoot = new InspectionConfigTreeNode(InspectionsBundle.message((String)"inspection.root.node.title", (Object[])new Object[0]));
        this.myAlarm = new Alarm();
        this.myInspectionProfilePanel = null;
        this.myInspectionsFilter = new InspectionsFilter(){

            @Override
            protected void filterChanged() {
                SingleInspectionProfilePanel.this.filterTree(SingleInspectionProfilePanel.this.myProfileFilter.getFilter());
            }
        };
        this.myModified = false;
        this.myIsInRestore = false;
        this.myDisposable = new Disposable(){

            public void dispose() {
            }
        };
        this.myProjectProfileManager = projectProfileManager;
        this.myOriginal = original;
        this.mySelectedProfile = (InspectionProfileImpl)profile;
        this.myCurrentProfileName = inspectionProfileName;
        this.myIsProjectLevel = profile.getProfileManager() == projectProfileManager;
    }

    private static VisibleTreeState getExpandedNodes(InspectionProfileImpl profile) {
        if (profile.getProfileManager() instanceof ApplicationProfileManager) {
            return AppInspectionProfilesVisibleTreeState.getInstance().getVisibleTreeState(profile);
        }
        DefaultProjectProfileManager projectProfileManager = (DefaultProjectProfileManager)profile.getProfileManager();
        return ProjectInspectionProfilesVisibleTreeState.getInstance(projectProfileManager.getProject()).getVisibleTreeState(profile);
    }

    @Nullable
    private static InspectionConfigTreeNode findNodeByKey(String name, InspectionConfigTreeNode root) {
        for (int i = 0; i < root.getChildCount(); ++i) {
            InspectionConfigTreeNode child = (InspectionConfigTreeNode)root.getChildAt(i);
            Descriptor descriptor = child.getDefaultDescriptor();
            if (descriptor != null) {
                if (!descriptor.getKey().toString().equals(name)) continue;
                return child;
            }
            InspectionConfigTreeNode node = SingleInspectionProfilePanel.findNodeByKey(name, child);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public static String renderSeverity(HighlightSeverity severity) {
        return StringUtil.capitalizeWords((String)severity.getName().toLowerCase(), (boolean)true);
    }

    private static void updateUpHierarchy(InspectionConfigTreeNode parent) {
        if (parent != null) {
            parent.dropCache();
            SingleInspectionProfilePanel.updateUpHierarchy((InspectionConfigTreeNode)parent.getParent());
        }
    }

    private static boolean isDescriptorAccepted(Descriptor descriptor, @NonNls String filter, boolean forceInclude, List<Set<String>> keySetList, Set<String> quoted) {
        filter = filter.toLowerCase();
        if (StringUtil.containsIgnoreCase((String)descriptor.getText(), (String)filter)) {
            return true;
        }
        String[] groupPath = descriptor.getGroup();
        for (String group : groupPath) {
            if (!StringUtil.containsIgnoreCase((String)group, (String)filter)) continue;
            return true;
        }
        for (String string : quoted) {
            if (StringUtil.containsIgnoreCase((String)descriptor.getText(), (String)string)) {
                return true;
            }
            for (String group : groupPath) {
                if (!StringUtil.containsIgnoreCase((String)group, (String)string)) continue;
                return true;
            }
            String description = descriptor.getToolWrapper().loadDescription();
            if (description != null && StringUtil.containsIgnoreCase((String)description.toLowerCase(), (String)string)) {
                if (forceInclude) continue;
                return true;
            }
            if (!forceInclude) continue;
            return false;
        }
        for (Set set : keySetList) {
            if (set.contains(descriptor.getKey().toString())) {
                if (forceInclude) continue;
                return true;
            }
            if (!forceInclude) continue;
            return false;
        }
        return forceInclude;
    }

    private static void setConfigPanel(JPanel configPanelAnchor, ScopeToolState state) {
        configPanelAnchor.removeAll();
        JComponent additionalConfigPanel = state.getAdditionalConfigPanel();
        if (additionalConfigPanel != null) {
            if (UIUtil.hasScrollPane((Component)additionalConfigPanel)) {
                configPanelAnchor.add(additionalConfigPanel);
            } else {
                final JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)additionalConfigPanel, (int)0);
                FocusManager.getCurrentManager().addPropertyChangeListener("focusOwner", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (!(evt.getNewValue() instanceof JComponent)) {
                            return;
                        }
                        JComponent component = (JComponent)evt.getNewValue();
                        if (component.isAncestorOf(pane)) {
                            pane.scrollRectToVisible(component.getBounds());
                        }
                    }
                });
                configPanelAnchor.add(pane);
            }
        }
        UIUtil.setEnabled((Component)configPanelAnchor, (boolean)state.isEnabled(), (boolean)true);
    }

    private static InspectionConfigTreeNode getGroupNode(InspectionConfigTreeNode root, String[] groupPath) {
        InspectionConfigTreeNode currentRoot = root;
        for (String group : groupPath) {
            currentRoot = SingleInspectionProfilePanel.getGroupNode(currentRoot, group);
        }
        return currentRoot;
    }

    private static InspectionConfigTreeNode getGroupNode(InspectionConfigTreeNode root, String group) {
        int childCount = root.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            InspectionConfigTreeNode child = (InspectionConfigTreeNode)root.getChildAt(i);
            if (!group.equals(child.getUserObject())) continue;
            return child;
        }
        InspectionConfigTreeNode child = new InspectionConfigTreeNode(group);
        root.add(child);
        return child;
    }

    private static void copyUsedSeveritiesIfUndefined(ModifiableModel selectedProfile, ProfileManager profileManager) {
        SeverityRegistrar registrar = ((SeverityProvider)profileManager).getSeverityRegistrar();
        Set<HighlightSeverity> severities = ((InspectionProfileImpl)selectedProfile).getUsedSeverities();
        Iterator<HighlightSeverity> iterator = severities.iterator();
        while (iterator.hasNext()) {
            HighlightSeverity severity = iterator.next();
            if (!registrar.isSeverityValid(severity.getName())) continue;
            iterator.remove();
        }
        if (!severities.isEmpty()) {
            SeverityRegistrar oppositeRegister = ((SeverityProvider)selectedProfile.getProfileManager()).getSeverityRegistrar();
            for (HighlightSeverity severity : severities) {
                TextAttributesKey attributesKey = TextAttributesKey.find((String)severity.getName());
                TextAttributes textAttributes = oppositeRegister.getTextAttributesBySeverity(severity);
                if (textAttributes == null) continue;
                HighlightInfoType.HighlightInfoTypeImpl info = new HighlightInfoType.HighlightInfoTypeImpl(severity, attributesKey);
                registrar.registerSeverity(new SeverityRegistrar.SeverityBasedTextAttributes(textAttributes.clone(), info), textAttributes.getErrorStripeColor());
            }
        }
    }

    private void initUI() {
        this.myInspectionProfilePanel = this.createInspectionProfileSettingsPanel();
        this.add((Component)this.myInspectionProfilePanel, "Center");
        UserActivityWatcher userActivityWatcher = new UserActivityWatcher();
        userActivityWatcher.addUserActivityListener(new UserActivityListener(){

            public void stateChanged() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (SingleInspectionProfilePanel.this.mySelectedProfile == null) {
                            return;
                        }
                        SingleInspectionProfilePanel.this.updateProperSettingsForSelection();
                        SingleInspectionProfilePanel.this.wereToolSettingsModified();
                    }
                });
            }
        });
        userActivityWatcher.register((Component)this.myOptionsPanel);
        this.updateSelectedProfileState();
        this.reset();
    }

    private void updateSelectedProfileState() {
        if (this.mySelectedProfile == null) {
            return;
        }
        this.restoreTreeState();
        this.repaintTableData();
        this.updateSelection();
    }

    public void updateSelection() {
        TreePath selectionPath;
        if (this.myTreeTable != null && (selectionPath = this.myTreeTable.getTree().getSelectionPath()) != null) {
            TreeUtil.selectNode((JTree)this.myTreeTable.getTree(), (TreeNode)((TreeNode)selectionPath.getLastPathComponent()));
            int rowForPath = this.myTreeTable.getTree().getRowForPath(selectionPath);
            TableUtil.selectRows((JTable)((Object)this.myTreeTable), (int[])new int[]{rowForPath});
            this.scrollToCenter();
        }
    }

    private void loadDescriptorsConfigs(boolean onlyModified) {
        for (ToolDescriptors toolDescriptors : this.myInitialToolDescriptors) {
            this.loadDescriptorConfig(toolDescriptors.getDefaultDescriptor(), onlyModified);
            for (Descriptor descriptor : toolDescriptors.getNonDefaultDescriptors()) {
                this.loadDescriptorConfig(descriptor, onlyModified);
            }
        }
    }

    private void loadDescriptorConfig(Descriptor descriptor, boolean ifModifier) {
        if (!ifModifier || this.mySelectedProfile.isProperSetting(descriptor.getKey().toString())) {
            descriptor.loadConfig();
        }
    }

    private void wereToolSettingsModified() {
        for (ToolDescriptors toolDescriptor : this.myInitialToolDescriptors) {
            Descriptor desc = toolDescriptor.getDefaultDescriptor();
            if (this.wereToolSettingsModified(desc, true)) {
                return;
            }
            List<Descriptor> descriptors = toolDescriptor.getNonDefaultDescriptors();
            for (Descriptor descriptor : descriptors) {
                if (!this.wereToolSettingsModified(descriptor, false)) continue;
                return;
            }
        }
        this.myModified = false;
    }

    private boolean wereToolSettingsModified(Descriptor descriptor, boolean isDefault) {
        if (!this.mySelectedProfile.isToolEnabled(descriptor.getKey(), descriptor.getScope(), this.myProjectProfileManager.getProject())) {
            return false;
        }
        Element oldConfig = descriptor.getConfig();
        if (oldConfig == null) {
            return false;
        }
        ScopeToolState state = null;
        if (isDefault) {
            state = this.mySelectedProfile.getToolDefaultState(descriptor.getKey().toString(), this.myProjectProfileManager.getProject());
        } else {
            for (ScopeToolState candidate : this.mySelectedProfile.getNonDefaultTools(descriptor.getKey().toString(), this.myProjectProfileManager.getProject())) {
                String scope = descriptor.getScopeName();
                if (!Comparing.equal((String)candidate.getScopeName(), (String)scope)) continue;
                state = candidate;
                break;
            }
        }
        if (state == null) {
            return true;
        }
        Element newConfig = Descriptor.createConfigElement(state.getTool());
        if (!JDOMUtil.areElementsEqual((Element)oldConfig, (Element)newConfig)) {
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    SingleInspectionProfilePanel.this.myTreeTable.repaint();
                }
            }, 300);
            this.myModified = true;
            return true;
        }
        return false;
    }

    private void updateProperSettingsForSelection() {
        InspectionConfigTreeNode node;
        Descriptor descriptor;
        TreePath selectionPath = this.myTreeTable.getTree().getSelectionPath();
        if (selectionPath != null && (descriptor = (node = (InspectionConfigTreeNode)selectionPath.getLastPathComponent()).getDefaultDescriptor()) != null) {
            boolean properSetting = this.mySelectedProfile.isProperSetting(descriptor.getKey().toString());
            if (node.isProperSetting() != properSetting) {
                this.myAlarm.cancelAllRequests();
                this.myAlarm.addRequest(new Runnable(){

                    @Override
                    public void run() {
                        SingleInspectionProfilePanel.this.myTreeTable.repaint();
                    }
                }, 300);
                node.dropCache();
                SingleInspectionProfilePanel.updateUpHierarchy((InspectionConfigTreeNode)node.getParent());
            }
        }
    }

    private void initToolStates() {
        InspectionProfileImpl profile = this.mySelectedProfile;
        if (profile == null) {
            return;
        }
        this.myInitialToolDescriptors.clear();
        Project project = this.myProjectProfileManager.getProject();
        for (ScopeToolState state : profile.getDefaultStates(this.myProjectProfileManager.getProject())) {
            if (!this.accept(state.getTool())) continue;
            this.myInitialToolDescriptors.add(ToolDescriptors.fromScopeToolState(state, profile, project));
        }
        this.myInitialScopesOrder = this.mySelectedProfile.getScopesOrder();
    }

    protected boolean accept(InspectionToolWrapper entry) {
        return entry.getDefaultLevel() != HighlightDisplayLevel.NON_SWITCHABLE_ERROR;
    }

    private void postProcessModification() {
        this.wereToolSettingsModified();
        for (ScopeToolState state : this.mySelectedProfile.getAllTools(this.myProjectProfileManager.getProject())) {
            state.resetConfigPanel();
        }
        this.fillTreeData(this.myProfileFilter.getFilter(), true);
        this.repaintTableData();
        this.updateOptionsAndDescriptionPanel(this.myTreeTable.getTree().getSelectionPaths());
    }

    public void setFilter(String filter) {
        this.myProfileFilter.setFilter(filter);
    }

    private void filterTree(@Nullable String filter) {
        if (this.myTreeTable != null) {
            SingleInspectionProfilePanel.getExpandedNodes(this.mySelectedProfile).saveVisibleState((Tree)this.myTreeTable.getTree());
            this.fillTreeData(filter, true);
            this.reloadModel();
            this.restoreTreeState();
            if (this.myTreeTable.getTree().getSelectionPath() == null) {
                TreeUtil.selectFirstNode((JTree)this.myTreeTable.getTree());
            }
        }
    }

    private void filterTree() {
        this.filterTree(this.myProfileFilter != null ? this.myProfileFilter.getFilter() : null);
    }

    private void reloadModel() {
        try {
            this.myIsInRestore = true;
            ((DefaultTreeModel)this.myTreeTable.getTree().getModel()).reload();
        }
        finally {
            this.myIsInRestore = false;
        }
    }

    private void restoreTreeState() {
        try {
            this.myIsInRestore = true;
            SingleInspectionProfilePanel.getExpandedNodes(this.mySelectedProfile).restoreVisibleState((Tree)this.myTreeTable.getTree());
        }
        finally {
            this.myIsInRestore = false;
        }
    }

    private ActionToolbar createTreeToolbarPanel() {
        CommonActionsManager actionManager = CommonActionsManager.getInstance();
        DefaultActionGroup actions2 = new DefaultActionGroup();
        actions2.add((AnAction)new InspectionFilterAction(this.mySelectedProfile, this.myInspectionsFilter, this.myProjectProfileManager.getProject()));
        actions2.addSeparator();
        actions2.add(actionManager.createExpandAllAction(this.myTreeExpander, (JComponent)((Object)this.myTreeTable)));
        actions2.add(actionManager.createCollapseAllAction(this.myTreeExpander, (JComponent)((Object)this.myTreeTable)));
        actions2.add((AnAction)new DumbAwareAction("Reset to Empty", "Reset to empty", AllIcons.Actions.Reset_to_empty){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel$7", "update"));
                }
                e.getPresentation().setEnabled(SingleInspectionProfilePanel.this.mySelectedProfile != null && SingleInspectionProfilePanel.this.mySelectedProfile.isExecutable(SingleInspectionProfilePanel.this.myProjectProfileManager.getProject()));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel$7", "actionPerformed"));
                }
                SingleInspectionProfilePanel.this.mySelectedProfile.resetToEmpty(e.getProject());
                SingleInspectionProfilePanel.this.loadDescriptorsConfigs(false);
                SingleInspectionProfilePanel.this.postProcessModification();
            }
        });
        actions2.add((AnAction)new AdvancedSettingsAction(this.myProjectProfileManager.getProject(), this.myRoot){

            @Override
            protected InspectionProfileImpl getInspectionProfile() {
                return SingleInspectionProfilePanel.this.mySelectedProfile;
            }

            @Override
            protected void postProcessModification() {
                SingleInspectionProfilePanel.this.loadDescriptorsConfigs(true);
                SingleInspectionProfilePanel.this.postProcessModification();
            }
        });
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)actions2, true);
        actionToolbar.setTargetComponent((JComponent)this);
        return actionToolbar;
    }

    private void repaintTableData() {
        if (this.myTreeTable != null) {
            SingleInspectionProfilePanel.getExpandedNodes(this.mySelectedProfile).saveVisibleState((Tree)this.myTreeTable.getTree());
            this.reloadModel();
            this.restoreTreeState();
        }
    }

    public void selectInspectionTool(String name) {
        InspectionConfigTreeNode node = SingleInspectionProfilePanel.findNodeByKey(name, this.myRoot);
        if (node != null) {
            TreeUtil.selectNode((JTree)this.myTreeTable.getTree(), (TreeNode)node);
            int rowForPath = this.myTreeTable.getTree().getRowForPath(new TreePath(node.getPath()));
            TableUtil.selectRows((JTable)((Object)this.myTreeTable), (int[])new int[]{rowForPath});
            this.scrollToCenter();
        }
    }

    private void scrollToCenter() {
        ListSelectionModel selectionModel = this.myTreeTable.getSelectionModel();
        int maxSelectionIndex = selectionModel.getMaxSelectionIndex();
        int maxColumnSelectionIndex = Math.max(0, this.myTreeTable.getColumnModel().getSelectionModel().getMinSelectionIndex());
        Rectangle maxCellRect = this.myTreeTable.getCellRect(maxSelectionIndex, maxColumnSelectionIndex, false);
        Point selectPoint = maxCellRect.getLocation();
        int allHeight = this.myTreeTable.getVisibleRect().height;
        this.myTreeTable.scrollRectToVisible(new Rectangle(new Point(0, Math.max(0, selectPoint.y - allHeight / 2)), new Dimension(0, allHeight)));
    }

    private JScrollPane initTreeScrollPane() {
        this.fillTreeData(null, true);
        InspectionsConfigTreeRenderer renderer = new InspectionsConfigTreeRenderer(){

            @Override
            protected String getFilter() {
                return SingleInspectionProfilePanel.this.myProfileFilter != null ? SingleInspectionProfilePanel.this.myProfileFilter.getFilter() : null;
            }
        };
        this.myTreeTable = InspectionsConfigTreeTable.create(new InspectionsConfigTreeTable.InspectionsConfigTreeTableSettings(this.myRoot, this.myProjectProfileManager.getProject()){

            @Override
            protected void onChanged(InspectionConfigTreeNode node) {
                SingleInspectionProfilePanel.updateUpHierarchy((InspectionConfigTreeNode)node.getParent());
            }

            @Override
            public void updateRightPanel() {
                SingleInspectionProfilePanel.this.updateOptionsAndDescriptionPanel();
            }

            @Override
            public InspectionProfileImpl getInspectionProfile() {
                return SingleInspectionProfilePanel.this.mySelectedProfile;
            }
        }, this.myDisposable);
        this.myTreeTable.setTreeCellRenderer((TreeCellRenderer)((Object)renderer));
        this.myTreeTable.setRootVisible(false);
        UIUtil.setLineStyleAngled((JTree)this.myTreeTable.getTree());
        TreeUtil.installActions((JTree)this.myTreeTable.getTree());
        this.myTreeTable.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                InspectionProfileImpl selected;
                if (SingleInspectionProfilePanel.this.myTreeTable.getTree().getSelectionPaths() != null) {
                    SingleInspectionProfilePanel.this.updateOptionsAndDescriptionPanel(SingleInspectionProfilePanel.this.myTreeTable.getTree().getSelectionPaths());
                } else {
                    SingleInspectionProfilePanel.this.initOptionsAndDescriptionPanel();
                }
                if (!SingleInspectionProfilePanel.this.myIsInRestore && (selected = SingleInspectionProfilePanel.this.mySelectedProfile) != null) {
                    InspectionProfileImpl baseProfile = (InspectionProfileImpl)selected.getParentProfile();
                    if (baseProfile != null) {
                        SingleInspectionProfilePanel.getExpandedNodes(baseProfile).setSelectionPaths(SingleInspectionProfilePanel.this.myTreeTable.getTree().getSelectionPaths());
                    }
                    SingleInspectionProfilePanel.getExpandedNodes(selected).setSelectionPaths(SingleInspectionProfilePanel.this.myTreeTable.getTree().getSelectionPaths());
                }
            }
        });
        this.myTreeTable.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                int[] selectionRows = SingleInspectionProfilePanel.this.myTreeTable.getTree().getSelectionRows();
                if (selectionRows != null && SingleInspectionProfilePanel.this.myTreeTable.getTree().getPathForLocation(x, y) != null && Arrays.binarySearch(selectionRows, SingleInspectionProfilePanel.this.myTreeTable.getTree().getRowForLocation(x, y)) > -1) {
                    SingleInspectionProfilePanel.this.compoundPopup().show(comp, x, y);
                }
            }
        });
        new TreeSpeedSearch((Tree)this.myTreeTable.getTree(), new Convertor<TreePath, String>(){

            public String convert(TreePath o) {
                InspectionConfigTreeNode node = (InspectionConfigTreeNode)o.getLastPathComponent();
                Descriptor descriptor = node.getDefaultDescriptor();
                return descriptor != null ? InspectionsConfigTreeComparator.getDisplayTextToSort(descriptor.getText()) : InspectionsConfigTreeComparator.getDisplayTextToSort(node.getGroupName());
            }
        });
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myTreeTable));
        this.myTreeTable.getTree().setShowsRootHandles(true);
        scrollPane.setHorizontalScrollBarPolicy(30);
        TreeUtil.collapseAll((JTree)this.myTreeTable.getTree(), (int)1);
        this.myTreeTable.getTree().addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                InspectionProfileImpl selected = SingleInspectionProfilePanel.this.mySelectedProfile;
                InspectionProfileImpl parentProfile = (InspectionProfileImpl)selected.getParentProfile();
                if (parentProfile != null) {
                    SingleInspectionProfilePanel.getExpandedNodes(parentProfile).saveVisibleState((Tree)SingleInspectionProfilePanel.this.myTreeTable.getTree());
                }
                SingleInspectionProfilePanel.getExpandedNodes(selected).saveVisibleState((Tree)SingleInspectionProfilePanel.this.myTreeTable.getTree());
            }

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                InspectionProfileImpl selected = SingleInspectionProfilePanel.this.mySelectedProfile;
                if (selected != null) {
                    InspectionConfigTreeNode node = (InspectionConfigTreeNode)event.getPath().getLastPathComponent();
                    InspectionProfileImpl parentProfile = (InspectionProfileImpl)selected.getParentProfile();
                    if (parentProfile != null) {
                        SingleInspectionProfilePanel.getExpandedNodes(parentProfile).expandNode(node);
                    }
                    SingleInspectionProfilePanel.getExpandedNodes(selected).expandNode(node);
                }
            }
        });
        this.myTreeExpander = new DefaultTreeExpander((JTree)this.myTreeTable.getTree()){

            public boolean canExpand() {
                return SingleInspectionProfilePanel.this.myTreeTable.isShowing();
            }

            public boolean canCollapse() {
                return SingleInspectionProfilePanel.this.myTreeTable.isShowing();
            }
        };
        this.myProfileFilter = new MyFilterComponent();
        return scrollPane;
    }

    private JPopupMenu compoundPopup() {
        DefaultActionGroup group = new DefaultActionGroup();
        SeverityRegistrar severityRegistrar = ((SeverityProvider)this.mySelectedProfile.getProfileManager()).getOwnSeverityRegistrar();
        TreeSet<HighlightSeverity> severities = new TreeSet<HighlightSeverity>(severityRegistrar);
        severities.add(HighlightSeverity.ERROR);
        severities.add(HighlightSeverity.WARNING);
        severities.add(HighlightSeverity.WEAK_WARNING);
        Collection<SeverityRegistrar.SeverityBasedTextAttributes> infoTypes = SeverityUtil.getRegisteredHighlightingInfoTypes(severityRegistrar);
        for (SeverityRegistrar.SeverityBasedTextAttributes info : infoTypes) {
            severities.add(info.getSeverity());
        }
        for (HighlightSeverity severity : severities) {
            final HighlightDisplayLevel level = HighlightDisplayLevel.find((HighlightSeverity)severity);
            group.add(new AnAction(SingleInspectionProfilePanel.renderSeverity(severity), SingleInspectionProfilePanel.renderSeverity(severity), level.getIcon()){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel$16", "actionPerformed"));
                    }
                    SingleInspectionProfilePanel.this.setNewHighlightingLevel(level);
                }

                public boolean isDumbAware() {
                    return true;
                }
            });
        }
        group.add((AnAction)Separator.getInstance());
        ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)group);
        return menu.getComponent();
    }

    private void fillTreeData(@Nullable String filter, boolean forceInclude) {
        Set filters;
        if (this.mySelectedProfile == null) {
            return;
        }
        this.myRoot.removeAllChildren();
        this.myRoot.dropCache();
        ArrayList<Set<String>> keySetList = new ArrayList<Set<String>>();
        HashSet<String> quoted = new HashSet<String>();
        if (filter != null && !filter.isEmpty()) {
            keySetList.addAll(SearchUtil.findKeys(filter, quoted));
        }
        Project project = this.myProjectProfileManager.getProject();
        boolean emptyFilter = this.myInspectionsFilter.isEmptyFilter();
        for (ToolDescriptors toolDescriptors : this.myInitialToolDescriptors) {
            Descriptor descriptor = toolDescriptors.getDefaultDescriptor();
            if (filter != null && !filter.isEmpty() && !SingleInspectionProfilePanel.isDescriptorAccepted(descriptor, filter, forceInclude, keySetList, quoted) || !emptyFilter && !this.myInspectionsFilter.matches(this.mySelectedProfile.getTools(toolDescriptors.getDefaultDescriptor().getKey().toString(), project))) continue;
            InspectionConfigTreeNode node = new InspectionConfigTreeNode(toolDescriptors);
            SingleInspectionProfilePanel.getGroupNode(this.myRoot, toolDescriptors.getDefaultDescriptor().getGroup()).add(node);
            this.myRoot.dropCache();
        }
        if (filter != null && forceInclude && this.myRoot.getChildCount() == 0 && ((filters = SearchableOptionsRegistrar.getInstance().getProcessedWords(filter)).size() > 1 || !quoted.isEmpty())) {
            this.fillTreeData(filter, false);
        }
        TreeUtil.sort((DefaultMutableTreeNode)this.myRoot, (Comparator)new InspectionsConfigTreeComparator());
    }

    private boolean readHTML(String text) {
        try {
            this.myBrowser.read(new StringReader(text), null);
            return true;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    private String toHTML(String text) {
        HintHint hintHint = new HintHint(this.myBrowser, new Point(0, 0));
        hintHint.setFont(UIUtil.getLabelFont());
        return HintUtil.prepareHintText(text, hintHint);
    }

    private void updateOptionsAndDescriptionPanel(TreePath ... paths) {
        if (this.mySelectedProfile == null || paths == null || paths.length == 0) {
            return;
        }
        TreePath path = paths[0];
        if (path == null) {
            return;
        }
        final List<InspectionConfigTreeNode> nodes = InspectionsAggregationUtil.getInspectionsNodes(paths);
        if (!nodes.isEmpty()) {
            double severityPanelWeightY;
            InspectionConfigTreeNode singleNode;
            InspectionConfigTreeNode inspectionConfigTreeNode = singleNode = paths.length == 1 && ((InspectionConfigTreeNode)paths[0].getLastPathComponent()).getDefaultDescriptor() != null ? (InspectionConfigTreeNode)ContainerUtil.getFirstItem(nodes) : null;
            if (singleNode != null) {
                if (singleNode.getDefaultDescriptor().loadDescription() != null) {
                    Descriptor defaultDescriptor = singleNode.getDefaultDescriptor();
                    String description = defaultDescriptor.loadDescription();
                    try {
                        if (!this.readHTML(SearchUtil.markup(this.toHTML(description), this.myProfileFilter.getFilter()))) {
                            this.readHTML(this.toHTML("<b>" + UNDER_CONSTRUCTION + "</b>"));
                        }
                    }
                    catch (Throwable t) {
                        LOG.error("Failed to load description for: " + defaultDescriptor.getToolWrapper().getTool().getClass() + "; description: " + description, t);
                    }
                } else {
                    this.readHTML(this.toHTML("Can't find inspection description."));
                }
            } else {
                this.readHTML(this.toHTML("Multiple inspections are selected. You can edit them as a single inspection."));
            }
            this.myOptionsPanel.removeAll();
            final Project project = this.myProjectProfileManager.getProject();
            JPanel severityPanel = new JPanel(new GridBagLayout());
            final JPanel configPanelAnchor = new JPanel(new GridLayout());
            THashSet scopesNames = new THashSet();
            for (InspectionConfigTreeNode node : nodes) {
                List<ScopeToolState> nonDefaultTools = this.mySelectedProfile.getNonDefaultTools(node.getDefaultDescriptor().getKey().toString(), project);
                for (ScopeToolState tool : nonDefaultTools) {
                    scopesNames.add(tool.getScopeName());
                }
            }
            if (scopesNames.isEmpty()) {
                LevelChooserAction severityLevelChooser = new LevelChooserAction(this.mySelectedProfile){

                    @Override
                    protected void onChosen(HighlightSeverity severity) {
                        HighlightDisplayLevel level = HighlightDisplayLevel.find((HighlightSeverity)severity);
                        for (InspectionConfigTreeNode node : nodes) {
                            HighlightDisplayKey key = node.getDefaultDescriptor().getKey();
                            NamedScope scope = node.getDefaultDescriptor().getScope();
                            boolean toUpdate = SingleInspectionProfilePanel.this.mySelectedProfile.getErrorLevel(key, scope, project) != level;
                            SingleInspectionProfilePanel.this.mySelectedProfile.setErrorLevel(key, level, null, project);
                            if (!toUpdate) continue;
                            node.dropCache();
                        }
                        SingleInspectionProfilePanel.this.myTreeTable.updateUI();
                    }
                };
                HighlightSeverity severity = ScopesAndSeveritiesTable.getSeverity(ContainerUtil.map(nodes, (Function)new Function<InspectionConfigTreeNode, ScopeToolState>(){

                    public ScopeToolState fun(InspectionConfigTreeNode node) {
                        return node.getDefaultDescriptor().getState();
                    }
                }));
                severityLevelChooser.setChosen(severity);
                ScopesChooser scopesChooser = new ScopesChooser(ContainerUtil.map(nodes, (Function)new Function<InspectionConfigTreeNode, Descriptor>(){

                    public Descriptor fun(InspectionConfigTreeNode node) {
                        return node.getDefaultDescriptor();
                    }
                }), this.mySelectedProfile, project, null){

                    @Override
                    protected void onScopesOrderChanged() {
                        SingleInspectionProfilePanel.this.myTreeTable.updateUI();
                        SingleInspectionProfilePanel.this.updateOptionsAndDescriptionPanel();
                    }

                    @Override
                    protected void onScopeAdded() {
                        SingleInspectionProfilePanel.this.myTreeTable.updateUI();
                        SingleInspectionProfilePanel.this.updateOptionsAndDescriptionPanel();
                    }
                };
                severityPanel.add((Component)new JLabel(InspectionsBundle.message((String)"inspection.severity", (Object[])new Object[0])), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(10, 0, 10, 0), 0, 0));
                JComponent severityLevelChooserComponent = severityLevelChooser.createCustomComponent(severityLevelChooser.getTemplatePresentation());
                severityPanel.add((Component)severityLevelChooserComponent, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 17, 1, new Insets(10, 0, 10, 0), 0, 0));
                JComponent scopesChooserComponent = scopesChooser.createCustomComponent(scopesChooser.getTemplatePresentation());
                severityPanel.add((Component)scopesChooserComponent, new GridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 17, 1, new Insets(10, 0, 10, 0), 0, 0));
                JLabel label = new JLabel("", 4);
                severityPanel.add((Component)label, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 13, 1, new Insets(2, 0, 2, 0), 0, 0));
                severityPanelWeightY = 0.0;
                if (singleNode != null) {
                    SingleInspectionProfilePanel.setConfigPanel(configPanelAnchor, this.mySelectedProfile.getToolDefaultState(singleNode.getDefaultDescriptor().getKey().toString(), project));
                }
            } else {
                if (singleNode != null) {
                    for (Descriptor descriptor : singleNode.getDescriptors().getNonDefaultDescriptors()) {
                        descriptor.loadConfig();
                    }
                }
                ScopesAndSeveritiesTable scopesAndScopesAndSeveritiesTable = new ScopesAndSeveritiesTable(new ScopesAndSeveritiesTable.TableSettings(nodes, this.mySelectedProfile, project){

                    @Override
                    protected void onScopeChosen(@NotNull ScopeToolState state) {
                        if (state == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel$21", "onScopeChosen"));
                        }
                        SingleInspectionProfilePanel.setConfigPanel(configPanelAnchor, state);
                        configPanelAnchor.revalidate();
                        configPanelAnchor.repaint();
                    }

                    @Override
                    protected void onSettingsChanged() {
                        this.update(false);
                    }

                    @Override
                    protected void onScopeAdded() {
                        this.update(true);
                    }

                    @Override
                    protected void onScopesOrderChanged() {
                        this.update(true);
                    }

                    @Override
                    protected void onScopeRemoved(int scopesCount) {
                        this.update(scopesCount == 1);
                    }

                    private void update(boolean updateOptionsAndDescriptionPanel) {
                        Queue q = new Queue(nodes.size());
                        for (InspectionConfigTreeNode node : nodes) {
                            q.addLast((Object)node);
                        }
                        while (!q.isEmpty()) {
                            InspectionConfigTreeNode inspectionConfigTreeNode = (InspectionConfigTreeNode)q.pullFirst();
                            inspectionConfigTreeNode.dropCache();
                            TreeNode parent = inspectionConfigTreeNode.getParent();
                            if (parent == null || parent.getParent() == null) continue;
                            q.addLast((Object)((InspectionConfigTreeNode)parent));
                        }
                        SingleInspectionProfilePanel.this.myTreeTable.updateUI();
                        if (updateOptionsAndDescriptionPanel) {
                            SingleInspectionProfilePanel.this.updateOptionsAndDescriptionPanel();
                        }
                    }
                });
                ToolbarDecorator wrappedTable = ToolbarDecorator.createDecorator((JTable)((Object)scopesAndScopesAndSeveritiesTable)).disableUpDownActions().setRemoveActionUpdater(new AnActionButtonUpdater((JTable)((Object)scopesAndScopesAndSeveritiesTable)){
                    final /* synthetic */ JTable val$scopesAndScopesAndSeveritiesTable;
                    {
                        this.val$scopesAndScopesAndSeveritiesTable = jTable;
                    }

                    public boolean isEnabled(AnActionEvent e) {
                        int selectedRow = this.val$scopesAndScopesAndSeveritiesTable.getSelectedRow();
                        int rowCount = this.val$scopesAndScopesAndSeveritiesTable.getRowCount();
                        return rowCount - 1 != selectedRow;
                    }
                });
                JPanel panel = wrappedTable.createPanel();
                panel.setMinimumSize(new Dimension(this.getMinimumSize().width, 3 * ((JTable)((Object)scopesAndScopesAndSeveritiesTable)).getRowHeight()));
                severityPanel.add((Component)new JBLabel("Severity by Scope"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 0, 2, 10), 0, 0));
                severityPanel.add((Component)panel, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
                severityPanelWeightY = 0.3;
            }
            this.myOptionsPanel.add((Component)severityPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, severityPanelWeightY, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            if (configPanelAnchor.getComponentCount() != 0) {
                configPanelAnchor.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Options", (boolean)false, (Insets)new Insets(7, 0, 0, 0)));
            }
            GuiUtils.enableChildren((Component)this.myOptionsPanel, (boolean)this.isThoughOneNodeEnabled(nodes), (JComponent[])new JComponent[0]);
            if (configPanelAnchor.getComponentCount() != 0 || scopesNames.isEmpty()) {
                this.myOptionsPanel.add((Component)configPanelAnchor, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
            this.myOptionsPanel.revalidate();
        } else {
            this.initOptionsAndDescriptionPanel();
        }
        this.myOptionsPanel.repaint();
    }

    private boolean isThoughOneNodeEnabled(List<InspectionConfigTreeNode> nodes) {
        Project project = this.myProjectProfileManager.getProject();
        for (InspectionConfigTreeNode node : nodes) {
            String toolId = node.getDefaultDescriptor().getKey().toString();
            if (!this.mySelectedProfile.getTools(toolId, project).isEnabled()) continue;
            return true;
        }
        return false;
    }

    private void updateOptionsAndDescriptionPanel() {
        TreePath[] paths = this.myTreeTable.getTree().getSelectionPaths();
        if (paths != null) {
            this.updateOptionsAndDescriptionPanel(paths);
        } else {
            this.initOptionsAndDescriptionPanel();
        }
    }

    private void initOptionsAndDescriptionPanel() {
        this.myOptionsPanel.removeAll();
        this.readHTML(EMPTY_HTML);
        this.myOptionsPanel.validate();
        this.myOptionsPanel.repaint();
    }

    private boolean setSelectedProfileModified(boolean modified) {
        this.mySelectedProfile.setModified(modified);
        return modified;
    }

    public ModifiableModel getSelectedProfile() {
        return this.mySelectedProfile;
    }

    private void setSelectedProfile(ModifiableModel modifiableModel) {
        if (this.mySelectedProfile == modifiableModel) {
            return;
        }
        this.mySelectedProfile = (InspectionProfileImpl)modifiableModel;
        if (this.mySelectedProfile != null) {
            this.myCurrentProfileName = this.mySelectedProfile.getName();
        }
        this.initToolStates();
        this.filterTree();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(700, 500);
    }

    public void disposeUI() {
        if (this.myInspectionProfilePanel == null) {
            return;
        }
        this.myAlarm.cancelAllRequests();
        this.myProfileFilter.dispose();
        if (this.mySelectedProfile != null) {
            for (ScopeToolState state : this.mySelectedProfile.getAllTools(this.myProjectProfileManager.getProject())) {
                state.resetConfigPanel();
            }
        }
        this.mySelectedProfile = null;
        Disposer.dispose((Disposable)this.myDisposable);
        this.myDisposable = null;
    }

    private JPanel createInspectionProfileSettingsPanel() {
        this.myBrowser = new JEditorPane("text/html", EMPTY_HTML);
        this.myBrowser.setEditable(false);
        this.myBrowser.setBorder(IdeBorderFactory.createEmptyBorder((int)5, (int)5, (int)5, (int)5));
        this.myBrowser.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        this.initToolStates();
        this.fillTreeData(this.myProfileFilter != null ? this.myProfileFilter.getFilter() : null, true);
        JPanel descriptionPanel = new JPanel(new BorderLayout());
        descriptionPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)InspectionsBundle.message((String)"inspection.description.title", (Object[])new Object[0]), (boolean)false, (Insets)new Insets(2, 0, 0, 0)));
        descriptionPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myBrowser), "Center");
        this.myRightSplitter = new JBSplitter(true, "SingleInspectionProfilePanel.HORIZONTAL_DIVIDER_PROPORTION", 0.5f);
        this.myRightSplitter.setFirstComponent((JComponent)descriptionPanel);
        this.myOptionsPanel = new JPanel(new GridBagLayout());
        this.initOptionsAndDescriptionPanel();
        this.myRightSplitter.setSecondComponent((JComponent)this.myOptionsPanel);
        this.myRightSplitter.setHonorComponentsMinimumSize(true);
        JScrollPane tree = this.initTreeScrollPane();
        JPanel northPanel = new JPanel(new GridBagLayout());
        northPanel.setBorder(IdeBorderFactory.createEmptyBorder((int)2, (int)0, (int)2, (int)0));
        this.myProfileFilter.setPreferredSize(new Dimension(20, this.myProfileFilter.getPreferredSize().height));
        northPanel.add((Component)this.myProfileFilter, new GridBagConstraints(0, 0, 1, 1, 0.5, 1.0, 768, 2, new Insets(0, 0, 0, 0), 0, 0));
        northPanel.add((Component)this.createTreeToolbarPanel().getComponent(), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 512, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.myMainSplitter = new JBSplitter(false, 0.5f, 0.01f, 0.99f);
        this.myMainSplitter.setSplitterProportionKey("SingleInspectionProfilePanel.VERTICAL_DIVIDER_PROPORTION");
        this.myMainSplitter.setFirstComponent((JComponent)tree);
        this.myMainSplitter.setSecondComponent((JComponent)this.myRightSplitter);
        this.myMainSplitter.setHonorComponentsMinimumSize(false);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)northPanel, "North");
        panel.add((Component)this.myMainSplitter, "Center");
        return panel;
    }

    public boolean isModified() {
        if (this.myModified) {
            return true;
        }
        if (this.mySelectedProfile.isChanged()) {
            return true;
        }
        if (this.myIsProjectLevel != (this.mySelectedProfile.getProfileManager() == this.myProjectProfileManager)) {
            return true;
        }
        if (!Comparing.strEqual((String)this.myCurrentProfileName, (String)this.mySelectedProfile.getName())) {
            return true;
        }
        if (!Comparing.equal((Object[])this.myInitialScopesOrder, (Object[])this.mySelectedProfile.getScopesOrder())) {
            return true;
        }
        return this.descriptorsAreChanged();
    }

    public void reset() {
        this.myModified = false;
        this.setSelectedProfile(this.mySelectedProfile);
        String filter = this.myProfileFilter.getFilter();
        this.myProfileFilter.reset();
        this.myProfileFilter.setSelectedItem(filter);
        this.myIsProjectLevel = this.mySelectedProfile.getProfileManager() == this.myProjectProfileManager;
    }

    public void apply() throws ConfigurationException {
        boolean modified = this.isModified();
        if (!modified) {
            return;
        }
        ModifiableModel selectedProfile = this.getSelectedProfile();
        ProfileManager profileManager = (ProfileManager)(this.myIsProjectLevel ? this.myProjectProfileManager : InspectionProfileManager.getInstance());
        selectedProfile.setProjectLevel(this.myIsProjectLevel);
        if (selectedProfile.getProfileManager() != profileManager) {
            if (selectedProfile.getProfileManager().getProfile(selectedProfile.getName(), false) == this.myOriginal) {
                selectedProfile.getProfileManager().deleteProfile(selectedProfile.getName());
            }
            selectedProfile.setName(this.myCurrentProfileName);
            SingleInspectionProfilePanel.copyUsedSeveritiesIfUndefined(selectedProfile, profileManager);
            selectedProfile.setProfileManager(profileManager);
        } else if (!Comparing.equal((String)this.myCurrentProfileName, (String)selectedProfile.getName())) {
            if (selectedProfile.getProfileManager().getProfile(selectedProfile.getName(), false) == this.myOriginal) {
                selectedProfile.getProfileManager().deleteProfile(selectedProfile.getName());
            }
            selectedProfile.setName(this.myCurrentProfileName);
            selectedProfile.getProfileManager().updateProfile((Profile)selectedProfile);
        }
        InspectionProfile parentProfile = selectedProfile.getParentProfile();
        try {
            selectedProfile.commit();
        }
        catch (IOException e) {
            throw new ConfigurationException(e.getMessage());
        }
        this.setSelectedProfile(parentProfile.getModifiableModel());
        this.setSelectedProfileModified(false);
        this.myModified = false;
        this.myOriginal = selectedProfile.getProfileManager().getProfile(selectedProfile.getName());
    }

    private boolean descriptorsAreChanged() {
        for (ToolDescriptors toolDescriptors : this.myInitialToolDescriptors) {
            Descriptor desc = toolDescriptors.getDefaultDescriptor();
            Project project = this.myProjectProfileManager.getProject();
            if (this.mySelectedProfile.isToolEnabled(desc.getKey(), null, project) != desc.isEnabled()) {
                return true;
            }
            if (this.mySelectedProfile.getErrorLevel(desc.getKey(), desc.getScope(), project) != desc.getLevel()) {
                return true;
            }
            List<Descriptor> descriptors = toolDescriptors.getNonDefaultDescriptors();
            for (Descriptor descriptor : descriptors) {
                if (this.mySelectedProfile.isToolEnabled(descriptor.getKey(), descriptor.getScope(), project) != descriptor.isEnabled()) {
                    return true;
                }
                if (this.mySelectedProfile.getErrorLevel(descriptor.getKey(), descriptor.getScope(), project) == descriptor.getLevel()) continue;
                return true;
            }
            List<ScopeToolState> tools = this.mySelectedProfile.getNonDefaultTools(desc.getKey().toString(), project);
            if (tools.size() != descriptors.size()) {
                return true;
            }
            for (int i = 0; i < tools.size(); ++i) {
                ScopeToolState pair = tools.get(i);
                if (Comparing.equal((Object)pair.getScope(project), (Object)descriptors.get(i).getScope())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isProjectLevel() {
        return this.myIsProjectLevel;
    }

    public void setIsProjectLevel(boolean value) {
        this.myIsProjectLevel = value;
    }

    @NotNull
    public String getCurrentProfileName() {
        String string = this.myCurrentProfileName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel", "getCurrentProfileName"));
        }
        return string;
    }

    public void setCurrentProfileName(@NotNull String currentProfileName) {
        if (currentProfileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentProfileName", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel", "setCurrentProfileName"));
        }
        this.myCurrentProfileName = currentProfileName;
    }

    @Override
    public void setVisible(boolean aFlag) {
        if (aFlag && this.myInspectionProfilePanel == null) {
            this.initUI();
        }
        super.setVisible(aFlag);
    }

    private void setNewHighlightingLevel(@NotNull HighlightDisplayLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel", "setNewHighlightingLevel"));
        }
        int[] rows = this.myTreeTable.getTree().getSelectionRows();
        boolean showOptionsAndDescriptorPanels = rows != null && rows.length == 1;
        for (int i = 0; rows != null && i < rows.length; ++i) {
            InspectionConfigTreeNode node = (InspectionConfigTreeNode)this.myTreeTable.getTree().getPathForRow(rows[i]).getLastPathComponent();
            InspectionConfigTreeNode parent = (InspectionConfigTreeNode)node.getParent();
            Object userObject = node.getUserObject();
            if (userObject instanceof ToolDescriptors && (node.getScopeName() != null || node.isLeaf())) {
                this.updateErrorLevel(node, showOptionsAndDescriptorPanels, level);
                SingleInspectionProfilePanel.updateUpHierarchy(parent);
                continue;
            }
            this.updateErrorLevelUpInHierarchy(level, showOptionsAndDescriptorPanels, node);
            SingleInspectionProfilePanel.updateUpHierarchy(parent);
        }
        if (rows != null) {
            this.updateOptionsAndDescriptionPanel(this.myTreeTable.getTree().getSelectionPaths());
        } else {
            this.initOptionsAndDescriptionPanel();
        }
        this.repaintTableData();
    }

    private void updateErrorLevelUpInHierarchy(@NotNull HighlightDisplayLevel level, boolean showOptionsAndDescriptorPanels, InspectionConfigTreeNode node) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel", "updateErrorLevelUpInHierarchy"));
        }
        node.dropCache();
        for (int j = 0; j < node.getChildCount(); ++j) {
            InspectionConfigTreeNode child = (InspectionConfigTreeNode)node.getChildAt(j);
            Object userObject = child.getUserObject();
            if (userObject instanceof ToolDescriptors && (child.getScopeName() != null || child.isLeaf())) {
                this.updateErrorLevel(child, showOptionsAndDescriptorPanels, level);
                continue;
            }
            this.updateErrorLevelUpInHierarchy(level, showOptionsAndDescriptorPanels, child);
        }
    }

    private void updateErrorLevel(InspectionConfigTreeNode child, boolean showOptionsAndDescriptorPanels, @NotNull HighlightDisplayLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel", "updateErrorLevel"));
        }
        HighlightDisplayKey key = child.getDefaultDescriptor().getKey();
        this.mySelectedProfile.setErrorLevel(key, level, null, this.myProjectProfileManager.getProject());
        child.dropCache();
        if (showOptionsAndDescriptorPanels) {
            this.updateOptionsAndDescriptionPanel(new TreePath(child.getPath()));
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTreeTable;
    }

    private class MyFilterComponent
    extends FilterComponent {
        private MyFilterComponent() {
            super(SingleInspectionProfilePanel.INSPECTION_FILTER_HISTORY, 10);
            this.setHistory(Collections.singletonList("\"New in 14\""));
        }

        public void filter() {
            SingleInspectionProfilePanel.this.filterTree(this.getFilter());
        }

        protected void onlineFilter() {
            if (SingleInspectionProfilePanel.this.mySelectedProfile == null) {
                return;
            }
            String filter = this.getFilter();
            SingleInspectionProfilePanel.getExpandedNodes(SingleInspectionProfilePanel.this.mySelectedProfile).saveVisibleState((Tree)SingleInspectionProfilePanel.this.myTreeTable.getTree());
            SingleInspectionProfilePanel.this.fillTreeData(filter, true);
            SingleInspectionProfilePanel.this.reloadModel();
            if (filter == null || filter.isEmpty()) {
                SingleInspectionProfilePanel.this.restoreTreeState();
            } else {
                TreeUtil.expandAll((JTree)SingleInspectionProfilePanel.this.myTreeTable.getTree());
            }
        }
    }
}

