/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.lang.LanguageUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.FreeThreadedFileViewProvider;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.smartPointers.ClsElementInfo;
import com.intellij.psi.impl.smartPointers.DirElementInfo;
import com.intellij.psi.impl.smartPointers.FileElementInfo;
import com.intellij.psi.impl.smartPointers.HardElementInfo;
import com.intellij.psi.impl.smartPointers.InjectedSelfElementInfo;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfoFactory;
import com.intellij.psi.impl.smartPointers.SmartPointerEx;
import com.intellij.reference.SoftReference;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SmartPsiElementPointerImpl<E extends PsiElement>
implements SmartPointerEx<E> {
    private Reference<E> myElement;
    private final SmartPointerElementInfo myElementInfo;
    private final Class<? extends PsiElement> myElementClass;
    private byte myReferenceCount;

    SmartPsiElementPointerImpl(@NotNull Project project, @NotNull E element, @Nullable PsiFile containingFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "<init>"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "<init>"));
        }
        this(element, SmartPsiElementPointerImpl.createElementInfo(project, element, containingFile), element.getClass());
    }

    SmartPsiElementPointerImpl(@NotNull E element, @NotNull SmartPointerElementInfo elementInfo, @NotNull Class<? extends PsiElement> elementClass) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "<init>"));
        }
        if (elementInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementInfo", "com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "<init>"));
        }
        if (elementClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementClass", "com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "<init>"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.myElementClass = elementClass;
        this.myElementInfo = elementInfo;
        this.cacheElement(element);
    }

    public boolean equals(Object obj) {
        return obj instanceof SmartPsiElementPointer && SmartPsiElementPointerImpl.pointsToTheSameElementAs(this, (SmartPsiElementPointer)obj);
    }

    public int hashCode() {
        return this.myElementInfo.elementHashCode();
    }

    @NotNull
    public Project getProject() {
        Project project = this.myElementInfo.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "getProject"));
        }
        return project;
    }

    @Nullable
    public E getElement() {
        Object element = this.getCachedElement();
        if (element != null && !element.isValid()) {
            element = null;
        }
        if (element == null) {
            element = this.myElementInfo.restoreElement();
            if (!(element == null || element.getClass().equals(this.myElementClass) && element.isValid())) {
                element = null;
            }
            this.cacheElement(element);
        }
        return element;
    }

    private void cacheElement(E element) {
        this.myElement = element == null ? null : (((PsiManagerEx)PsiManager.getInstance((Project)this.getProject())).isBatchFilesProcessingMode() ? new WeakReference<E>(element) : new java.lang.ref.SoftReference<E>(element));
    }

    public E getCachedElement() {
        return (E)((PsiElement)SoftReference.dereference(this.myElement));
    }

    public PsiFile getContainingFile() {
        PsiFile file = this.getElementInfo().restoreFile();
        if (file != null) {
            return file;
        }
        Document doc = this.myElementInfo.getDocumentToSynchronize();
        if (doc == null) {
            E resolved = this.getElement();
            return resolved == null ? null : resolved.getContainingFile();
        }
        return PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(doc);
    }

    public VirtualFile getVirtualFile() {
        return this.myElementInfo.getVirtualFile();
    }

    public Segment getRange() {
        return this.myElementInfo.getRange();
    }

    @Nullable
    public Segment getPsiRange() {
        return this.myElementInfo.getPsiRange();
    }

    @NotNull
    private static <E extends PsiElement> SmartPointerElementInfo createElementInfo(@NotNull Project project, @NotNull E element, PsiFile containingFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "createElementInfo"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "createElementInfo"));
        }
        if (element instanceof PsiDirectory) {
            DirElementInfo dirElementInfo = new DirElementInfo((PsiDirectory)element);
            if (dirElementInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "createElementInfo"));
            }
            return dirElementInfo;
        }
        if (element instanceof PsiCompiledElement || containingFile == null || !containingFile.isPhysical() || !element.isPhysical()) {
            if (element instanceof StubBasedPsiElement && element instanceof PsiCompiledElement) {
                if (element instanceof PsiFile) {
                    FileElementInfo fileElementInfo = new FileElementInfo((PsiFile)element);
                    if (fileElementInfo == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "createElementInfo"));
                    }
                    return fileElementInfo;
                }
                PsiAnchor.StubIndexReference stubReference = PsiAnchor.createStubReference(element, containingFile);
                if (stubReference != null) {
                    ClsElementInfo clsElementInfo = new ClsElementInfo(stubReference);
                    if (clsElementInfo == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "createElementInfo"));
                    }
                    return clsElementInfo;
                }
            }
            HardElementInfo hardElementInfo = new HardElementInfo(project, element);
            if (hardElementInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "createElementInfo"));
            }
            return hardElementInfo;
        }
        FileViewProvider viewProvider = containingFile.getViewProvider();
        if (viewProvider instanceof FreeThreadedFileViewProvider) {
            PsiLanguageInjectionHost hostContext = InjectedLanguageManager.getInstance((Project)containingFile.getProject()).getInjectionHost((PsiElement)containingFile);
            TextRange elementRange = element.getTextRange();
            if (hostContext != null && elementRange != null) {
                SmartPsiElementPointer hostPointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)hostContext);
                InjectedSelfElementInfo injectedSelfElementInfo = new InjectedSelfElementInfo(project, element, elementRange, containingFile, (SmartPsiElementPointer<PsiLanguageInjectionHost>)hostPointer);
                if (injectedSelfElementInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "createElementInfo"));
                }
                return injectedSelfElementInfo;
            }
        }
        for (PsiLanguageInjectionHost factory : (PsiLanguageInjectionHost)Extensions.getExtensions(SmartPointerElementInfoFactory.EP_NAME)) {
            SmartPointerElementInfo result = factory.createElementInfo(element);
            if (result == null) continue;
            SmartPointerElementInfo smartPointerElementInfo = result;
            if (smartPointerElementInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "createElementInfo"));
            }
            return smartPointerElementInfo;
        }
        if (element instanceof PsiFile) {
            FileElementInfo fileElementInfo = new FileElementInfo((PsiFile)element);
            if (fileElementInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "createElementInfo"));
            }
            return fileElementInfo;
        }
        TextRange elementRange = element.getTextRange();
        if (elementRange == null) {
            HardElementInfo hardElementInfo = new HardElementInfo(project, element);
            if (hardElementInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "createElementInfo"));
            }
            return hardElementInfo;
        }
        ProperTextRange proper = ProperTextRange.create((Segment)elementRange);
        SelfElementInfo selfElementInfo = new SelfElementInfo(project, proper, element.getClass(), containingFile, LanguageUtil.getRootLanguage(element), false);
        if (selfElementInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "createElementInfo"));
        }
        return selfElementInfo;
    }

    @Override
    public void fastenBelt() {
        this.myElementInfo.fastenBelt();
    }

    @NotNull
    SmartPointerElementInfo getElementInfo() {
        SmartPointerElementInfo smartPointerElementInfo = this.myElementInfo;
        if (smartPointerElementInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "getElementInfo"));
        }
        return smartPointerElementInfo;
    }

    static boolean pointsToTheSameElementAs(@NotNull SmartPsiElementPointer pointer1, @NotNull SmartPsiElementPointer pointer2) {
        if (pointer1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer1", "com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "pointsToTheSameElementAs"));
        }
        if (pointer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer2", "com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "pointsToTheSameElementAs"));
        }
        if (pointer1 == pointer2) {
            return true;
        }
        if (pointer1 instanceof SmartPsiElementPointerImpl && pointer2 instanceof SmartPsiElementPointerImpl) {
            SmartPointerElementInfo elementInfo2;
            SmartPsiElementPointerImpl impl1 = (SmartPsiElementPointerImpl)pointer1;
            SmartPsiElementPointerImpl impl2 = (SmartPsiElementPointerImpl)pointer2;
            SmartPointerElementInfo elementInfo1 = impl1.getElementInfo();
            if (!elementInfo1.pointsToTheSameElementAs(elementInfo2 = impl2.getElementInfo())) {
                return false;
            }
            Object cachedElement1 = impl1.getCachedElement();
            Object cachedElement2 = impl2.getCachedElement();
            return cachedElement1 == null || cachedElement2 == null || Comparing.equal(cachedElement1, cachedElement2);
        }
        return Comparing.equal((Object)pointer1.getElement(), (Object)pointer2.getElement());
    }

    int incrementAndGetReferenceCount(int delta) {
        if (this.myReferenceCount == 127) {
            return 127;
        }
        this.myReferenceCount = (byte)(this.myReferenceCount + delta);
        return this.myReferenceCount;
    }
}

