/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.resolve.ClassResolverProcessor;
import com.intellij.psi.impl.source.resolve.SymbolCollectingProcessor;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NotNullFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.indexing.IndexingDataKeys;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class PsiJavaFileBaseImpl
extends PsiFileImpl
implements PsiJavaFile {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.PsiJavaFileBaseImpl");
    @NonNls
    private static final String[] IMPLICIT_IMPORTS = new String[]{"java.lang"};
    private final CachedValue<MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext>> myResolveCache;
    private volatile String myPackageName;
    private static final NotNullLazyKey<LanguageLevel, PsiJavaFileBaseImpl> LANGUAGE_LEVEL_KEY = NotNullLazyKey.create((String)"LANGUAGE_LEVEL", (NotNullFunction)new NotNullFunction<PsiJavaFileBaseImpl, LanguageLevel>(){

        @NotNull
        public LanguageLevel fun(PsiJavaFileBaseImpl file) {
            LanguageLevel languageLevel = file.getLanguageLevelInner();
            if (languageLevel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl$1", "fun"));
            }
            return languageLevel;
        }
    });

    protected PsiJavaFileBaseImpl(IElementType elementType, IElementType contentElementType, FileViewProvider viewProvider) {
        super(elementType, contentElementType, viewProvider);
        this.myResolveCache = CachedValuesManager.getManager((Project)this.myManager.getProject()).createCachedValue((CachedValueProvider)new MyCacheBuilder(this), false);
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.myPackageName = null;
    }

    @NotNull
    public PsiClass[] getClasses() {
        StubElement stub = this.getStub();
        if (stub != null) {
            PsiClass[] psiClassArray = (PsiClass[])stub.getChildrenByType((IElementType)JavaStubElementTypes.CLASS, PsiClass.ARRAY_FACTORY);
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "getClasses"));
            }
            return psiClassArray;
        }
        PsiClass[] psiClassArray = (PsiClass[])this.calcTreeElement().getChildrenAsPsiElements(Constants.CLASS_BIT_SET, PsiClass.ARRAY_FACTORY);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "getClasses"));
        }
        return psiClassArray;
    }

    public PsiPackageStatement getPackageStatement() {
        ASTNode node = this.calcTreeElement().findChildByType(JavaElementType.PACKAGE_STATEMENT);
        return node != null ? (PsiPackageStatement)node.getPsi() : null;
    }

    @NotNull
    public String getPackageName() {
        PsiJavaFileStub stub = (PsiJavaFileStub)this.getStub();
        if (stub != null) {
            String string = stub.getPackageName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "getPackageName"));
            }
            return string;
        }
        String name = this.myPackageName;
        if (name == null) {
            PsiPackageStatement statement = this.getPackageStatement();
            name = statement == null ? "" : statement.getPackageName();
            this.myPackageName = name;
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "getPackageName"));
        }
        return string;
    }

    public void setPackageName(String packageName) throws IncorrectOperationException {
        PsiPackageStatement packageStatement = this.getPackageStatement();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory();
        if (packageStatement != null) {
            if (!packageName.isEmpty()) {
                PsiJavaCodeReferenceElement reference = packageStatement.getPackageReference();
                reference.replace((PsiElement)factory.createReferenceFromText(packageName, (PsiElement)packageStatement));
            } else {
                packageStatement.delete();
            }
        } else if (!packageName.isEmpty()) {
            this.addBefore((PsiElement)factory.createPackageStatement(packageName), this.getFirstChild());
        }
    }

    @NotNull
    public PsiImportList getImportList() {
        StubElement stub = this.getStub();
        if (stub != null) {
            PsiImportList[] nodes = (PsiImportList[])stub.getChildrenByType((IElementType)JavaStubElementTypes.IMPORT_LIST, PsiImportList.ARRAY_FACTORY);
            if (nodes.length != 1) {
                this.reportStubAstMismatch(stub + "; " + stub.getChildrenStubs(), this.getStubTree(), PsiDocumentManager.getInstance((Project)this.getProject()).getCachedDocument((PsiFile)this));
            }
            PsiImportList psiImportList = nodes[0];
            if (psiImportList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "getImportList"));
            }
            return psiImportList;
        }
        ASTNode node = this.calcTreeElement().findChildByType(JavaElementType.IMPORT_LIST);
        assert (node != null) : this.getFileType() + ", " + this.getName();
        PsiImportList psiImportList = (PsiImportList)SourceTreeToPsiMap.treeToPsiNotNull(node);
        if (psiImportList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "getImportList"));
        }
        return psiImportList;
    }

    @NotNull
    public PsiElement[] getOnDemandImports(boolean includeImplicit, boolean checkIncludes) {
        PsiImportStatement[] statements;
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        PsiImportList importList = this.getImportList();
        for (PsiImportStatement statement : statements = importList.getImportStatements()) {
            PsiElement resolved;
            if (!statement.isOnDemand() || (resolved = statement.resolve()) == null) continue;
            array.add(resolved);
        }
        if (includeImplicit) {
            PsiJavaCodeReferenceElement[] implicitRefs;
            for (PsiJavaCodeReferenceElement implicitRef : implicitRefs = this.getImplicitlyImportedPackageReferences()) {
                PsiElement resolved = implicitRef.resolve();
                if (resolved == null) continue;
                array.add(resolved);
            }
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(array);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "getOnDemandImports"));
        }
        return psiElementArray;
    }

    @NotNull
    public PsiClass[] getSingleClassImports(boolean checkIncludes) {
        PsiImportStatement[] statements;
        ArrayList<PsiClass> array = new ArrayList<PsiClass>();
        PsiImportList importList = this.getImportList();
        for (PsiImportStatement statement : statements = importList.getImportStatements()) {
            PsiElement ref;
            if (statement.isOnDemand() || !((ref = statement.resolve()) instanceof PsiClass)) continue;
            array.add((PsiClass)ref);
        }
        PsiClass[] psiClassArray = array.toArray(new PsiClass[array.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "getSingleClassImports"));
        }
        return psiClassArray;
    }

    public PsiJavaCodeReferenceElement findImportReferenceTo(PsiClass aClass) {
        PsiImportStatement[] statements;
        PsiImportList importList = this.getImportList();
        for (PsiImportStatement statement : statements = importList.getImportStatements()) {
            PsiElement ref;
            if (statement.isOnDemand() || (ref = statement.resolve()) == null || !this.getManager().areElementsEquivalent(ref, (PsiElement)aClass)) continue;
            return statement.getImportReference();
        }
        return null;
    }

    @NotNull
    public String[] getImplicitlyImportedPackages() {
        if (IMPLICIT_IMPORTS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "getImplicitlyImportedPackages"));
        }
        return IMPLICIT_IMPORTS;
    }

    @NotNull
    public PsiJavaCodeReferenceElement[] getImplicitlyImportedPackageReferences() {
        PsiJavaCodeReferenceElement[] psiJavaCodeReferenceElementArray = PsiImplUtil.namesToPackageReferences(this.myManager, IMPLICIT_IMPORTS);
        if (psiJavaCodeReferenceElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "getImplicitlyImportedPackageReferences"));
        }
        return psiJavaCodeReferenceElementArray;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "processDeclarations"));
        }
        assert (this.isValid());
        if (processor instanceof ClassResolverProcessor && this.isPhysical() && (this.getUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING) == Boolean.TRUE || this.myResolveCache.hasUpToDateValue())) {
            ClassResolverProcessor hint = (ClassResolverProcessor)processor;
            String name = hint.getName(state);
            MostlySingularMultiMap cache = (MostlySingularMultiMap)this.myResolveCache.getValue();
            MyResolveCacheProcessor cacheProcessor = new MyResolveCacheProcessor(processor, state);
            return name != null ? cache.processForKey((Object)name, (Processor)cacheProcessor) : cache.processAllValues((Processor)cacheProcessor);
        }
        return this.processDeclarationsNoGuess(processor, state, lastParent, place);
    }

    /*
     * WARNING - void declaration
     */
    private boolean processDeclarationsNoGuess(PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, PsiElement place) {
        PsiImportStaticStatement[] importStaticStatements;
        PsiElement resolved;
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "processDeclarationsNoGuess"));
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
        String name = nameHint != null ? nameHint.getName(state) : null;
        PsiImportList importList = this.getImportList();
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            void var14_21;
            PsiClass[] classes;
            for (PsiClass aClass : classes = this.getClasses()) {
                if (processor.execute((PsiElement)aClass, state)) continue;
                return false;
            }
            PsiImportStatement[] importStatements = importList.getImportStatements();
            for (PsiImportStaticStatement psiImportStaticStatement : importStatements) {
                String refText;
                if (psiImportStaticStatement.isOnDemand() || name != null && ((refText = psiImportStaticStatement.getQualifiedName()) == null || !refText.endsWith(name)) || !((resolved = psiImportStaticStatement.resolve()) instanceof PsiClass)) continue;
                processor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, (Object)psiImportStaticStatement);
                PsiClass containingClass = ((PsiClass)resolved).getContainingClass();
                if (!(containingClass != null && containingClass.hasTypeParameters() ? !processor.execute(resolved, state.put(PsiSubstitutor.KEY, (Object)PsiJavaFileBaseImpl.createRawSubstitutor(containingClass))) : !processor.execute(resolved, state))) continue;
                return false;
            }
            processor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, null);
            PsiPackage aPackage = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).findPackage(this.getPackageName());
            if (aPackage != null && !aPackage.processDeclarations(processor, state, null, place)) {
                return false;
            }
            PsiImportStatement[] psiImportStatementArray = importStatements;
            int n = psiImportStatementArray.length;
            boolean bl = false;
            while (var14_21 < n) {
                PsiElement resolved2;
                PsiImportStatement statement2 = psiImportStatementArray[var14_21];
                if (statement2.isOnDemand() && (resolved2 = statement2.resolve()) != null) {
                    processor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, (Object)statement2);
                    PsiJavaFileBaseImpl.processOnDemandTarget(resolved2, processor, state, place);
                }
                ++var14_21;
            }
        }
        if ((importStaticStatements = importList.getImportStaticStatements()).length > 0) {
            StaticImportFilteringProcessor staticImportProcessor = new StaticImportFilteringProcessor(processor);
            for (PsiImportStaticStatement psiImportStaticStatement : importStaticStatements) {
                JavaResolveResult[] results;
                PsiJavaCodeReferenceElement reference;
                if (psiImportStaticStatement.isOnDemand() || (reference = psiImportStaticStatement.getImportReference()) == null || (results = reference.multiResolve(false)).length <= 0) continue;
                staticImportProcessor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, psiImportStaticStatement);
                for (JavaResolveResult result : results) {
                    if (staticImportProcessor.execute(result.getElement(), state)) continue;
                    return false;
                }
            }
            for (PsiImportStaticStatement psiImportStaticStatement : importStaticStatements) {
                PsiClass targetElement;
                if (!psiImportStaticStatement.isOnDemand() || (targetElement = psiImportStaticStatement.resolveTargetClass()) == null) continue;
                staticImportProcessor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, psiImportStaticStatement);
                if (targetElement.processDeclarations((PsiScopeProcessor)staticImportProcessor, state, lastParent, place)) continue;
                return false;
            }
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            processor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, null);
            PsiJavaCodeReferenceElement[] implicitlyImported = this.getImplicitlyImportedPackageReferences();
            for (PsiImportStaticStatement psiImportStaticStatement : implicitlyImported) {
                resolved = psiImportStaticStatement.resolve();
                if (resolved == null || PsiJavaFileBaseImpl.processOnDemandTarget(resolved, processor, state, place)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    private static PsiSubstitutor createRawSubstitutor(PsiClass containingClass) {
        PsiSubstitutor psiSubstitutor = JavaPsiFacade.getElementFactory((Project)containingClass.getProject()).createRawSubstitutor((PsiTypeParameterListOwner)containingClass);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "createRawSubstitutor"));
        }
        return psiSubstitutor;
    }

    private static boolean processOnDemandTarget(PsiElement target, PsiScopeProcessor processor, ResolveState substitutor, PsiElement place) {
        if (target instanceof PsiPackage) {
            if (!target.processDeclarations(processor, substitutor, null, place)) {
                return false;
            }
        } else if (target instanceof PsiClass) {
            PsiClass[] inners = ((PsiClass)target).getInnerClasses();
            if (((PsiClass)target).hasTypeParameters()) {
                substitutor = substitutor.put(PsiSubstitutor.KEY, (Object)PsiJavaFileBaseImpl.createRawSubstitutor((PsiClass)target));
            }
            for (PsiClass inner : inners) {
                if (processor.execute((PsiElement)inner, substitutor)) continue;
                return false;
            }
        } else {
            LOG.assertTrue(false);
        }
        return true;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitJavaFile((PsiJavaFile)this);
        } else {
            visitor.visitFile((PsiFile)this);
        }
    }

    @Override
    @NotNull
    public Language getLanguage() {
        JavaLanguage javaLanguage = JavaLanguage.INSTANCE;
        if (javaLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "getLanguage"));
        }
        return javaLanguage;
    }

    public boolean importClass(PsiClass aClass) {
        return JavaCodeStyleManager.getInstance((Project)this.getProject()).addImport((PsiJavaFile)this, aClass);
    }

    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel languageLevel = (LanguageLevel)LANGUAGE_LEVEL_KEY.getValue((UserDataHolder)this);
        if (languageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "getLanguageLevel"));
        }
        return languageLevel;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.putUserData((Key)LANGUAGE_LEVEL_KEY, null);
    }

    private LanguageLevel getLanguageLevelInner() {
        if (this.myOriginalFile instanceof PsiJavaFile) {
            return ((PsiJavaFile)this.myOriginalFile).getLanguageLevel();
        }
        LanguageLevel forcedLanguageLevel = (LanguageLevel)this.getUserData(PsiUtil.FILE_LANGUAGE_LEVEL_KEY);
        if (forcedLanguageLevel != null) {
            return forcedLanguageLevel;
        }
        VirtualFile virtualFile = this.getVirtualFile();
        if (virtualFile == null) {
            virtualFile = (VirtualFile)this.getUserData(IndexingDataKeys.VIRTUAL_FILE);
        }
        Project project = this.getProject();
        if (virtualFile == null) {
            PsiFile originalFile = this.getOriginalFile();
            if (originalFile instanceof PsiJavaFile && originalFile != this) {
                return ((PsiJavaFile)originalFile).getLanguageLevel();
            }
            return LanguageLevelProjectExtension.getInstance((Project)project).getLanguageLevel();
        }
        return JavaPsiImplementationHelper.getInstance(project).getEffectiveLanguageLevel(virtualFile);
    }

    private static class MyResolveCacheProcessor
    implements Processor<SymbolCollectingProcessor.ResultWithContext> {
        private final PsiScopeProcessor myProcessor;
        private final ResolveState myState;

        public MyResolveCacheProcessor(PsiScopeProcessor processor, ResolveState state) {
            this.myProcessor = processor;
            this.myState = state;
        }

        public boolean process(SymbolCollectingProcessor.ResultWithContext result) {
            PsiClass containingClass;
            PsiElement context = result.getFileContext();
            this.myProcessor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, (Object)context);
            PsiNamedElement element = result.getElement();
            if (element instanceof PsiClass && context instanceof PsiImportStatement && (containingClass = ((PsiClass)element).getContainingClass()) != null && containingClass.hasTypeParameters()) {
                return this.myProcessor.execute((PsiElement)element, this.myState.put(PsiSubstitutor.KEY, (Object)PsiJavaFileBaseImpl.createRawSubstitutor(containingClass)));
            }
            return this.myProcessor.execute((PsiElement)element, this.myState);
        }
    }

    private static class MyCacheBuilder
    implements CachedValueProvider<MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext>> {
        private final PsiJavaFileBaseImpl myFile;

        public MyCacheBuilder(PsiJavaFileBaseImpl file) {
            this.myFile = file;
        }

        public CachedValueProvider.Result<MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext>> compute() {
            SymbolCollectingProcessor p = new SymbolCollectingProcessor();
            this.myFile.processDeclarationsNoGuess(p, ResolveState.initial(), (PsiElement)this.myFile, (PsiElement)this.myFile);
            MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext> results = p.getResults();
            return CachedValueProvider.Result.create(results, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this.myFile});
        }
    }

    private static class StaticImportFilteringProcessor
    implements PsiScopeProcessor {
        private final PsiScopeProcessor myDelegate;
        private boolean myIsProcessingOnDemand;
        private final Collection<String> myHiddenNames = new HashSet();
        private final Collection<PsiElement> myCollectedElements = new HashSet();

        public StaticImportFilteringProcessor(PsiScopeProcessor delegate) {
            this.myDelegate = delegate;
        }

        public <T> T getHint(@NotNull Key<T> hintKey) {
            if (hintKey == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl$StaticImportFilteringProcessor", "getHint"));
            }
            return (T)this.myDelegate.getHint(hintKey);
        }

        public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl$StaticImportFilteringProcessor", "handleEvent"));
            }
            if (JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT.equals(event) && associated instanceof PsiImportStaticStatement) {
                PsiImportStaticStatement importStaticStatement = (PsiImportStaticStatement)associated;
                this.myIsProcessingOnDemand = importStaticStatement.isOnDemand();
                if (!this.myIsProcessingOnDemand) {
                    this.myHiddenNames.add(importStaticStatement.getReferenceName());
                }
            }
            this.myDelegate.handleEvent(event, associated);
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl$StaticImportFilteringProcessor", "execute"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl$StaticImportFilteringProcessor", "execute"));
            }
            if (element instanceof PsiModifierListOwner && ((PsiModifierListOwner)element).hasModifierProperty("static")) {
                String name;
                if (element instanceof PsiNamedElement && this.myIsProcessingOnDemand && this.myHiddenNames.contains(name = ((PsiNamedElement)element).getName())) {
                    return true;
                }
                if (this.myCollectedElements.add(element)) {
                    return this.myDelegate.execute(element, state);
                }
            }
            return true;
        }
    }
}

