/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.openapi.options.BaseSchemeProcessor;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.SchemesManagerFactory;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemeImpl;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CodeStyleSchemesImpl
extends CodeStyleSchemes {
    protected static final String DEFAULT_SCHEME_NAME = "Default";
    @NonNls
    static final String CODE_STYLES_DIR_PATH = "codestyles";
    protected final SchemesManager<CodeStyleScheme, CodeStyleSchemeImpl> mySchemesManager;

    public CodeStyleSchemesImpl(@NotNull SchemesManagerFactory schemesManagerFactory) {
        if (schemesManagerFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemesManagerFactory", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemesImpl", "<init>"));
        }
        this.mySchemesManager = schemesManagerFactory.create(CODE_STYLES_DIR_PATH, (SchemeProcessor)new BaseSchemeProcessor<CodeStyleSchemeImpl>(){

            @NotNull
            public CodeStyleSchemeImpl readScheme(@NotNull Element element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemesImpl$1", "readScheme"));
                }
                CodeStyleSchemeImpl codeStyleSchemeImpl = new CodeStyleSchemeImpl(element.getAttributeValue("name"), element.getAttributeValue("parent"), element);
                if (codeStyleSchemeImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemesImpl$1", "readScheme"));
                }
                return codeStyleSchemeImpl;
            }

            public Element writeScheme(@NotNull CodeStyleSchemeImpl scheme) throws WriteExternalException {
                if (scheme == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemesImpl$1", "writeScheme"));
                }
                Element newElement = new Element("code_scheme");
                newElement.setAttribute("name", scheme.getName());
                scheme.writeExternal(newElement);
                return newElement;
            }

            @NotNull
            public BaseSchemeProcessor.State getState(@NotNull CodeStyleSchemeImpl scheme) {
                if (scheme == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemesImpl$1", "getState"));
                }
                BaseSchemeProcessor.State state = scheme.isDefault() ? BaseSchemeProcessor.State.NON_PERSISTENT : BaseSchemeProcessor.State.POSSIBLY_CHANGED;
                if (state == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemesImpl$1", "getState"));
                }
                return state;
            }

            public void initScheme(@NotNull CodeStyleSchemeImpl scheme) {
                if (scheme == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemesImpl$1", "initScheme"));
                }
                scheme.init(CodeStyleSchemesImpl.this);
            }
        });
        this.mySchemesManager.loadSchemes();
        this.addScheme(new CodeStyleSchemeImpl(DEFAULT_SCHEME_NAME, true, null));
        this.setCurrentScheme(this.getDefaultScheme());
    }

    public CodeStyleScheme[] getSchemes() {
        List schemes = this.mySchemesManager.getAllSchemes();
        return schemes.toArray(new CodeStyleScheme[schemes.size()]);
    }

    public CodeStyleScheme getCurrentScheme() {
        return (CodeStyleScheme)this.mySchemesManager.getCurrentScheme();
    }

    public void setCurrentScheme(CodeStyleScheme scheme) {
        this.mySchemesManager.setCurrent((Scheme)scheme);
    }

    public CodeStyleScheme createNewScheme(String preferredName, CodeStyleScheme parentScheme) {
        String name;
        if (preferredName == null) {
            if (parentScheme == null) {
                throw new IllegalArgumentException("parentScheme must not be null");
            }
            name = null;
            int i = 1;
            while (name == null) {
                String currName = parentScheme.getName() + " (" + i + ")";
                if (this.findSchemeByName(currName) == null) {
                    name = currName;
                }
                ++i;
            }
        } else {
            name = null;
            int i = 0;
            while (name == null) {
                String currName;
                String string = currName = i == 0 ? preferredName : preferredName + " (" + i + ")";
                if (this.findSchemeByName(currName) == null) {
                    name = currName;
                }
                ++i;
            }
        }
        return new CodeStyleSchemeImpl(name, false, parentScheme);
    }

    public void deleteScheme(CodeStyleScheme scheme) {
        if (scheme.isDefault()) {
            throw new IllegalArgumentException("Unable to delete default scheme!");
        }
        CodeStyleSchemeImpl currScheme = (CodeStyleSchemeImpl)this.getCurrentScheme();
        if (currScheme == scheme) {
            CodeStyleScheme newCurrentScheme = this.getDefaultScheme();
            if (newCurrentScheme == null) {
                throw new IllegalStateException("Unable to load default scheme!");
            }
            this.setCurrentScheme(newCurrentScheme);
        }
        this.mySchemesManager.removeScheme((Scheme)scheme);
    }

    public void setSchemes(@NotNull List<CodeStyleScheme> schemes) {
        if (schemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemes", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemesImpl", "setSchemes"));
        }
        this.mySchemesManager.setSchemes(schemes);
    }

    @NotNull
    public SchemesManager<CodeStyleScheme, CodeStyleSchemeImpl> getSchemeManager() {
        SchemesManager<CodeStyleScheme, CodeStyleSchemeImpl> schemesManager = this.mySchemesManager;
        if (schemesManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemesImpl", "getSchemeManager"));
        }
        return schemesManager;
    }

    public CodeStyleScheme getDefaultScheme() {
        return this.findSchemeByName(DEFAULT_SCHEME_NAME);
    }

    @Nullable
    public CodeStyleScheme findSchemeByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemesImpl", "findSchemeByName"));
        }
        return (CodeStyleScheme)this.mySchemesManager.findSchemeByName(name);
    }

    public void addScheme(@NotNull CodeStyleScheme scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemesImpl", "addScheme"));
        }
        this.mySchemesManager.addScheme((Scheme)scheme);
    }
}

