/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference.constraints;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaParameterType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.InputOutputConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.LambdaExpressionCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.PsiMethodReferenceCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeCompatibilityConstraint;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ExpressionCompatibilityConstraint
extends InputOutputConstraintFormula {
    private final PsiExpression myExpression;
    private PsiType myT;

    public ExpressionCompatibilityConstraint(@NotNull PsiExpression expression, @NotNull PsiType type) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/psi/impl/source/resolve/graphInference/constraints/ExpressionCompatibilityConstraint", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/resolve/graphInference/constraints/ExpressionCompatibilityConstraint", "<init>"));
        }
        this.myExpression = expression;
        this.myT = type;
    }

    @Override
    public boolean reduce(InferenceSession session, List<ConstraintFormula> constraints) {
        PsiExpression expression;
        if (!PsiPolyExpressionUtil.isPolyExpression(this.myExpression)) {
            if (session.isProperType(this.myT)) {
                return TypeConversionUtil.areTypesAssignmentCompatible((PsiType)this.myT, (PsiExpression)this.myExpression);
            }
            PsiType exprType = this.myExpression.getType();
            if (exprType instanceof PsiLambdaParameterType) {
                return false;
            }
            if (exprType != null && exprType != PsiType.NULL) {
                constraints.add(new TypeCompatibilityConstraint(this.myT, exprType));
            }
            return true;
        }
        if (this.myExpression instanceof PsiParenthesizedExpression && (expression = ((PsiParenthesizedExpression)this.myExpression).getExpression()) != null) {
            constraints.add(new ExpressionCompatibilityConstraint(expression, this.myT));
            return true;
        }
        if (this.myExpression instanceof PsiConditionalExpression) {
            PsiExpression elseExpression;
            PsiExpression thenExpression = ((PsiConditionalExpression)this.myExpression).getThenExpression();
            if (thenExpression != null) {
                constraints.add(new ExpressionCompatibilityConstraint(thenExpression, this.myT));
            }
            if ((elseExpression = ((PsiConditionalExpression)this.myExpression).getElseExpression()) != null) {
                constraints.add(new ExpressionCompatibilityConstraint(elseExpression, this.myT));
            }
            return true;
        }
        if (this.myExpression instanceof PsiCallExpression) {
            PsiExpressionList argumentList = ((PsiCallExpression)this.myExpression).getArgumentList();
            if (argumentList != null) {
                MethodCandidateInfo.CurrentCandidateProperties candidateProperties = MethodCandidateInfo.getCurrentMethod((PsiElement)((PsiCallExpression)this.myExpression).getArgumentList());
                PsiType returnType = null;
                PsiTypeParameter[] typeParams = null;
                JavaResolveResult resolveResult = candidateProperties != null ? null : InferenceSession.getResolveResult((PsiCallExpression)this.myExpression, argumentList);
                PsiMethod method = null;
                if (candidateProperties != null) {
                    method = candidateProperties.getMethod();
                } else {
                    PsiElement element = resolveResult.getElement();
                    if (element instanceof PsiMethod) {
                        method = (PsiMethod)element;
                    }
                }
                if (method != null && !method.isConstructor()) {
                    returnType = method.getReturnType();
                    if (returnType != null) {
                        typeParams = method.getTypeParameters();
                    }
                } else if (resolveResult != null) {
                    PsiClass psiClass;
                    PsiClass psiClass2 = psiClass = method != null ? method.getContainingClass() : (PsiClass)resolveResult.getElement();
                    if (psiClass != null) {
                        returnType = JavaPsiFacade.getElementFactory((Project)argumentList.getProject()).createType(psiClass, PsiSubstitutor.EMPTY);
                        typeParams = psiClass.getTypeParameters();
                    }
                }
                if (typeParams != null) {
                    boolean accepted;
                    PsiSubstitutor siteSubstitutor = resolveResult instanceof MethodCandidateInfo && method != null && !method.isConstructor() ? ((MethodCandidateInfo)resolveResult).getSiteSubstitutor() : (candidateProperties != null ? candidateProperties.getSubstitutor() : PsiSubstitutor.EMPTY);
                    InferenceSession callSession = new InferenceSession(typeParams, siteSubstitutor, this.myExpression.getManager(), (PsiElement)this.myExpression);
                    callSession.propagateVariables(session.getInferenceVariables());
                    if (method != null) {
                        PsiExpression[] args = argumentList.getExpressions();
                        PsiParameter[] parameters = method.getParameterList().getParameters();
                        callSession.initExpressionConstraints(parameters, args, (PsiElement)this.myExpression, method, resolveResult instanceof MethodCandidateInfo && ((MethodCandidateInfo)resolveResult).isVarargs() || candidateProperties != null && candidateProperties.isVarargs());
                    }
                    if (!(accepted = callSession.repeatInferencePhases(true))) {
                        return false;
                    }
                    callSession.registerReturnTypeConstraints(siteSubstitutor.substitute(returnType), this.myT);
                    if (callSession.repeatInferencePhases(true)) {
                        session.registerNestedSession(callSession);
                    } else {
                        return false;
                    }
                }
            }
            return true;
        }
        if (this.myExpression instanceof PsiMethodReferenceExpression) {
            constraints.add(new PsiMethodReferenceCompatibilityConstraint((PsiMethodReferenceExpression)this.myExpression, this.myT));
            return true;
        }
        if (this.myExpression instanceof PsiLambdaExpression) {
            constraints.add(new LambdaExpressionCompatibilityConstraint((PsiLambdaExpression)this.myExpression, this.myT));
            return true;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpressionCompatibilityConstraint that = (ExpressionCompatibilityConstraint)o;
        return this.myExpression.equals(that.myExpression);
    }

    public int hashCode() {
        return this.myExpression.hashCode();
    }

    @Override
    public PsiExpression getExpression() {
        return this.myExpression;
    }

    @Override
    public PsiType getT() {
        return this.myT;
    }

    @Override
    protected void setT(PsiType t) {
        this.myT = t;
    }

    @Override
    protected InputOutputConstraintFormula createSelfConstraint(PsiType type, PsiExpression expression) {
        return new ExpressionCompatibilityConstraint(expression, type);
    }

    @Override
    protected void collectReturnTypeVariables(InferenceSession session, PsiExpression psiExpression, PsiType returnType, Set<InferenceVariable> result) {
        if (psiExpression instanceof PsiLambdaExpression && returnType != PsiType.VOID) {
            List returnExpressions = LambdaUtil.getReturnExpressions((PsiLambdaExpression)((PsiLambdaExpression)psiExpression));
            for (PsiExpression expression : returnExpressions) {
                Set<InferenceVariable> resultInputVars = this.createSelfConstraint(returnType, expression).getInputVariables(session);
                if (resultInputVars == null) continue;
                result.addAll(resultInputVars);
            }
        }
    }
}

