/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceField;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.introduceField.AbstractInplaceIntroduceFieldPopup;
import com.intellij.refactoring.introduceField.BaseExpressionToFieldHandler;
import com.intellij.refactoring.introduceField.IntroduceFieldDialog;
import com.intellij.refactoring.introduceField.IntroduceFieldHandler;
import com.intellij.refactoring.introduceField.IntroduceFieldPopupPanel;
import com.intellij.refactoring.introduceField.LocalToFieldHandler;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.refactoring.util.occurrences.OccurrenceManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InplaceIntroduceFieldPopup
extends AbstractInplaceIntroduceFieldPopup {
    private final boolean myStatic;
    private final IntroduceFieldPopupPanel myIntroduceFieldPanel;
    static BaseExpressionToFieldHandler.InitializationPlace ourLastInitializerPlace;

    public InplaceIntroduceFieldPopup(PsiLocalVariable localVariable, PsiClass parentClass, boolean aStatic, boolean currentMethodConstructor, PsiExpression[] occurrences, PsiExpression initializerExpression, TypeSelectorManagerImpl typeSelectorManager, Editor editor, boolean allowInitInMethod, boolean allowInitInMethodIfAll, PsiElement anchorElement, PsiElement anchorElementIfAll, OccurrenceManager occurrenceManager, Project project) {
        super(project, editor, initializerExpression, (PsiVariable)localVariable, occurrences, typeSelectorManager, IntroduceFieldHandler.REFACTORING_NAME, parentClass, anchorElement, occurrenceManager, anchorElementIfAll);
        this.myStatic = aStatic;
        this.myIntroduceFieldPanel = new IntroduceFieldPopupPanel(parentClass, initializerExpression, localVariable, currentMethodConstructor, localVariable != null, aStatic, (PsiExpression[])this.myOccurrences, allowInitInMethod, allowInitInMethodIfAll, typeSelectorManager);
        GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        this.myWholePanel.add((Component)this.getPreviewComponent(), constraints);
        JComponent centerPanel = this.myIntroduceFieldPanel.createCenterPanel();
        this.myWholePanel.add((Component)centerPanel, constraints);
        this.myIntroduceFieldPanel.initializeControls(initializerExpression, ourLastInitializerPlace);
    }

    protected PsiField createFieldToStartTemplateOn(final String[] names, final PsiType defaultType) {
        final PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myProject);
        return (PsiField)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<PsiField>(){

            public PsiField compute() {
                PsiField field = elementFactory.createField(InplaceIntroduceFieldPopup.this.chooseName(names, InplaceIntroduceFieldPopup.this.myParentClass.getLanguage()), defaultType);
                field = (PsiField)InplaceIntroduceFieldPopup.this.myParentClass.add((PsiElement)field);
                if (InplaceIntroduceFieldPopup.this.myExprText != null) {
                    InplaceIntroduceFieldPopup.this.updateInitializer(elementFactory, field);
                }
                PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)"final", (boolean)InplaceIntroduceFieldPopup.this.myIntroduceFieldPanel.isDeclareFinal());
                String visibility = InplaceIntroduceFieldPopup.this.myIntroduceFieldPanel.getFieldVisibility();
                if (visibility != null) {
                    PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)visibility, (boolean)true);
                }
                InplaceIntroduceFieldPopup.this.myFieldRangeStart = InplaceIntroduceFieldPopup.this.myEditor.getDocument().createRangeMarker(field.getTextRange());
                return field;
            }
        });
    }

    @Override
    protected String[] suggestNames(PsiType defaultType, String propName) {
        return InplaceIntroduceFieldPopup.suggestFieldName((PsiType)defaultType, (PsiLocalVariable)((PsiLocalVariable)this.getLocalVariable()), this.myExpr != null && ((PsiExpression)this.myExpr).isValid() ? (PsiExpression)this.myExpr : null, (boolean)this.myStatic, (PsiClass)this.myParentClass).names;
    }

    public static SuggestedNameInfo suggestFieldName(@Nullable PsiType defaultType, @Nullable PsiLocalVariable localVariable, PsiExpression initializer, boolean forStatic, @NotNull PsiClass parentClass) {
        if (parentClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentClass", "com/intellij/refactoring/introduceField/InplaceIntroduceFieldPopup", "suggestFieldName"));
        }
        return IntroduceFieldDialog.createGenerator(forStatic, localVariable, initializer, localVariable != null, null, parentClass, parentClass.getProject()).getSuggestedNameInfo(defaultType);
    }

    @Override
    protected VariableKind getVariableKind() {
        return VariableKind.FIELD;
    }

    @Override
    public void setReplaceAllOccurrences(boolean replaceAllOccurrences) {
        this.myIntroduceFieldPanel.setReplaceAllOccurrences(replaceAllOccurrences);
    }

    @Override
    protected void updateTitle(@Nullable PsiVariable variable, String value) {
        if (variable == null || !variable.hasInitializer()) {
            super.updateTitle(variable, value);
        } else {
            PsiExpression initializer = variable.getInitializer();
            assert (initializer != null);
            String text = variable.getText().replace(variable.getName(), value);
            text = text.replace(initializer.getText(), PsiExpressionTrimRenderer.render((PsiExpression)initializer));
            this.setPreviewText(text);
            this.revalidate();
        }
    }

    @Override
    protected void updateTitle(@Nullable PsiVariable variable) {
        if (variable != null) {
            this.updateTitle(variable, variable.getName());
        }
    }

    @Override
    protected String getRefactoringId() {
        return "refactoring.extractField";
    }

    public void setVisibility(String visibility) {
        this.myIntroduceFieldPanel.setVisibility(visibility);
    }

    @Override
    public boolean isReplaceAllOccurrences() {
        return this.myIntroduceFieldPanel.isReplaceAllOccurrences();
    }

    @Override
    protected void saveSettings(@NotNull PsiVariable psiVariable) {
        if (psiVariable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiVariable", "com/intellij/refactoring/introduceField/InplaceIntroduceFieldPopup", "saveSettings"));
        }
        super.saveSettings(psiVariable);
        JavaRefactoringSettings.getInstance().INTRODUCE_FIELD_VISIBILITY = this.myIntroduceFieldPanel.getFieldVisibility();
        this.myIntroduceFieldPanel.saveFinalState();
    }

    @Override
    protected boolean startsOnTheSameElement(RefactoringActionHandler handler, PsiElement element) {
        return handler instanceof IntroduceFieldHandler && super.startsOnTheSameElement(handler, element);
    }

    @Override
    protected JComponent getComponent() {
        this.myIntroduceFieldPanel.addOccurrenceListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                InplaceIntroduceFieldPopup.this.restartInplaceIntroduceTemplate();
            }
        });
        return this.myWholePanel;
    }

    private void updateInitializer(PsiElementFactory elementFactory, PsiField variable) {
        if (variable != null) {
            if (this.myIntroduceFieldPanel.getInitializerPlace() == BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION) {
                variable.setInitializer(elementFactory.createExpressionFromText(this.myExprText, (PsiElement)variable));
            } else {
                variable.setInitializer(null);
            }
        }
    }

    @Override
    protected String getActionName() {
        return "IntroduceField";
    }

    public BaseExpressionToFieldHandler.InitializationPlace getInitializerPlace() {
        return this.myIntroduceFieldPanel.getInitializerPlace();
    }

    @Override
    protected void performIntroduce() {
        ourLastInitializerPlace = this.myIntroduceFieldPanel.getInitializerPlace();
        PsiType forcedType = this.getType();
        LOG.assertTrue(forcedType == null || forcedType.isValid(), (Object)forcedType);
        final BaseExpressionToFieldHandler.Settings settings = new BaseExpressionToFieldHandler.Settings(this.getInputName(), (PsiExpression)this.getExpr(), (PsiExpression[])this.getOccurrences(), this.myIntroduceFieldPanel.isReplaceAllOccurrences(), this.myStatic, this.myIntroduceFieldPanel.isDeclareFinal(), this.myIntroduceFieldPanel.getInitializerPlace(), this.myIntroduceFieldPanel.getFieldVisibility(), (PsiLocalVariable)this.getLocalVariable(), forcedType, this.myIntroduceFieldPanel.isDeleteVariable(), this.myParentClass, false, false);
        new WriteCommandAction(this.myProject, this.getCommandName(), this.getCommandName(), new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/refactoring/introduceField/InplaceIntroduceFieldPopup$3", "run"));
                }
                if (InplaceIntroduceFieldPopup.this.getLocalVariable() != null) {
                    LocalToFieldHandler.IntroduceFieldRunnable fieldRunnable = new LocalToFieldHandler.IntroduceFieldRunnable(false, (PsiLocalVariable)InplaceIntroduceFieldPopup.this.getLocalVariable(), InplaceIntroduceFieldPopup.this.myParentClass, settings, InplaceIntroduceFieldPopup.this.myStatic, (PsiExpression[])InplaceIntroduceFieldPopup.this.myOccurrences);
                    fieldRunnable.run();
                } else {
                    BaseExpressionToFieldHandler.ConvertToFieldRunnable convertToFieldRunnable = new BaseExpressionToFieldHandler.ConvertToFieldRunnable((PsiExpression)InplaceIntroduceFieldPopup.this.myExpr, settings, settings.getForcedType(), (PsiExpression[])InplaceIntroduceFieldPopup.this.myOccurrences, InplaceIntroduceFieldPopup.this.myOccurrenceManager, InplaceIntroduceFieldPopup.this.getAnchorElementIfAll(), InplaceIntroduceFieldPopup.this.getAnchorElement(), InplaceIntroduceFieldPopup.this.myEditor, InplaceIntroduceFieldPopup.this.myParentClass);
                    convertToFieldRunnable.run();
                }
            }
        }.execute();
    }
}

