/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.spellchecker.dictionary.Loader;
import com.intellij.util.Consumer;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.jetbrains.annotations.NotNull;

public class StreamLoader
implements Loader {
    private final InputStream stream;
    private final String name;

    public StreamLoader(InputStream stream, String name) {
        this.stream = stream;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(@NotNull Consumer<String> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/spellchecker/StreamLoader", "load"));
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(this.stream, CharsetToolkit.UTF8_CHARSET));
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    consumer.consume((Object)line);
                }
            }
            finally {
                br.close();
            }
        }
        catch (Exception e) {
            Logger.getInstance(StreamLoader.class).error((Throwable)e);
        }
    }
}

