/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.template.JavaCodeContextType;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.structuralsearch.JavaPredefinedConfigurations;
import com.intellij.structuralsearch.JavaReplaceHandler;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.UnsupportedPatternException;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.JavaCompiledPattern;
import com.intellij.structuralsearch.impl.matcher.JavaMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.MatcherImplUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.JavaCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.PatternCompiler;
import com.intellij.structuralsearch.impl.matcher.filters.JavaLexicalNodesFilter;
import com.intellij.structuralsearch.impl.matcher.filters.LexicalNodesFilter;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.impl.ParameterInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementBuilder;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementContext;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaStructuralSearchProfile
extends StructuralSearchProfile {
    private JavaLexicalNodesFilter myJavaLexicalNodesFilter;

    @Override
    public String getText(PsiElement match, int start, int end) {
        PsiElement parent;
        if (match instanceof PsiIdentifier && (parent = match.getParent()) instanceof PsiJavaCodeReferenceElement && !(parent instanceof PsiExpression)) {
            match = parent;
        }
        String matchText = match.getText();
        if (start == 0 && end == -1) {
            return matchText;
        }
        return matchText.substring(start, end == -1 ? matchText.length() : end);
    }

    @Override
    public Class getElementContextByPsi(PsiElement element) {
        if (element instanceof PsiIdentifier) {
            element = element.getParent();
        }
        if (element instanceof PsiMember) {
            return PsiMember.class;
        }
        return PsiExpression.class;
    }

    @Override
    @NotNull
    public String getTypedVarString(PsiElement element) {
        String text;
        if (element instanceof PsiNamedElement) {
            text = ((PsiNamedElement)element).getName();
        } else if (element instanceof PsiAnnotation) {
            PsiJavaCodeReferenceElement referenceElement = ((PsiAnnotation)element).getNameReferenceElement();
            text = referenceElement == null ? null : referenceElement.getQualifiedName();
        } else if (element instanceof PsiNameValuePair) {
            text = ((PsiNameValuePair)element).getName();
        } else {
            int i;
            text = element.getText();
            if (StringUtil.startsWithChar((CharSequence)text, (char)'@')) {
                text = text.substring(1);
            }
            if (StringUtil.endsWithChar((CharSequence)text, (char)';')) {
                text = text.substring(0, text.length() - 1);
            } else if (element instanceof PsiExpressionStatement && (i = text.indexOf(59)) != -1) {
                text = text.substring(0, i);
            }
        }
        if (text == null) {
            text = element.getText();
        }
        String string = text;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "getTypedVarString"));
        }
        return string;
    }

    @Override
    public String getMeaningfulText(PsiElement element) {
        if (element instanceof PsiReferenceExpression && ((PsiReferenceExpression)element).getQualifierExpression() != null) {
            String text;
            PsiElement resolve = ((PsiReferenceExpression)element).resolve();
            if (resolve instanceof PsiClass) {
                return element.getText();
            }
            PsiElement referencedElement = ((PsiReferenceExpression)element).getReferenceNameElement();
            String string = text = referencedElement != null ? referencedElement.getText() : "";
            if (resolve == null && text.length() > 0 && Character.isUpperCase(text.charAt(0))) {
                return element.getText();
            }
            return text;
        }
        return super.getMeaningfulText(element);
    }

    @Override
    public PsiElement updateCurrentNode(PsiElement targetNode) {
        if (targetNode instanceof PsiCodeBlock && ((PsiCodeBlock)targetNode).getStatements().length == 1) {
            PsiElement targetNodeParent = targetNode.getParent();
            if (targetNodeParent instanceof PsiBlockStatement) {
                targetNodeParent = targetNodeParent.getParent();
            }
            if (targetNodeParent instanceof PsiIfStatement || targetNodeParent instanceof PsiLoopStatement) {
                targetNode = targetNodeParent;
            }
        }
        return targetNode;
    }

    @Override
    public PsiElement extendMatchedByDownUp(PsiElement targetNode) {
        PsiElement parent;
        if (targetNode instanceof PsiIdentifier && ((parent = (targetNode = targetNode.getParent()).getParent()) instanceof PsiTypeElement || parent instanceof PsiStatement)) {
            targetNode = parent;
        }
        return targetNode;
    }

    @Override
    public PsiElement extendMatchOnePsiFile(PsiElement file) {
        if (file instanceof PsiIdentifier) {
            file = file.getParent();
        }
        return file;
    }

    @Override
    public void compile(PsiElement[] elements, @NotNull GlobalCompilingVisitor globalVisitor) {
        if (globalVisitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalVisitor", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "compile"));
        }
        elements[0].getParent().accept((PsiElementVisitor)new JavaCompilingVisitor(globalVisitor));
    }

    @Override
    @NotNull
    public PsiElementVisitor createMatchingVisitor(@NotNull GlobalMatchingVisitor globalVisitor) {
        if (globalVisitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalVisitor", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "createMatchingVisitor"));
        }
        JavaMatchingVisitor javaMatchingVisitor = new JavaMatchingVisitor(globalVisitor);
        if (javaMatchingVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "createMatchingVisitor"));
        }
        return javaMatchingVisitor;
    }

    @Override
    @NotNull
    public PsiElementVisitor getLexicalNodesFilter(@NotNull LexicalNodesFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "getLexicalNodesFilter"));
        }
        if (this.myJavaLexicalNodesFilter == null) {
            this.myJavaLexicalNodesFilter = new JavaLexicalNodesFilter(filter);
        }
        JavaLexicalNodesFilter javaLexicalNodesFilter = this.myJavaLexicalNodesFilter;
        if (javaLexicalNodesFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "getLexicalNodesFilter"));
        }
        return javaLexicalNodesFilter;
    }

    @Override
    @NotNull
    public CompiledPattern createCompiledPattern() {
        JavaCompiledPattern javaCompiledPattern = new JavaCompiledPattern();
        if (javaCompiledPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "createCompiledPattern"));
        }
        return javaCompiledPattern;
    }

    @Override
    public boolean isMyLanguage(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "isMyLanguage"));
        }
        return language == JavaLanguage.INSTANCE;
    }

    @Override
    public StructuralReplaceHandler getReplaceHandler(@NotNull ReplacementContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "getReplaceHandler"));
        }
        return new JavaReplaceHandler(context);
    }

    @Override
    @NotNull
    public PsiElement[] createPatternTree(@NotNull String text, @NotNull PatternTreeContext context, @NotNull FileType fileType, @Nullable Language language, String contextName, @Nullable String extension, @NotNull Project project, boolean physical) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "createPatternTree"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "createPatternTree"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "createPatternTree"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "createPatternTree"));
        }
        if (physical) {
            throw new UnsupportedOperationException(this.getClass() + " cannot create physical PSI");
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        if (context == PatternTreeContext.Block) {
            PsiStatement element = elementFactory.createStatementFromText("{\n" + text + "\n}", null);
            PsiElement[] children = ((PsiBlockStatement)element).getCodeBlock().getChildren();
            int extraChildCount = 4;
            if (children.length > 4) {
                PsiElement[] result = new PsiElement[children.length - 4];
                int extraChildStart = 2;
                System.arraycopy(children, 2, result, 0, children.length - 4);
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "createPatternTree"));
                }
                return result;
            }
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "createPatternTree"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (context == PatternTreeContext.Class) {
            PsiElement endChild;
            PsiStatement element = elementFactory.createStatementFromText("class A {\n" + text + "\n}", null);
            PsiClass clazz = (PsiClass)((PsiDeclarationStatement)element).getDeclaredElements()[0];
            PsiElement startChild = clazz.getLBrace();
            if (startChild != null) {
                startChild = startChild.getNextSibling();
            }
            if ((endChild = clazz.getRBrace()) != null) {
                endChild = endChild.getPrevSibling();
            }
            if (startChild == endChild) {
                if (PsiElement.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "createPatternTree"));
                }
                return PsiElement.EMPTY_ARRAY;
            }
            ArrayList<PsiElement> result = new ArrayList<PsiElement>(3);
            assert (startChild != null);
            for (PsiElement el = startChild.getNextSibling(); el != endChild && el != null; el = el.getNextSibling()) {
                if (el instanceof PsiErrorElement) continue;
                result.add(el);
            }
            PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(result);
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "createPatternTree"));
            }
            return psiElementArray;
        }
        PsiElement[] psiElementArray = PsiFileFactory.getInstance((Project)project).createFileFromText("__dummy.java", text).getChildren();
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "createPatternTree"));
        }
        return psiElementArray;
    }

    @Override
    @NotNull
    public Editor createEditor(@NotNull SearchContext searchContext, @NotNull FileType fileType, Language dialect, String text, boolean useLastConfiguration) {
        Editor selectedEditor;
        if (searchContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchContext", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "createEditor"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "createEditor"));
        }
        PsiFile element = searchContext.getFile();
        if (element != null && !useLastConfiguration && (selectedEditor = FileEditorManager.getInstance((Project)searchContext.getProject()).getSelectedTextEditor()) != null) {
            int caretPosition = selectedEditor.getCaretModel().getOffset();
            PsiElement positionedElement = searchContext.getFile().findElementAt(caretPosition);
            if (positionedElement == null) {
                positionedElement = searchContext.getFile().findElementAt(caretPosition + 1);
            }
            if (positionedElement != null) {
                element = PsiTreeUtil.getParentOfType((PsiElement)positionedElement, (Class[])new Class[]{PsiClass.class, PsiCodeBlock.class});
            }
        }
        PsiManager psimanager = PsiManager.getInstance((Project)searchContext.getProject());
        Project project = psimanager.getProject();
        PsiCodeFragment file = this.createCodeFragment(project, text, (PsiElement)element);
        Document doc = PsiDocumentManager.getInstance((Project)searchContext.getProject()).getDocument((PsiFile)file);
        DaemonCodeAnalyzer.getInstance((Project)searchContext.getProject()).setHighlightingEnabled((PsiFile)file, false);
        Editor editor = UIUtil.createEditor(doc, searchContext.getProject(), true, true, this.getTemplateContextType());
        if (editor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "createEditor"));
        }
        return editor;
    }

    @Override
    public Class<? extends TemplateContextType> getTemplateContextTypeClass() {
        return JavaCodeContextType.class;
    }

    @Override
    public PsiCodeFragment createCodeFragment(Project project, String text, PsiElement context) {
        JavaCodeFragmentFactory factory = JavaCodeFragmentFactory.getInstance((Project)project);
        return factory.createCodeBlockCodeFragment(text, context, true);
    }

    @Override
    public void checkSearchPattern(Project project, MatchOptions options) {
        class ValidatingVisitor
        extends JavaRecursiveElementWalkingVisitor {
            private PsiElement myCurrent;

            ValidatingVisitor() {
            }

            public void visitAnnotation(PsiAnnotation annotation) {
                PsiJavaCodeReferenceElement nameReferenceElement = annotation.getNameReferenceElement();
                if (nameReferenceElement == null || !nameReferenceElement.getText().equals("Modifier")) {
                    return;
                }
                for (PsiNameValuePair pair : annotation.getParameterList().getAttributes()) {
                    PsiAnnotationMemberValue value = pair.getValue();
                    if (value instanceof PsiArrayInitializerMemberValue) {
                        for (PsiAnnotationMemberValue v : ((PsiArrayInitializerMemberValue)value).getInitializers()) {
                            String name = StringUtil.stripQuotesAroundValue((String)v.getText());
                            this.checkModifier(name);
                        }
                        continue;
                    }
                    if (value == null) continue;
                    String name = StringUtil.stripQuotesAroundValue((String)value.getText());
                    this.checkModifier(name);
                }
            }

            private void checkModifier(String name) {
                if (!"Instance".equals(name) && !"packageLocal".equals(name) && Arrays.binarySearch(JavaMatchingVisitor.MODIFIERS, name) < 0) {
                    throw new MalformedPatternException(SSRBundle.message("invalid.modifier.type", name));
                }
            }

            public void visitErrorElement(PsiErrorElement element) {
                super.visitErrorElement(element);
            }

            public void setCurrent(PsiElement current) {
                this.myCurrent = current;
            }
        }
        ValidatingVisitor visitor = new ValidatingVisitor();
        CompiledPattern compiledPattern = PatternCompiler.compilePattern(project, options);
        int nodeCount = compiledPattern.getNodeCount();
        NodeIterator nodes = compiledPattern.getNodes();
        while (nodes.hasNext()) {
            PsiElement current = nodes.current();
            visitor.setCurrent(nodeCount == 1 && current instanceof PsiExpressionStatement ? current : null);
            current.accept((PsiElementVisitor)visitor);
            nodes.advance();
        }
        nodes.reset();
    }

    @Override
    public void checkReplacementPattern(Project project, ReplaceOptions options) {
        boolean replaceIsExpression;
        MatchOptions matchOptions = options.getMatchOptions();
        FileType fileType = matchOptions.getFileType();
        PsiElement[] statements = MatcherImplUtil.createTreeFromText(matchOptions.getSearchPattern(), PatternTreeContext.Block, fileType, project);
        boolean searchIsExpression = statements.length == 1 && statements[0].getLastChild() instanceof PsiErrorElement;
        PsiElement[] statements2 = MatcherImplUtil.createTreeFromText(options.getReplacement(), PatternTreeContext.Block, fileType, project);
        boolean bl = replaceIsExpression = statements2.length == 1 && statements2[0].getLastChild() instanceof PsiErrorElement;
        if (searchIsExpression && statements[0].getFirstChild() instanceof PsiModifierList && statements2.length == 0) {
            return;
        }
        if (searchIsExpression != replaceIsExpression) {
            throw new UnsupportedPatternException(searchIsExpression ? SSRBundle.message("replacement.template.is.not.expression.error.message", new Object[0]) : SSRBundle.message("search.template.is.not.expression.error.message", new Object[0]));
        }
    }

    @Override
    public LanguageFileType getDefaultFileType(LanguageFileType currentDefaultFileType) {
        return StdFileTypes.JAVA;
    }

    @Override
    Configuration[] getPredefinedTemplates() {
        return JavaPredefinedConfigurations.createPredefinedTemplates();
    }

    @Override
    public void provideAdditionalReplaceOptions(@NotNull PsiElement node, final ReplaceOptions options, final ReplacementBuilder builder) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "provideAdditionalReplaceOptions"));
        }
        final String templateText = TemplateManager.getInstance(node.getProject()).createTemplate("", "", options.getReplacement()).getTemplateText();
        node.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                this.visitElement((PsiElement)expression);
            }

            public void visitClass(PsiClass aClass) {
                super.visitClass(aClass);
                MatchVariableConstraint constraint = options.getMatchOptions().getVariableConstraint("__class_unmatched__");
                if (constraint != null) {
                    ParameterInfo e = new ParameterInfo();
                    e.setName("__class_unmatched__");
                    e.setStartIndex(templateText.lastIndexOf(125));
                    builder.addParametrization(e);
                }
            }

            public void visitParameter(PsiParameter parameter) {
                super.visitParameter(parameter);
                String name = parameter.getName();
                String type = parameter.getType().getCanonicalText();
                if (StructuralSearchUtil.isTypedVariable(name)) {
                    name = Replacer.stripTypedVariableDecoration(name);
                    if (StructuralSearchUtil.isTypedVariable(type)) {
                        type = Replacer.stripTypedVariableDecoration(type);
                    }
                    ParameterInfo nameInfo = builder.findParameterization(name);
                    ParameterInfo typeInfo = builder.findParameterization(type);
                    PsiElement scope = parameter.getDeclarationScope();
                    if (nameInfo != null && typeInfo != null && !(scope instanceof PsiCatchSection) && !(scope instanceof PsiForeachStatement)) {
                        nameInfo.setArgumentContext(false);
                        typeInfo.setArgumentContext(false);
                        typeInfo.setMethodParameterContext(true);
                        nameInfo.setMethodParameterContext(true);
                        typeInfo.setElement((PsiElement)parameter.getTypeElement());
                    }
                }
            }
        });
    }

    @Override
    public int handleSubstitution(ParameterInfo info, MatchResult match, StringBuilder result, int offset, HashMap<String, MatchResult> matchMap) {
        if (info.getName().equals(match.getName())) {
            String replacementString = match.getMatchImage();
            boolean forceAddingNewLine = false;
            if (info.isMethodParameterContext()) {
                StringBuilder buf = new StringBuilder();
                JavaStructuralSearchProfile.handleMethodParameter(buf, info, matchMap);
                replacementString = buf.toString();
            } else if (match.getAllSons().size() > 0 && !match.isScopeMatch()) {
                StringBuilder buf = new StringBuilder();
                MatchResult r = null;
                for (MatchResult matchResult : match.getAllSons()) {
                    MatchResult previous = r;
                    r = matchResult;
                    PsiElement currentElement = r.getMatch();
                    if (buf.length() > 0) {
                        PsiElement prevSibling;
                        PsiElement parent = currentElement.getParent();
                        if (parent instanceof PsiVariable) {
                            prevSibling = PsiTreeUtil.skipSiblingsBackward((PsiElement)parent, (Class[])new Class[]{PsiWhiteSpace.class});
                            if (prevSibling instanceof PsiJavaToken && JavaTokenType.COMMA.equals(((PsiJavaToken)prevSibling).getTokenType())) {
                                buf.append(',');
                            }
                        } else if (info.isStatementContext()) {
                            PsiElement prevSibling2;
                            PsiElement previousElement = previous.getMatchRef().getElement();
                            if (!(previousElement instanceof PsiComment) && (buf.charAt(buf.length() - 1) != '}' || previousElement instanceof PsiDeclarationStatement)) {
                                buf.append(';');
                            }
                            if ((prevSibling2 = currentElement.getPrevSibling()) instanceof PsiWhiteSpace && prevSibling2.getPrevSibling() == previous.getMatch()) {
                                buf.append(prevSibling2.getText());
                            } else {
                                buf.append('\n');
                            }
                        } else if (info.isArgumentContext()) {
                            buf.append(',');
                        } else if (parent instanceof PsiClass) {
                            prevSibling = PsiTreeUtil.skipSiblingsBackward((PsiElement)currentElement, (Class[])new Class[]{PsiWhiteSpace.class});
                            if (prevSibling instanceof PsiJavaToken && JavaTokenType.COMMA.equals(((PsiJavaToken)prevSibling).getTokenType())) {
                                buf.append(',');
                            } else {
                                buf.append('\n');
                            }
                        } else if (parent instanceof PsiReferenceList) {
                            buf.append(',');
                        } else if (parent instanceof PsiPolyadicExpression) {
                            PsiPolyadicExpression expression = (PsiPolyadicExpression)parent;
                            PsiJavaToken token = expression.getTokenBeforeOperand(expression.getOperands()[1]);
                            if (token != null) {
                                buf.append(token.getText());
                            }
                        } else {
                            buf.append(' ');
                        }
                    }
                    buf.append(r.getMatchImage());
                    JavaStructuralSearchProfile.removeExtraSemicolonForSingleVarInstanceInMultipleMatch(info, r, buf);
                    forceAddingNewLine = currentElement instanceof PsiComment;
                }
                replacementString = buf.toString();
            } else {
                if (info.isStatementContext()) {
                    forceAddingNewLine = match.getMatch() instanceof PsiComment;
                }
                StringBuilder buf = new StringBuilder(replacementString);
                JavaStructuralSearchProfile.removeExtraSemicolonForSingleVarInstanceInMultipleMatch(info, match, buf);
                replacementString = buf.toString();
            }
            offset = Replacer.insertSubstitution(result, offset, info, replacementString);
            offset = JavaStructuralSearchProfile.removeExtraSemicolon(info, offset, result, match);
            if (forceAddingNewLine && info.isStatementContext()) {
                result.insert(info.getStartIndex() + offset + 1, '\n');
                ++offset;
            }
        }
        return offset;
    }

    @Override
    public int handleNoSubstitution(ParameterInfo info, int offset, StringBuilder result) {
        PsiElement element = info.getElement();
        PsiElement prevSibling = PsiTreeUtil.skipSiblingsBackward((PsiElement)element, (Class[])new Class[]{PsiWhiteSpace.class});
        if (prevSibling instanceof PsiJavaToken && JavaStructuralSearchProfile.isRemovableToken(prevSibling)) {
            int start = info.getBeforeDelimiterPos() + offset - (prevSibling.getTextLength() - 1);
            int end = info.getStartIndex() + offset;
            result.delete(start, end);
            return offset - (end - start);
        }
        PsiElement nextSibling = PsiTreeUtil.skipSiblingsForward((PsiElement)element, (Class[])new Class[]{PsiWhiteSpace.class});
        if (nextSibling instanceof PsiJavaToken && JavaStructuralSearchProfile.isRemovableToken(nextSibling)) {
            int start = info.getStartIndex() + offset;
            int end = info.getAfterDelimiterPos() + nextSibling.getTextLength() + offset;
            result.delete(start, end);
            return offset - 1;
        }
        if (element == null || !(element.getParent() instanceof PsiForStatement)) {
            return JavaStructuralSearchProfile.removeExtraSemicolon(info, offset, result, null);
        }
        return offset;
    }

    private static boolean isRemovableToken(PsiElement element) {
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiAnnotationParameterList || parent instanceof PsiAssertStatement || parent instanceof PsiExpressionList || parent instanceof PsiParameterList || parent instanceof PsiPolyadicExpression || parent instanceof PsiReferenceList || parent instanceof PsiReferenceParameterList || parent instanceof PsiResourceList || parent instanceof PsiTypeParameterList || parent instanceof PsiVariable)) {
            return false;
        }
        String text = element.getText();
        if (text.length() != 1) {
            return true;
        }
        switch (text.charAt(0)) {
            case '(': 
            case ')': 
            case '<': 
            case '>': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isIdentifier(PsiElement element) {
        return element instanceof PsiIdentifier;
    }

    @Override
    public Collection<String> getReservedWords() {
        return Collections.singleton("packageLocal");
    }

    @Override
    public boolean isDocCommentOwner(PsiElement match) {
        return match instanceof PsiMember;
    }

    private static void handleMethodParameter(StringBuilder buf, ParameterInfo info, HashMap<String, MatchResult> matchMap) {
        if (!(info.getElement() instanceof PsiTypeElement)) {
            return;
        }
        String name = ((PsiParameter)info.getElement().getParent()).getName();
        name = StructuralSearchUtil.isTypedVariable(name) ? Replacer.stripTypedVariableDecoration(name) : name;
        MatchResult matchResult = matchMap.get(name);
        if (matchResult == null) {
            return;
        }
        if (matchResult.isMultipleMatch()) {
            for (MatchResult result : matchResult.getAllSons()) {
                if (buf.length() > 0) {
                    buf.append(',');
                }
                JavaStructuralSearchProfile.appendParameter(buf, result);
            }
        } else {
            JavaStructuralSearchProfile.appendParameter(buf, matchResult);
        }
    }

    private static void appendParameter(StringBuilder buf, MatchResult _matchResult) {
        Iterator<MatchResult> j = _matchResult.getAllSons().iterator();
        while (j.hasNext()) {
            buf.append(j.next().getMatchImage()).append(' ').append(j.next().getMatchImage());
        }
    }

    private static void removeExtraSemicolonForSingleVarInstanceInMultipleMatch(ParameterInfo info, MatchResult r, StringBuilder buf) {
        if (info.isStatementContext()) {
            PsiElement element = r.getMatchRef().getElement();
            if (buf.charAt(buf.length() - 1) == ';' && r.getMatchImage().charAt(r.getMatchImage().length() - 1) == ';' && (element instanceof PsiReturnStatement || element instanceof PsiDeclarationStatement || element instanceof PsiExpressionStatement || element instanceof PsiAssertStatement || element instanceof PsiBreakStatement || element instanceof PsiContinueStatement || element instanceof PsiMember || element instanceof PsiIfStatement && !(((PsiIfStatement)element).getThenBranch() instanceof PsiBlockStatement) || element instanceof PsiLoopStatement && !(((PsiLoopStatement)element).getBody() instanceof PsiBlockStatement))) {
                buf.deleteCharAt(buf.length() - 1);
            }
        }
    }

    private static int removeExtraSemicolon(ParameterInfo info, int offset, StringBuilder result, MatchResult match) {
        int index;
        if (info.isStatementContext() && result.charAt(index = offset + info.getStartIndex()) == ';' && (match == null || result.charAt(index - 1) == '}' && !(match.getMatch() instanceof PsiDeclarationStatement) && !(match.getMatch() instanceof PsiNewExpression) || !match.isMultipleMatch() && match.getMatch() instanceof PsiComment || match.isMultipleMatch() && match.getAllSons().get(match.getAllSons().size() - 1).getMatch() instanceof PsiComment)) {
            result.deleteCharAt(index);
            --offset;
        }
        return offset;
    }
}

