/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.RegexpFilter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.MacroManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.tools.FilterInfo;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolProcessAdapter;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ToolRunProfile
implements ModuleRunProfile {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.tools.ToolRunProfile");
    private final Tool myTool;
    private final DataContext myContext;
    private final GeneralCommandLine myCommandLine;

    public ToolRunProfile(Tool tool, DataContext context) {
        this.myTool = tool;
        this.myContext = context;
        this.myCommandLine = this.myTool.createCommandLine(context);
    }

    public String getName() {
        return ToolRunProfile.expandMacrosInName(this.myTool, this.myContext);
    }

    public static String expandMacrosInName(Tool tool, DataContext context) {
        String name = tool.getName();
        try {
            return MacroManager.getInstance().expandMacrosInString(name, true, context);
        }
        catch (Macro.ExecutionCancelledException e) {
            LOG.info((Throwable)e);
            return name;
        }
    }

    public Icon getIcon() {
        return null;
    }

    @NotNull
    public Module[] getModules() {
        if (Module.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tools/ToolRunProfile", "getModules"));
        }
        return Module.EMPTY_ARRAY;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) {
        FilterInfo[] outputFilters;
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/tools/ToolRunProfile", "getState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/tools/ToolRunProfile", "getState"));
        }
        final Project project = env.getProject();
        if (this.myCommandLine == null) {
            return null;
        }
        CommandLineState commandLineState = new CommandLineState(env){

            GeneralCommandLine createCommandLine() {
                return ToolRunProfile.this.myCommandLine;
            }

            @NotNull
            protected OSProcessHandler startProcess() throws ExecutionException {
                GeneralCommandLine commandLine = this.createCommandLine();
                ColoredProcessHandler processHandler2 = new ColoredProcessHandler(commandLine.createProcess(), commandLine.getCommandLineString());
                ProcessTerminatedListener.attach((ProcessHandler)processHandler2);
                ColoredProcessHandler coloredProcessHandler = processHandler2;
                if (coloredProcessHandler == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tools/ToolRunProfile$1", "startProcess"));
                }
                return coloredProcessHandler;
            }

            @NotNull
            public ExecutionResult execute(final @NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/tools/ToolRunProfile$1", "execute"));
                }
                if (runner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/intellij/tools/ToolRunProfile$1", "execute"));
                }
                ExecutionResult result = super.execute(executor, runner);
                final ProcessHandler processHandler2 = result.getProcessHandler();
                if (processHandler2 != null) {
                    processHandler2.addProcessListener((ProcessListener)new ToolProcessAdapter(project, ToolRunProfile.this.myTool.synchronizeAfterExecution(), ToolRunProfile.this.getName()));
                    processHandler2.addProcessListener((ProcessListener)new ProcessAdapter(){

                        public void onTextAvailable(ProcessEvent event, Key outputType) {
                            if (outputType == ProcessOutputTypes.STDOUT && ToolRunProfile.this.myTool.isShowConsoleOnStdOut() || outputType == ProcessOutputTypes.STDERR && ToolRunProfile.this.myTool.isShowConsoleOnStdErr()) {
                                ExecutionManager.getInstance((Project)project).getContentManager().toFrontRunContent(executor, processHandler2);
                            }
                        }
                    });
                }
                ExecutionResult executionResult = result;
                if (executionResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tools/ToolRunProfile$1", "execute"));
                }
                return executionResult;
            }
        };
        TextConsoleBuilder builder = TextConsoleBuilderFactory.getInstance().createBuilder(project);
        for (FilterInfo outputFilter : outputFilters = this.myTool.getOutputFilters()) {
            builder.addFilter((Filter)new RegexpFilter(project, outputFilter.getRegExp()));
        }
        commandLineState.setConsoleBuilder(builder);
        return commandLineState;
    }
}

