/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ExpirableRunnable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.FocusCommand;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ex.LayoutFocusTraversalPolicyExt;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.containers.WeakKeyWeakValueHashMap;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FocusTrackback {
    private static final Logger LOG = Logger.getInstance((String)"FocusTrackback");
    private Window myParentWindow;
    private Window myRoot;
    private WeakReference<Component> myFocusOwner;
    private WeakReference<Component> myLocalFocusOwner;
    private static final Map<Window, List<FocusTrackback>> ourRootWindowToParentsStack = new WeakHashMap<Window, List<FocusTrackback>>();
    private static final Map<Window, Component> ourRootWindowToFocusedMap = new WeakKeyWeakValueHashMap();
    private final String myRequestorName;
    private ComponentQuery myFocusedComponentQuery;
    private boolean myMustBeShown;
    private boolean myConsumed;
    private final WeakReference myRequestor;
    private boolean mySheduledForRestore;
    private boolean myWillBeSheduledForRestore;
    private boolean myForcedRestore;

    public FocusTrackback(@NotNull Object requestor, Component parent, boolean mustBeShown) {
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/ui/FocusTrackback", "<init>"));
        }
        this(requestor, parent == null ? null : UIUtil.getWindow((Component)parent), mustBeShown);
    }

    public FocusTrackback(@NotNull Object requestor, Window parent, boolean mustBeShown) {
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/ui/FocusTrackback", "<init>"));
        }
        this.myFocusOwner = new WeakReference<Object>(null);
        this.myLocalFocusOwner = new WeakReference<Object>(null);
        this.myRequestor = new WeakReference<Object>(requestor);
        this.myRequestorName = requestor.toString();
        this.myParentWindow = parent;
        this.myMustBeShown = mustBeShown;
        Application app = ApplicationManager.getApplication();
        if (app == null || app.isHeadlessEnvironment() || FocusTrackback.wrongOS()) {
            return;
        }
        this.register(parent);
        List<FocusTrackback> stack = FocusTrackback.getStackForRoot(this.myRoot);
        int index = stack.indexOf(this);
        assert (index >= 0) : this.myRequestorName;
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        this.setLocalFocusOwner(manager.getPermanentFocusOwner());
        IdeFocusManager fm = IdeFocusManager.getGlobalInstance();
        if (this.myLocalFocusOwner.get() == null && fm.isFocusBeingTransferred() && index > 0) {
            for (int eachIndex = index - 1; eachIndex > 0; --eachIndex) {
                Component component;
                FocusTrackback each = stack.get(eachIndex);
                if (each.isConsumed() || (component = (Component)each.myLocalFocusOwner.get()) == null) continue;
                this.setLocalFocusOwner(component);
                break;
            }
        }
        if (index == 0) {
            FocusTrackback other;
            Window window;
            this.setFocusOwner(manager.getPermanentFocusOwner());
            if (this.getFocusOwner() == null && (window = manager.getActiveWindow()) instanceof Provider && (other = ((Provider)((Object)window)).getFocusTrackback()) != null) {
                this.setFocusOwner(other.getFocusOwner());
            }
        } else {
            this.setFocusOwner(stack.get(0).getFocusOwner());
        }
        if (stack.size() == 1 && this.getFocusOwner() == null) {
            this.setFocusOwner(FocusTrackback.getFocusFor(this.myRoot));
        } else if (index == 0 && this.getFocusOwner() != null) {
            FocusTrackback.setFocusFor(this.myRoot, this.getFocusOwner());
        }
    }

    private void setLocalFocusOwner(Component component) {
        this.myLocalFocusOwner = new WeakReference<Component>(component);
    }

    public static Component getFocusFor(Window parent) {
        return ourRootWindowToFocusedMap.get(parent);
    }

    private static void setFocusFor(Window parent, Component focus) {
        ourRootWindowToFocusedMap.put(parent, focus);
    }

    private static boolean wrongOS() {
        return false;
    }

    public void registerFocusComponent(final @NotNull Component focusedComponent) {
        if (focusedComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "focusedComponent", "com/intellij/ui/FocusTrackback", "registerFocusComponent"));
        }
        this.registerFocusComponent(new ComponentQuery(){

            @Override
            public Component getComponent() {
                return focusedComponent;
            }
        });
    }

    public void registerFocusComponent(@NotNull ComponentQuery query) {
        if (query == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/ui/FocusTrackback", "registerFocusComponent"));
        }
        this.myFocusedComponentQuery = query;
    }

    private void register(Window parent) {
        this.myRoot = FocusTrackback.findUtlimateParent(parent);
        List<FocusTrackback> stack = this.getCleanStackForRoot();
        stack.remove(this);
        stack.add(this);
    }

    private List<FocusTrackback> getCleanStackForRoot() {
        return FocusTrackback.getCleanStackForRoot(this.myRoot);
    }

    private static List<FocusTrackback> getCleanStackForRoot(Window root) {
        FocusTrackback[] stackArray;
        List<FocusTrackback> stack = FocusTrackback.getStackForRoot(root);
        for (FocusTrackback eachExisting : stackArray = stack.toArray(new FocusTrackback[stack.size()])) {
            if (eachExisting != null && eachExisting.isConsumed()) {
                eachExisting.dispose();
                continue;
            }
            if (eachExisting != null) continue;
            stack.remove(eachExisting);
        }
        return stack;
    }

    public void restoreFocus() {
        Application app = ApplicationManager.getApplication();
        if (app == null || FocusTrackback.wrongOS() || this.myConsumed || this.isSheduledForRestore()) {
            return;
        }
        Project project = null;
        DataManager dataManager = DataManager.getInstance();
        if (dataManager != null) {
            DataContext context;
            DataContext dataContext = context = this.myParentWindow == null ? dataManager.getDataContext() : dataManager.getDataContext((Component)this.myParentWindow);
            if (context != null) {
                project = (Project)CommonDataKeys.PROJECT.getData(context);
            }
        }
        this.mySheduledForRestore = true;
        List<FocusTrackback> stack = this.getCleanStackForRoot();
        int index = stack.indexOf(this);
        for (int i = index - 1; i >= 0; --i) {
            if (!stack.get(i).isSheduledForRestore()) continue;
            this.dispose();
            return;
        }
        if (project != null && !project.isDisposed()) {
            final IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)project);
            this.cleanParentWindow();
            final Project finalProject = project;
            focusManager.requestFocus((FocusCommand)new MyFocusCommand(), this.myForcedRestore).doWhenProcessed(new Runnable(){

                @Override
                public void run() {
                    FocusTrackback.this.dispose();
                }
            }).doWhenRejected(new Runnable(){

                @Override
                public void run() {
                    focusManager.revalidateFocus((ExpirableRunnable)new ExpirableRunnable.ForProject(finalProject){

                        public void run() {
                            if (UIUtil.isMeaninglessFocusOwner((Component)focusManager.getFocusOwner())) {
                                focusManager.requestDefaultFocus(false);
                            }
                        }
                    });
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FocusTrackback.this._restoreFocus();
                    FocusTrackback.this.dispose();
                }
            });
        }
    }

    private ActionCallback _restoreFocus() {
        List<FocusTrackback> stack = this.getCleanStack();
        if (!stack.contains(this)) {
            return ActionCallback.REJECTED;
        }
        Component toFocus = FocusTrackback.queryToFocus(stack, this, true);
        ActionCallback result = new ActionCallback();
        if (toFocus != null) {
            Window ownerBySwingWindow;
            Component ownerBySwing = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (ownerBySwing != null && (ownerBySwingWindow = SwingUtilities.getWindowAncestor(ownerBySwing)) != null && ownerBySwingWindow == SwingUtilities.getWindowAncestor(toFocus) && !UIUtil.isMeaninglessFocusOwner((Component)ownerBySwing)) {
                toFocus = ownerBySwing;
            }
            if (this.myParentWindow != null) {
                Window to = UIUtil.getWindow((Component)toFocus);
                if (to != null && UIUtil.findUltimateParent((Component)to) == UIUtil.findUltimateParent((Component)this.myParentWindow)) {
                    this.requestFocus(toFocus);
                    result.setDone();
                }
            } else {
                this.requestFocus(toFocus);
                result.setDone();
            }
        }
        if (!result.isDone()) {
            result.setRejected();
        }
        stack.remove(this);
        this.dispose();
        return result;
    }

    private void requestFocus(Component toFocus) {
        if (this.myForcedRestore) {
            toFocus.requestFocus();
        } else {
            toFocus.requestFocusInWindow();
        }
    }

    private static Component queryToFocus(List<FocusTrackback> stack, FocusTrackback trackback, boolean mustBeLastInStack) {
        int index = stack.indexOf(trackback);
        Component toFocus = null;
        Component focusOwner = (Component)trackback.myLocalFocusOwner.get();
        if (focusOwner != null && UIUtil.isMeaninglessFocusOwner((Component)(toFocus = focusOwner))) {
            toFocus = null;
        }
        if (toFocus == null) {
            ComponentQuery query;
            toFocus = index > 0 ? ((query = stack.get((int)(index - 1)).myFocusedComponentQuery) != null ? query.getComponent() : null) : trackback.getFocusOwner();
        }
        if (mustBeLastInStack) {
            for (int i = index + 1; i < stack.size(); ++i) {
                if (!stack.get(i).isMustBeShown()) {
                    if (!stack.get(i).isSheduledForRestore() && !stack.get(i).isWillBeSheduledForRestore() || stack.get(i).isConsumed()) continue;
                    toFocus = null;
                    break;
                }
                if (stack.get(i).isConsumed()) continue;
                toFocus = null;
                break;
            }
        }
        return toFocus;
    }

    private List<FocusTrackback> getCleanStack() {
        FocusTrackback[] all2;
        List<FocusTrackback> stack = FocusTrackback.getStackForRoot(this.myRoot);
        for (FocusTrackback each : all2 = stack.toArray(new FocusTrackback[stack.size()])) {
            if (each != null && (each == this || !each.isConsumed())) continue;
            stack.remove(each);
        }
        return stack;
    }

    private static List<FocusTrackback> getStackForRoot(Window root) {
        List<FocusTrackback> stack = ourRootWindowToParentsStack.get(root);
        if (stack == null) {
            stack = new ArrayList<FocusTrackback>();
            ourRootWindowToParentsStack.put(root, stack);
        }
        return stack;
    }

    @Nullable
    private static Window findUtlimateParent(Window parent) {
        Container next;
        Window root;
        Window window = root = parent == null ? JOptionPane.getRootFrame() : parent;
        while (root != null && (next = root.getParent()) != null) {
            Window nextWindow;
            if (next instanceof Window) {
                root = (Window)next;
            }
            if ((nextWindow = SwingUtilities.getWindowAncestor(next)) == null) break;
            root = nextWindow;
        }
        return root;
    }

    @Nullable
    public Component getFocusOwner() {
        return (Component)this.myFocusOwner.get();
    }

    public String toString() {
        return this.getClass().getName() + " requestor: " + this.myRequestorName + " parent=" + this.myParentWindow;
    }

    public void dispose() {
        FocusTraversalPolicy policy;
        this.consume();
        FocusTrackback.getStackForRoot(this.myRoot).remove(this);
        this.mySheduledForRestore = false;
        if (this.myParentWindow != null && (policy = this.myParentWindow.getFocusTraversalPolicy()) instanceof LayoutFocusTraversalPolicyExt) {
            ((LayoutFocusTraversalPolicyExt)policy).setNoDefaultComponent(false, this);
        }
        this.myParentWindow = null;
        this.myRoot = null;
        this.myFocusOwner.clear();
        this.myLocalFocusOwner.clear();
    }

    private boolean isConsumed() {
        if (this.myConsumed) {
            return true;
        }
        if (this.myMustBeShown) {
            return !this.isSheduledForRestore() && this.myFocusedComponentQuery != null && this.myFocusedComponentQuery.getComponent() != null && !this.myFocusedComponentQuery.getComponent().isShowing();
        }
        return this.myParentWindow == null || !this.myParentWindow.isShowing();
    }

    public void consume() {
        this.myConsumed = true;
    }

    private void setFocusOwner(Component focusOwner) {
        this.myFocusOwner = new WeakReference<Component>(focusOwner);
    }

    public void setMustBeShown(boolean mustBeShown) {
        this.myMustBeShown = mustBeShown;
    }

    public boolean isMustBeShown() {
        return this.myMustBeShown;
    }

    public static void release(@NotNull JFrame frame) {
        Window[] all2;
        if (frame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frame", "com/intellij/ui/FocusTrackback", "release"));
        }
        for (Window each : all2 = ourRootWindowToParentsStack.keySet().toArray(new Window[ourRootWindowToParentsStack.size()])) {
            if (each == null || each != frame && !SwingUtilities.isDescendingFrom(each, frame)) continue;
            ourRootWindowToParentsStack.remove(each);
        }
        ourRootWindowToFocusedMap.remove(frame);
    }

    public Object getRequestor() {
        return this.myRequestor.get();
    }

    public void setWillBeSheduledForRestore() {
        this.myWillBeSheduledForRestore = true;
    }

    public boolean isSheduledForRestore() {
        return this.mySheduledForRestore;
    }

    public boolean isWillBeSheduledForRestore() {
        return this.myWillBeSheduledForRestore;
    }

    public void setForcedRestore(boolean forcedRestore) {
        this.myForcedRestore = forcedRestore;
    }

    public void cleanParentWindow() {
        if (!Registry.is((String)"focus.fix.lost.cursor")) {
            return;
        }
        if (this.myParentWindow != null) {
            try {
                Method tmpLost = Window.class.getDeclaredMethod("setTemporaryLostComponent", Component.class);
                tmpLost.setAccessible(true);
                tmpLost.invoke((Object)this.myParentWindow, new Object[]{null});
                Method owner = KeyboardFocusManager.class.getDeclaredMethod("setMostRecentFocusOwner", Window.class, Component.class);
                owner.setAccessible(true);
                owner.invoke(null, this.myParentWindow, null);
                FocusTraversalPolicy policy = this.myParentWindow.getFocusTraversalPolicy();
                if (policy instanceof LayoutFocusTraversalPolicyExt) {
                    ((LayoutFocusTraversalPolicyExt)policy).setNoDefaultComponent(true, this);
                }
            }
            catch (Exception e) {
                LOG.debug((Throwable)e);
            }
        }
    }

    @NotNull
    public static List<JBPopup> getChildPopups(@NotNull Component component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ui/FocusTrackback", "getChildPopups"));
        }
        ArrayList<JBPopup> result = new ArrayList<JBPopup>();
        Window window = UIUtil.getWindow((Component)component);
        if (window == null) {
            ArrayList<JBPopup> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/FocusTrackback", "getChildPopups"));
            }
            return arrayList;
        }
        List<FocusTrackback> stack = FocusTrackback.getCleanStackForRoot(FocusTrackback.findUtlimateParent(window));
        for (FocusTrackback each : stack) {
            if (!each.isChildFor(component) || !(each.getRequestor() instanceof JBPopup)) continue;
            result.add((JBPopup)each.getRequestor());
        }
        ArrayList<JBPopup> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/FocusTrackback", "getChildPopups"));
        }
        return arrayList;
    }

    private boolean isChildFor(Component parent) {
        Component toFocus = FocusTrackback.queryToFocus(this.getCleanStack(), this, false);
        if (toFocus == null) {
            return false;
        }
        if (parent == toFocus) {
            return true;
        }
        if (SwingUtilities.isDescendingFrom(toFocus, parent)) {
            return true;
        }
        Component eachToFocus = this.getFocusOwner();
        FocusTrackback eachTrackback = this;
        while (eachToFocus != null) {
            FocusTrackback newTrackback;
            if (SwingUtilities.isDescendingFrom(eachToFocus, parent)) {
                return true;
            }
            if (!(eachTrackback.getRequestor() instanceof AbstractPopup) || (newTrackback = ((AbstractPopup)eachTrackback.getRequestor()).getFocusTrackback()) == null || eachTrackback == newTrackback || eachTrackback == null || eachTrackback.isConsumed()) break;
            eachTrackback = newTrackback;
            eachToFocus = eachTrackback.getFocusOwner();
        }
        return false;
    }

    private class MyFocusCommand
    extends FocusCommand {
        private MyFocusCommand() {
        }

        @NotNull
        public ActionCallback run() {
            ActionCallback actionCallback = FocusTrackback.this._restoreFocus();
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/FocusTrackback$MyFocusCommand", "run"));
            }
            return actionCallback;
        }

        public String toString() {
            return "focus trackback requestor";
        }
    }

    public static interface ComponentQuery {
        public Component getComponent();
    }

    public static interface Provider {
        public FocusTrackback getFocusTrackback();
    }
}

