/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogDataProvider;
import com.intellij.vcs.log.VcsLogHashMap;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogSettings;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.data.CommitDetailsGetter;
import com.intellij.vcs.log.data.ContainingBranchesGetter;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.MiniDetailsGetter;
import com.intellij.vcs.log.data.VcsLogFilterer;
import com.intellij.vcs.log.data.VcsLogFiltererImpl;
import com.intellij.vcs.log.data.VcsLogHashMapImpl;
import com.intellij.vcs.log.data.VcsLogRefresher;
import com.intellij.vcs.log.data.VcsLogRefresherImpl;
import com.intellij.vcs.log.data.VcsLogUiProperties;
import com.intellij.vcs.log.data.VcsUserRegistryImpl;
import com.intellij.vcs.log.data.VisiblePack;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.util.StopWatch;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogDataHolder
implements Disposable,
VcsLogDataProvider {
    private static final Logger LOG = Logger.getInstance(VcsLogDataHolder.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> myLogProviders;
    @NotNull
    private final BackgroundTaskQueue myDataLoaderQueue;
    @NotNull
    private final MiniDetailsGetter myMiniDetailsGetter;
    @NotNull
    private final CommitDetailsGetter myDetailsGetter;
    @NotNull
    private final VcsLogSettings mySettings;
    private final Map<VirtualFile, VcsUser> myCurrentUser;
    private final Consumer<DataPack> myDataPackUpdateHandler;
    @NotNull
    private final Map<Integer, VcsCommitMetadata> myTopCommitsDetailsCache;
    private final VcsUserRegistryImpl myUserRegistry;
    private final VcsLogHashMapImpl myHashMap;
    private final ContainingBranchesGetter myContainingBranchesGetter;
    @NotNull
    private final VcsLogRefresher myRefresher;
    private final VcsLogFiltererImpl myFilterer;

    public VcsLogDataHolder(@NotNull Project project, @NotNull Disposable parentDisposable, @NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull VcsLogSettings settings, @NotNull VcsLogUiProperties uiProperties, @NotNull Consumer<VisiblePack> visiblePackConsumer) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/data/VcsLogDataHolder", "<init>"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/vcs/log/data/VcsLogDataHolder", "<init>"));
        }
        if (logProviders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logProviders", "com/intellij/vcs/log/data/VcsLogDataHolder", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/vcs/log/data/VcsLogDataHolder", "<init>"));
        }
        if (uiProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiProperties", "com/intellij/vcs/log/data/VcsLogDataHolder", "<init>"));
        }
        if (visiblePackConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visiblePackConsumer", "com/intellij/vcs/log/data/VcsLogDataHolder", "<init>"));
        }
        this.myCurrentUser = ContainerUtil.newHashMap();
        this.myTopCommitsDetailsCache = ContainerUtil.newConcurrentMap();
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myProject = project;
        this.myLogProviders = logProviders;
        this.myDataLoaderQueue = new BackgroundTaskQueue(project, "Loading history...");
        this.mySettings = settings;
        this.myUserRegistry = (VcsUserRegistryImpl)ServiceManager.getService((Project)project, VcsUserRegistry.class);
        try {
            this.myHashMap = new VcsLogHashMapImpl(this.myProject, logProviders);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.myMiniDetailsGetter = new MiniDetailsGetter((VcsLogHashMap)this.myHashMap, logProviders, this.myTopCommitsDetailsCache, (Disposable)this);
        this.myDetailsGetter = new CommitDetailsGetter(this.myHashMap, logProviders, this);
        this.myContainingBranchesGetter = new ContainingBranchesGetter(this, this);
        this.myFilterer = new VcsLogFiltererImpl(this.myProject, this.myLogProviders, this.myHashMap, this.myTopCommitsDetailsCache, this.myDetailsGetter, PermanentGraph.SortType.values()[uiProperties.getBekSortType()], visiblePackConsumer);
        this.myDataPackUpdateHandler = new Consumer<DataPack>(){

            public void consume(DataPack dataPack) {
                VcsLogDataHolder.this.myFilterer.onRefresh(dataPack);
            }
        };
        this.myRefresher = new VcsLogRefresherImpl(this.myProject, this.myHashMap, this.myLogProviders, this.myUserRegistry, this.myTopCommitsDetailsCache, this.myDataPackUpdateHandler, new Consumer<Exception>(){

            public void consume(Exception e) {
                if (!(e instanceof ProcessCanceledException)) {
                    LOG.error((Throwable)e);
                }
            }
        }, this.mySettings.getRecentCommitsCount());
    }

    @NotNull
    public VcsLogFilterer getFilterer() {
        VcsLogFiltererImpl vcsLogFiltererImpl = this.myFilterer;
        if (vcsLogFiltererImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogDataHolder", "getFilterer"));
        }
        return vcsLogFiltererImpl;
    }

    @NotNull
    public Hash getHash(int commitIndex) {
        Hash hash = this.myHashMap.getHash(commitIndex);
        if (hash == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogDataHolder", "getHash"));
        }
        return hash;
    }

    public int getCommitIndex(@NotNull Hash hash) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/data/VcsLogDataHolder", "getCommitIndex"));
        }
        return this.myHashMap.getCommitIndex(hash);
    }

    @NotNull
    public VcsLogHashMapImpl getHashMap() {
        VcsLogHashMapImpl vcsLogHashMapImpl = this.myHashMap;
        if (vcsLogHashMapImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogDataHolder", "getHashMap"));
        }
        return vcsLogHashMapImpl;
    }

    public void initialize() {
        final StopWatch initSw = StopWatch.start("initialize");
        this.myDataLoaderQueue.clear();
        this.runInBackground(new ThrowableConsumer<ProgressIndicator, VcsException>(){

            public void consume(ProgressIndicator indicator) throws VcsException {
                VcsLogDataHolder.this.resetState();
                VcsLogDataHolder.this.readCurrentUser();
                DataPack dataPack = VcsLogDataHolder.this.myRefresher.readFirstBlock();
                VcsLogDataHolder.this.myDataPackUpdateHandler.consume((Object)dataPack);
                initSw.report();
            }
        }, "Loading History...");
    }

    private void readCurrentUser() {
        StopWatch sw = StopWatch.start("readCurrentUser");
        for (Map.Entry<VirtualFile, VcsLogProvider> entry : this.myLogProviders.entrySet()) {
            VirtualFile root = entry.getKey();
            try {
                VcsUser me = entry.getValue().getCurrentUser(root);
                if (me != null) {
                    this.myCurrentUser.put(root, me);
                    continue;
                }
                LOG.info("Username not configured for root " + root);
            }
            catch (VcsException e) {
                LOG.warn("Couldn't read the username from root " + root, (Throwable)e);
            }
        }
        sw.report();
    }

    private void resetState() {
        this.myTopCommitsDetailsCache.clear();
    }

    @NotNull
    public Set<VcsUser> getAllUsers() {
        Set<VcsUser> set = this.myUserRegistry.getUsers();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogDataHolder", "getAllUsers"));
        }
        return set;
    }

    @NotNull
    public Map<VirtualFile, VcsUser> getCurrentUser() {
        Map<VirtualFile, VcsUser> map = this.myCurrentUser;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogDataHolder", "getCurrentUser"));
        }
        return map;
    }

    public boolean isMultiRoot() {
        return this.myLogProviders.size() > 1;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogDataHolder", "getProject"));
        }
        return project;
    }

    @NotNull
    public Collection<VirtualFile> getRoots() {
        Set<VirtualFile> set = this.myLogProviders.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogDataHolder", "getRoots"));
        }
        return set;
    }

    @NotNull
    public Collection<VcsLogProvider> getLogProviders() {
        Collection<VcsLogProvider> collection = this.myLogProviders.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogDataHolder", "getLogProviders"));
        }
        return collection;
    }

    @NotNull
    public VcsLogSettings getSettings() {
        VcsLogSettings vcsLogSettings = this.mySettings;
        if (vcsLogSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogDataHolder", "getSettings"));
        }
        return vcsLogSettings;
    }

    public ContainingBranchesGetter getContainingBranchesGetter() {
        return this.myContainingBranchesGetter;
    }

    private void runInBackground(final ThrowableConsumer<ProgressIndicator, VcsException> task, String title) {
        this.myDataLoaderQueue.run(new Task.Backgroundable(this.myProject, title, false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/vcs/log/data/VcsLogDataHolder$4", "run"));
                }
                indicator.setIndeterminate(true);
                try {
                    task.consume((Object)indicator);
                }
                catch (VcsException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public void refreshCompletely() {
        this.initialize();
    }

    public void refresh(@NotNull Collection<VirtualFile> roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/data/VcsLogDataHolder", "refresh"));
        }
        this.myRefresher.refresh(roots);
    }

    @Nullable
    public VcsCommitMetadata getTopCommitDetails(@NotNull Integer commitId) {
        if (commitId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitId", "com/intellij/vcs/log/data/VcsLogDataHolder", "getTopCommitDetails"));
        }
        return this.myTopCommitsDetailsCache.get(commitId);
    }

    public CommitDetailsGetter getCommitDetailsGetter() {
        return this.myDetailsGetter;
    }

    @NotNull
    public MiniDetailsGetter getMiniDetailsGetter() {
        MiniDetailsGetter miniDetailsGetter = this.myMiniDetailsGetter;
        if (miniDetailsGetter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogDataHolder", "getMiniDetailsGetter"));
        }
        return miniDetailsGetter;
    }

    public void dispose() {
        this.myDataLoaderQueue.clear();
        this.resetState();
    }

    @NotNull
    public VcsLogProvider getLogProvider(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/VcsLogDataHolder", "getLogProvider"));
        }
        VcsLogProvider vcsLogProvider = this.myLogProviders.get(root);
        if (vcsLogProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogDataHolder", "getLogProvider"));
        }
        return vcsLogProvider;
    }

    @NotNull
    public VcsUserRegistryImpl getUserRegistry() {
        VcsUserRegistryImpl vcsUserRegistryImpl = this.myUserRegistry;
        if (vcsUserRegistryImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogDataHolder", "getUserRegistry"));
        }
        return vcsUserRegistryImpl;
    }
}

