/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions;

import com.intellij.execution.actions.ChooseDebugConfigurationPopupAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.AbstractDebuggerSession;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import com.intellij.xdebugger.impl.actions.XDebuggerActionBase;
import org.jetbrains.annotations.NotNull;

public class ResumeAction
extends XDebuggerActionBase
implements DumbAware {
    @Override
    protected boolean isEnabled(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return false;
        }
        boolean haveCurrentSession = false;
        for (DebuggerSupport support : DebuggerSupport.getDebuggerSupports()) {
            AbstractDebuggerSession session = support.getCurrentSession(project);
            if (session == null || session.isStopped()) continue;
            haveCurrentSession = true;
            if (!session.isPaused()) continue;
            return true;
        }
        return !"DebuggerToolbar".equals(e.getPlace()) && !haveCurrentSession;
    }

    @Override
    public void actionPerformed(AnActionEvent e) {
        Project project;
        if (!this.performWithHandler(e) && (project = ResumeAction.getEventProject((AnActionEvent)e)) != null && !DumbService.isDumb((Project)project)) {
            new ChooseDebugConfigurationPopupAction().actionPerformed(e);
        }
    }

    @Override
    @NotNull
    protected DebuggerActionHandler getHandler(@NotNull DebuggerSupport debuggerSupport) {
        if (debuggerSupport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debuggerSupport", "com/intellij/xdebugger/impl/actions/ResumeAction", "getHandler"));
        }
        DebuggerActionHandler debuggerActionHandler = debuggerSupport.getResumeActionHandler();
        if (debuggerActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/actions/ResumeAction", "getHandler"));
        }
        return debuggerActionHandler;
    }
}

