/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsAdapter;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorMouseAdapter;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionAdapter;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.MarkupEditorFilterFactory;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileUrlChangeAdapter;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.XDependentBreakpointListener;
import com.intellij.xdebugger.impl.breakpoints.XDependentBreakpointManager;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import gnu.trove.TIntHashSet;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class XLineBreakpointManager {
    private final BidirectionalMap<XLineBreakpointImpl, Document> myBreakpoints = new BidirectionalMap();
    private final MergingUpdateQueue myBreakpointsUpdateQueue;
    private final Project myProject;
    private final XDependentBreakpointManager myDependentBreakpointManager;
    private final StartupManagerEx myStartupManager;
    private boolean myDragDetected = false;

    public XLineBreakpointManager(Project project, XDependentBreakpointManager dependentBreakpointManager, StartupManager startupManager) {
        this.myProject = project;
        this.myDependentBreakpointManager = dependentBreakpointManager;
        this.myStartupManager = (StartupManagerEx)startupManager;
        if (!this.myProject.isDefault()) {
            EditorEventMulticaster editorEventMulticaster = EditorFactory.getInstance().getEventMulticaster();
            editorEventMulticaster.addDocumentListener((DocumentListener)new MyDocumentListener(), (Disposable)project);
            editorEventMulticaster.addEditorMouseListener((EditorMouseListener)new MyEditorMouseListener(), (Disposable)project);
            editorEventMulticaster.addEditorMouseMotionListener((EditorMouseMotionListener)new MyEditorMouseMotionListener(), (Disposable)project);
            final MyDependentBreakpointListener myDependentBreakpointListener = new MyDependentBreakpointListener();
            this.myDependentBreakpointManager.addListener(myDependentBreakpointListener);
            Disposer.register((Disposable)project, (Disposable)new Disposable(){

                public void dispose() {
                    XLineBreakpointManager.this.myDependentBreakpointManager.removeListener(myDependentBreakpointListener);
                }
            });
            VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new VirtualFileUrlChangeAdapter(){

                @Override
                protected void fileUrlChanged(String oldUrl, String newUrl) {
                    for (XLineBreakpointImpl breakpoint : XLineBreakpointManager.this.myBreakpoints.keySet()) {
                        String url = breakpoint.getFileUrl();
                        if (!FileUtil.startsWith((String)url, (String)oldUrl)) continue;
                        breakpoint.setFileUrl(newUrl + url.substring(oldUrl.length()));
                    }
                }

                public void fileDeleted(@NotNull VirtualFileEvent event) {
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/breakpoints/XLineBreakpointManager$2", "fileDeleted"));
                    }
                    SmartList toRemove = new SmartList();
                    for (XLineBreakpointImpl breakpoint : XLineBreakpointManager.this.myBreakpoints.keySet()) {
                        if (!breakpoint.getFileUrl().equals(event.getFile().getUrl())) continue;
                        toRemove.add(breakpoint);
                    }
                    XLineBreakpointManager.this.removeBreakpoints((List)toRemove);
                }
            }, (Disposable)project);
        }
        this.myBreakpointsUpdateQueue = new MergingUpdateQueue("XLine breakpoints", 300, true, null, (Disposable)project);
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        if (colorsManager != null) {
            colorsManager.addEditorColorsListener((EditorColorsListener)new MyEditorColorsListener(), (Disposable)project);
        }
    }

    public void updateBreakpointsUI() {
        if (this.myProject.isDefault()) {
            return;
        }
        DumbAwareRunnable runnable = new DumbAwareRunnable(){

            public void run() {
                for (XLineBreakpointImpl breakpoint : XLineBreakpointManager.this.myBreakpoints.keySet()) {
                    breakpoint.updateUI();
                }
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode() || this.myStartupManager.startupActivityPassed()) {
            runnable.run();
        } else {
            this.myStartupManager.registerPostStartupActivity((Runnable)runnable);
        }
    }

    public void registerBreakpoint(XLineBreakpointImpl breakpoint, boolean initUI) {
        Document document;
        if (initUI) {
            breakpoint.updateUI();
        }
        if ((document = breakpoint.getDocument()) != null) {
            this.myBreakpoints.put((Object)breakpoint, (Object)document);
        }
    }

    public void unregisterBreakpoint(XLineBreakpointImpl breakpoint) {
        RangeHighlighter highlighter = breakpoint.getHighlighter();
        if (highlighter != null) {
            this.myBreakpoints.remove((Object)breakpoint);
        }
    }

    @NotNull
    public Collection<XLineBreakpointImpl> getDocumentBreakpoints(Document document) {
        List<XLineBreakpointImpl> breakpoints = this.myBreakpoints.getKeysByValue((Object)document);
        if (breakpoints == null) {
            breakpoints = Collections.emptyList();
        }
        List<XLineBreakpointImpl> list = breakpoints;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/breakpoints/XLineBreakpointManager", "getDocumentBreakpoints"));
        }
        return list;
    }

    private void updateBreakpoints(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/xdebugger/impl/breakpoints/XLineBreakpointManager", "updateBreakpoints"));
        }
        List breakpoints = this.myBreakpoints.getKeysByValue((Object)document);
        if (breakpoints == null) {
            return;
        }
        TIntHashSet lines = new TIntHashSet();
        SmartList toRemove = new SmartList();
        for (XLineBreakpointImpl breakpoint : breakpoints) {
            breakpoint.updatePosition();
            if (breakpoint.isValid() && lines.add(breakpoint.getLine())) continue;
            toRemove.add(breakpoint);
        }
        this.removeBreakpoints((List<? extends XBreakpoint<?>>)toRemove);
    }

    private void removeBreakpoints(final List<? extends XBreakpoint<?>> toRemove) {
        if (toRemove.isEmpty()) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                for (XBreakpoint breakpoint : toRemove) {
                    XDebuggerManager.getInstance((Project)XLineBreakpointManager.this.myProject).getBreakpointManager().removeBreakpoint(breakpoint);
                }
            }
        });
    }

    public void breakpointChanged(XLineBreakpointImpl breakpoint) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            breakpoint.updateUI();
        } else {
            this.queueBreakpointUpdate(breakpoint);
        }
    }

    public void queueBreakpointUpdate(XBreakpoint<?> slave) {
        if (slave instanceof XLineBreakpointImpl) {
            this.queueBreakpointUpdate((XLineBreakpointImpl)slave);
        }
    }

    public void queueBreakpointUpdate(final @NotNull XLineBreakpointImpl<?> breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/xdebugger/impl/breakpoints/XLineBreakpointManager", "queueBreakpointUpdate"));
        }
        this.myBreakpointsUpdateQueue.queue(new Update(breakpoint){

            public void run() {
                breakpoint.updateUI();
            }
        });
    }

    public void queueAllBreakpointsUpdate() {
        this.myBreakpointsUpdateQueue.queue(new Update("all breakpoints"){

            public void run() {
                for (XLineBreakpointImpl breakpoint : XLineBreakpointManager.this.myBreakpoints.keySet()) {
                    breakpoint.updateUI();
                }
            }
        });
    }

    private boolean isFromMyProject(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xdebugger/impl/breakpoints/XLineBreakpointManager", "isFromMyProject"));
        }
        if (this.myProject == editor.getProject()) {
            return true;
        }
        for (FileEditor fileEditor : FileEditorManager.getInstance((Project)this.myProject).getAllEditors()) {
            if (!(fileEditor instanceof TextEditor) || !((TextEditor)fileEditor).getEditor().equals(editor)) continue;
            return true;
        }
        return false;
    }

    private class MyEditorColorsListener
    extends EditorColorsAdapter {
        private MyEditorColorsListener() {
        }

        public void globalSchemeChange(EditorColorsScheme scheme) {
            XLineBreakpointManager.this.updateBreakpointsUI();
        }
    }

    private class MyDependentBreakpointListener
    implements XDependentBreakpointListener {
        private MyDependentBreakpointListener() {
        }

        @Override
        public void dependencySet(XBreakpoint<?> slave, XBreakpoint<?> master) {
            XLineBreakpointManager.this.queueBreakpointUpdate(slave);
        }

        @Override
        public void dependencyCleared(XBreakpoint<?> breakpoint) {
            XLineBreakpointManager.this.queueBreakpointUpdate(breakpoint);
        }
    }

    private class MyEditorMouseListener
    extends EditorMouseAdapter {
        private MyEditorMouseListener() {
        }

        public void mousePressed(EditorMouseEvent e) {
            XLineBreakpointManager.this.myDragDetected = false;
        }

        public void mouseClicked(final EditorMouseEvent e) {
            final Editor editor = e.getEditor();
            final MouseEvent mouseEvent = e.getMouseEvent();
            if (mouseEvent.isPopupTrigger() || mouseEvent.isMetaDown() || mouseEvent.isControlDown() || mouseEvent.getButton() != 1 || MarkupEditorFilterFactory.createIsDiffFilter().avaliableIn(editor) || !this.isInsideGutter(e, editor) || ConsoleViewUtil.isConsoleViewEditor(editor) || !XLineBreakpointManager.this.isFromMyProject(editor) || editor.getSelectionModel().hasSelection() && XLineBreakpointManager.this.myDragDetected) {
                return;
            }
            PsiDocumentManager.getInstance((Project)XLineBreakpointManager.this.myProject).commitAndRunReadAction(new Runnable(){

                @Override
                public void run() {
                    final int line = EditorUtil.yPositionToLogicalLine(editor, mouseEvent);
                    Document document = editor.getDocument();
                    final VirtualFile file = FileDocumentManager.getInstance().getFile(document);
                    if (line >= 0 && line < document.getLineCount() && file != null) {
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (!XLineBreakpointManager.this.myProject.isDisposed() && XLineBreakpointManager.this.myProject.isInitialized() && file.isValid()) {
                                    ActionManagerEx.getInstanceEx().fireBeforeActionPerformed("ToggleLineBreakpoint", (InputEvent)e.getMouseEvent());
                                    AsyncResult<XLineBreakpoint> result = XBreakpointUtil.toggleLineBreakpoint(XLineBreakpointManager.this.myProject, XSourcePositionImpl.create(file, line), editor, mouseEvent.isAltDown(), false);
                                    result.doWhenDone((Consumer)new Consumer<XLineBreakpoint>(){

                                        public void consume(XLineBreakpoint breakpoint) {
                                            if (!mouseEvent.isAltDown() && mouseEvent.isShiftDown() && breakpoint != null) {
                                                breakpoint.setSuspendPolicy(SuspendPolicy.NONE);
                                                String selection = editor.getSelectionModel().getSelectedText();
                                                if (selection != null) {
                                                    breakpoint.setLogExpression(selection);
                                                } else {
                                                    breakpoint.setLogMessage(true);
                                                }
                                                DebuggerUIUtil.showXBreakpointEditorBalloon(XLineBreakpointManager.this.myProject, mouseEvent.getPoint(), ((EditorEx)editor).getGutterComponentEx(), false, (XBreakpoint)breakpoint);
                                            }
                                        }
                                    });
                                }
                            }
                        });
                    }
                }
            });
        }

        private boolean isInsideGutter(EditorMouseEvent e, Editor editor) {
            if (e.getArea() != EditorMouseEventArea.LINE_MARKERS_AREA && e.getArea() != EditorMouseEventArea.FOLDING_OUTLINE_AREA) {
                return false;
            }
            return e.getMouseEvent().getX() <= ((EditorEx)editor).getGutterComponentEx().getWhitespaceSeparatorOffset();
        }
    }

    private class MyEditorMouseMotionListener
    extends EditorMouseMotionAdapter {
        private MyEditorMouseMotionListener() {
        }

        public void mouseDragged(EditorMouseEvent e) {
            XLineBreakpointManager.this.myDragDetected = true;
        }
    }

    private class MyDocumentListener
    extends DocumentAdapter {
        private MyDocumentListener() {
        }

        public void documentChanged(DocumentEvent e) {
            final Document document = e.getDocument();
            List breakpoints = XLineBreakpointManager.this.myBreakpoints.getKeysByValue((Object)document);
            if (breakpoints != null && !breakpoints.isEmpty()) {
                XLineBreakpointManager.this.myBreakpointsUpdateQueue.queue(new Update(document){

                    public void run() {
                        XLineBreakpointManager.this.updateBreakpoints(document);
                    }
                });
            }
        }
    }
}

