/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.actions.validate;

import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.MessageView;
import com.intellij.util.ui.ErrorTreeView;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.actions.validate.ErrorReporter;
import com.intellij.xml.actions.validate.ValidateXmlActionHandler;
import java.util.concurrent.Future;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.xml.sax.SAXParseException;

public class StdErrorReporter
extends ErrorReporter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.xml.actions.validate.StdErrorReporter");
    private static final Key<NewErrorTreeViewPanel> KEY = Key.create((String)"ValidateXmlAction.KEY");
    private final NewErrorTreeViewPanel myErrorsView;
    private final String CONTENT_NAME = XmlBundle.message((String)"xml.validate.tab.content.title", (Object[])new Object[0]);
    private final Project myProject;
    private boolean myErrorsDetected = false;

    public StdErrorReporter(ValidateXmlActionHandler handler, Project project, Runnable rerunAction) {
        super(handler);
        this.myProject = project;
        this.myErrorsView = new NewErrorTreeViewPanel(project, null, true, true, rerunAction);
    }

    @Override
    public void startProcessing() {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            StdErrorReporter.super.startProcessing();
                        }
                    });
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (!StdErrorReporter.this.myErrorsDetected) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        StdErrorReporter.this.removeCompileContents(null);
                                        WindowManager.getInstance().getStatusBar(StdErrorReporter.this.myProject).setInfo(XmlBundle.message((String)"xml.validate.no.errors.detected.status.message", (Object[])new Object[0]));
                                    }
                                });
                            }
                        }
                    });
                }
                finally {
                    Thread.interrupted();
                }
            }
        };
        MyProcessController processController = new MyProcessController();
        this.myErrorsView.setProcessController(processController);
        this.openMessageView();
        processController.setFuture(ApplicationManager.getApplication().executeOnPooledThread(task));
        ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ToolWindowId.MESSAGES_WINDOW).activate(null);
    }

    private void openMessageView() {
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                MessageView messageView = MessageView.SERVICE.getInstance(StdErrorReporter.this.myProject);
                Content content = ContentFactory.SERVICE.getInstance().createContent(StdErrorReporter.this.myErrorsView.getComponent(), StdErrorReporter.this.CONTENT_NAME, true);
                content.putUserData(KEY, (Object)StdErrorReporter.this.myErrorsView);
                messageView.getContentManager().addContent(content);
                messageView.getContentManager().setSelectedContent(content);
                messageView.getContentManager().addContentManagerListener((ContentManagerListener)new CloseListener(content, messageView.getContentManager()));
                StdErrorReporter.this.removeCompileContents(content);
                messageView.getContentManager().addContentManagerListener((ContentManagerListener)new MyContentDisposer(content, messageView));
            }
        }, XmlBundle.message((String)"validate.xml.open.message.view.command.name", (Object[])new Object[0]), null);
    }

    private void removeCompileContents(Content notToRemove) {
        MessageView messageView = MessageView.SERVICE.getInstance(this.myProject);
        for (Content content : messageView.getContentManager().getContents()) {
            ErrorTreeView listErrorView;
            if (content.isPinned() || !this.CONTENT_NAME.equals(content.getDisplayName()) || content == notToRemove || (listErrorView = (ErrorTreeView)content.getComponent()) == null || !messageView.getContentManager().removeContent(content, true)) continue;
            content.release();
        }
    }

    @Override
    public void processError(final SAXParseException ex, final ValidateXmlActionHandler.ProblemType problemType) {
        if (LOG.isDebugEnabled()) {
            String error = this.myHandler.buildMessageString(ex);
            LOG.debug("enter: processError(error='" + error + "')");
        }
        this.myErrorsDetected = true;
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VirtualFile file = StdErrorReporter.this.myHandler.getProblemFile(ex);
                    StdErrorReporter.this.myErrorsView.addMessage(problemType == ValidateXmlActionHandler.ProblemType.WARNING ? 5 : 4, new String[]{ex.getLocalizedMessage()}, file, ex.getLineNumber() - 1, ex.getColumnNumber() - 1, null);
                }
            });
        }
    }

    private static class MyProcessController
    implements NewErrorTreeViewPanel.ProcessController {
        private Future<?> myFuture;

        private MyProcessController() {
        }

        public void setFuture(Future<?> future2) {
            this.myFuture = future2;
        }

        @Override
        public void stopProcess() {
            if (this.myFuture != null) {
                this.myFuture.cancel(true);
            }
        }

        @Override
        public boolean isProcessStopped() {
            return this.myFuture != null && this.myFuture.isDone();
        }
    }

    private class CloseListener
    extends ContentManagerAdapter {
        private Content myContent;
        private final ContentManager myContentManager;

        public CloseListener(Content content, ContentManager contentManager) {
            this.myContent = content;
            this.myContentManager = contentManager;
        }

        public void contentRemoved(ContentManagerEvent event) {
            if (event.getContent() == this.myContent) {
                StdErrorReporter.this.myErrorsView.stopProcess();
                this.myContentManager.removeContentManagerListener((ContentManagerListener)this);
                this.myContent.release();
                this.myContent = null;
            }
        }

        public void contentRemoveQuery(ContentManagerEvent event) {
            int result;
            if (event.getContent() == this.myContent && !StdErrorReporter.this.myErrorsView.isProcessStopped() && (result = Messages.showYesNoDialog((String)XmlBundle.message((String)"xml.validate.validation.is.running.terminate.confirmation.text", (Object[])new Object[0]), (String)XmlBundle.message((String)"xml.validate.validation.is.running.terminate.confirmation.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon())) != 0) {
                event.consume();
            }
        }
    }

    private static class MyContentDisposer
    implements ContentManagerListener {
        private final Content myContent;
        private final MessageView myMessageView;

        public MyContentDisposer(Content content, MessageView messageView) {
            this.myContent = content;
            this.myMessageView = messageView;
        }

        public void contentRemoved(ContentManagerEvent event) {
            Content eventContent = event.getContent();
            if (!eventContent.equals(this.myContent)) {
                return;
            }
            this.myMessageView.getContentManager().removeContentManagerListener((ContentManagerListener)this);
            NewErrorTreeViewPanel errorTreeView = (NewErrorTreeViewPanel)eventContent.getUserData(KEY);
            if (errorTreeView != null) {
                errorTreeView.dispose();
            }
            eventContent.putUserData(KEY, null);
        }

        public void contentAdded(ContentManagerEvent event) {
        }

        public void contentRemoveQuery(ContentManagerEvent event) {
        }

        public void selectionChanged(ContentManagerEvent event) {
        }
    }
}

