/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.trivialif;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.ErrorUtil;
import com.siyeh.ipp.trivialif.ExpandBooleanPredicate;
import org.jetbrains.annotations.NotNull;

public class ExpandBooleanIntention
extends MutablyNamedIntention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        ExpandBooleanPredicate expandBooleanPredicate = new ExpandBooleanPredicate();
        if (expandBooleanPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/trivialif/ExpandBooleanIntention", "getElementPredicate"));
        }
        return expandBooleanPredicate;
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        if (element instanceof PsiDeclarationStatement) {
            return IntentionPowerPackBundle.message("expand.boolean.declaration.intention.name", new Object[0]);
        }
        if (element instanceof PsiReturnStatement) {
            return IntentionPowerPackBundle.message("expand.boolean.return.intention.name", new Object[0]);
        }
        return IntentionPowerPackBundle.message("expand.boolean.assignment.intention.name", new Object[0]);
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/trivialif/ExpandBooleanIntention", "processIntention"));
        }
        if (!(element instanceof PsiStatement)) {
            return;
        }
        PsiStatement statement = (PsiStatement)element;
        if (ExpandBooleanPredicate.isBooleanAssignment(statement)) {
            PsiExpressionStatement assignmentStatement = (PsiExpressionStatement)statement;
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)assignmentStatement.getExpression();
            PsiExpression rhs = assignmentExpression.getRExpression();
            if (rhs == null) {
                return;
            }
            PsiExpression lhs = assignmentExpression.getLExpression();
            if (ErrorUtil.containsDeepError((PsiElement)lhs) || ErrorUtil.containsDeepError((PsiElement)rhs)) {
                return;
            }
            String rhsText = rhs.getText();
            String lhsText = lhs.getText();
            PsiJavaToken sign = assignmentExpression.getOperationSign();
            String signText = sign.getText();
            String conditionText = signText.length() == 2 ? lhsText + signText.charAt(0) + rhsText : rhsText;
            String newStatementText = "if(" + conditionText + ") " + lhsText + " = true; else " + lhsText + " = false;";
            PsiReplacementUtil.replaceStatement(statement, newStatementText);
        } else if (ExpandBooleanPredicate.isBooleanReturn(statement)) {
            PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
            PsiExpression returnValue = returnStatement.getReturnValue();
            if (returnValue == null) {
                return;
            }
            if (ErrorUtil.containsDeepError((PsiElement)returnValue)) {
                return;
            }
            String valueText = returnValue.getText();
            String newStatementText = "if(" + valueText + ") return true; else return false;";
            PsiReplacementUtil.replaceStatement(statement, newStatementText);
        } else if (ExpandBooleanPredicate.isBooleanDeclaration(statement)) {
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement;
            PsiElement declaredElement = declarationStatement.getDeclaredElements()[0];
            if (!(declaredElement instanceof PsiLocalVariable)) {
                return;
            }
            PsiLocalVariable variable = (PsiLocalVariable)declaredElement;
            PsiExpression initializer = variable.getInitializer();
            if (initializer == null) {
                return;
            }
            String name = variable.getName();
            String newStatementText = "if(" + initializer.getText() + ") " + name + "=true; else " + name + "=false;";
            Project project = statement.getProject();
            PsiStatement newStatement = JavaPsiFacade.getElementFactory((Project)project).createStatementFromText(newStatementText, (PsiElement)statement);
            PsiElement newElement = declarationStatement.getParent().addAfter((PsiElement)newStatement, (PsiElement)declarationStatement);
            CodeStyleManager.getInstance((Project)project).reformat(newElement);
            initializer.delete();
        }
    }
}

