/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.jsonRpc;

import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.EventLoop;
import java.util.Enumeration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.io.jsonRpc.ExceptionHandler;

public abstract class Client
extends UserDataHolderBase {
    static final RuntimeException REJECTED = Promise.createError((String)"rejected");
    protected final Channel channel;
    final ConcurrentIntObjectMap<AsyncPromise<Object>> messageCallbackMap;

    protected Client(@NotNull Channel channel) {
        if (channel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channel", "org/jetbrains/io/jsonRpc/Client", "<init>"));
        }
        this.messageCallbackMap = ContainerUtil.createConcurrentIntObjectMap();
        this.channel = channel;
    }

    @NotNull
    public final EventLoop getEventLoop() {
        EventLoop eventLoop = this.channel.eventLoop();
        if (eventLoop == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/io/jsonRpc/Client", "getEventLoop"));
        }
        return eventLoop;
    }

    @NotNull
    public final ByteBufAllocator getByteBufAllocator() {
        ByteBufAllocator byteBufAllocator = this.channel.alloc();
        if (byteBufAllocator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/io/jsonRpc/Client", "getByteBufAllocator"));
        }
        return byteBufAllocator;
    }

    protected abstract ChannelFuture send(@NotNull ByteBuf var1);

    public abstract void sendHeartbeat();

    @Nullable
    final <T> AsyncPromise<T> send(int messageId, @NotNull ByteBuf message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/io/jsonRpc/Client", "send"));
        }
        ChannelFuture channelFuture = this.send(message);
        if (messageId == -1) {
            return null;
        }
        ChannelFutureAwarePromise promise = new ChannelFutureAwarePromise(messageId, this.messageCallbackMap);
        channelFuture.addListener(promise);
        this.messageCallbackMap.put(messageId, promise);
        return promise;
    }

    final void rejectAsyncResults(@NotNull ExceptionHandler exceptionHandler) {
        if (exceptionHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionHandler", "org/jetbrains/io/jsonRpc/Client", "rejectAsyncResults"));
        }
        if (!this.messageCallbackMap.isEmpty()) {
            Enumeration elements = this.messageCallbackMap.elements();
            while (elements.hasMoreElements()) {
                try {
                    ((AsyncPromise)elements.nextElement()).setError((Throwable)REJECTED);
                }
                catch (Throwable e) {
                    exceptionHandler.exceptionCaught(e);
                }
            }
        }
    }

    private static final class ChannelFutureAwarePromise<T>
    extends AsyncPromise<T>
    implements ChannelFutureListener {
        private final int messageId;
        private final ConcurrentIntObjectMap<?> messageCallbackMap;

        public ChannelFutureAwarePromise(int messageId, ConcurrentIntObjectMap<?> messageCallbackMap) {
            this.messageId = messageId;
            this.messageCallbackMap = messageCallbackMap;
        }

        public boolean setError(@NotNull Throwable error) {
            if (error == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "org/jetbrains/io/jsonRpc/Client$ChannelFutureAwarePromise", "setError"));
            }
            boolean result = super.setError(error);
            this.messageCallbackMap.remove(this.messageId);
            return result;
        }

        public void operationComplete(ChannelFuture future2) throws Exception {
            if (!future2.isSuccess()) {
                Throwable cause = future2.cause();
                if (cause == null) {
                    this.setError("No success");
                } else {
                    this.setError(cause);
                }
            }
        }
    }
}

