/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.generate.view;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiType;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.generate.element.ClassElement;
import org.jetbrains.java.generate.element.FieldElement;
import org.jetbrains.java.generate.element.GenerationHelper;
import org.jetbrains.java.generate.template.TemplateResource;
import org.jetbrains.java.generate.template.TemplatesManager;

public class GenerateTemplateConfigurable
implements UnnamedConfigurable {
    private final TemplateResource template;
    private final Editor myEditor;
    private final List<String> availableImplicits = new ArrayList<String>();

    public GenerateTemplateConfigurable(TemplateResource template, Map<String, PsiType> contextMap, Project project) {
        this(template, contextMap, project, true);
    }

    public GenerateTemplateConfigurable(TemplateResource template, Map<String, PsiType> contextMap, Project project, boolean multipleFields) {
        this.template = template;
        EditorFactory factory = EditorFactory.getInstance();
        Document doc = factory.createDocument((CharSequence)template.getTemplate());
        FileType ftl = FileTypeManager.getInstance().findFileTypeByName("VTL");
        if (project != null && ftl != null) {
            Document document;
            PsiFile file = PsiFileFactory.getInstance((Project)project).createFileFromText(template.getFileName(), ftl, (CharSequence)template.getTemplate(), LocalTimeCounter.currentTime(), true);
            if (!template.isDefault()) {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                map.put("java_version", PsiType.INT);
                map.put("class", TemplatesManager.createElementType(project, ClassElement.class));
                if (multipleFields) {
                    map.put("fields", TemplatesManager.createFieldListElementType(project));
                } else {
                    map.put("field", TemplatesManager.createElementType(project, FieldElement.class));
                }
                map.put("helper", TemplatesManager.createElementType(project, GenerationHelper.class));
                map.put("settings", PsiType.NULL);
                map.putAll(contextMap);
                this.availableImplicits.addAll(((HashMap)map).keySet());
                file.getViewProvider().putUserData(TemplatesManager.TEMPLATE_IMPLICITS, map);
            }
            if ((document = PsiDocumentManager.getInstance((Project)project).getDocument(file)) != null) {
                doc = document;
            }
        }
        this.myEditor = factory.createEditor(doc, project, (FileType)(ftl != null ? ftl : FileTypes.PLAIN_TEXT), template.isDefault());
    }

    public JComponent createComponent() {
        JComponent component = this.myEditor.getComponent();
        if (this.availableImplicits.isEmpty()) {
            return component;
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)component, "Center");
        MultiLineLabel label = new MultiLineLabel("<html>Available implicit variables:\n" + StringUtil.join(this.availableImplicits, (String)", ") + "</html>");
        label.setPreferredSize((Dimension)JBUI.size((int)250, (int)30));
        panel.add((Component)label, "South");
        return panel;
    }

    public boolean isModified() {
        return !Comparing.equal((String)this.myEditor.getDocument().getText(), (String)this.template.getTemplate());
    }

    public void apply() throws ConfigurationException {
        this.template.setTemplate(this.myEditor.getDocument().getText());
    }

    public void reset() {
        new WriteCommandAction(null, new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/java/generate/view/GenerateTemplateConfigurable$1", "run"));
                }
                GenerateTemplateConfigurable.this.myEditor.getDocument().setText((CharSequence)GenerateTemplateConfigurable.this.template.getTemplate());
            }
        }.execute();
    }

    public void disposeUIResources() {
        EditorFactory.getInstance().releaseEditor(this.myEditor);
    }
}

