/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jsonProtocol;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class JsonWriters {
    public static final Method JSON_WRITE_DEFERRED_NAME;

    private JsonWriters() {
    }

    public static void writeStringList(@NotNull JsonWriter writer, @NotNull String name, @NotNull Collection<String> value) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "org/jetbrains/jsonProtocol/JsonWriters", "writeStringList"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jsonProtocol/JsonWriters", "writeStringList"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/jsonProtocol/JsonWriters", "writeStringList"));
        }
        writer.name(name).beginArray();
        for (String item : value) {
            writer.value(item);
        }
        writer.endArray();
    }

    static {
        try {
            JSON_WRITE_DEFERRED_NAME = JsonWriter.class.getDeclaredMethod("writeDeferredName", new Class[0]);
            JSON_WRITE_DEFERRED_NAME.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

