/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.surroundWith.expression;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.codeInsight.surroundWith.expression.KotlinExpressionSurrounder;
import org.jetbrains.kotlin.psi.JetConstantExpression;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetStringTemplateEntry;
import org.jetbrains.kotlin.psi.JetStringTemplateExpression;
import org.jetbrains.kotlin.psi.PsiPackage;

public class KotlinStringTemplateSurrounder
extends KotlinExpressionSurrounder {
    public String getTemplateDescription() {
        return JetBundle.message("surround.with.string.template", new Object[0]);
    }

    @Override
    public boolean isApplicable(@NotNull JetExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/expression/KotlinStringTemplateSurrounder", "isApplicable"));
        }
        return !(expression2 instanceof JetStringTemplateExpression);
    }

    @Override
    @Nullable
    public TextRange surroundExpression(@NotNull Project project, @NotNull Editor editor, @NotNull JetExpression expression2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/expression/KotlinStringTemplateSurrounder", "surroundExpression"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/expression/KotlinStringTemplateSurrounder", "surroundExpression"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/expression/KotlinStringTemplateSurrounder", "surroundExpression"));
        }
        JetStringTemplateExpression stringTemplateExpression = (JetStringTemplateExpression)PsiPackage.JetPsiFactory((PsiElement)expression2).createExpression(this.getCodeTemplate(expression2));
        JetStringTemplateEntry templateEntry = stringTemplateExpression.getEntries()[0];
        JetExpression innerExpression = templateEntry.getExpression();
        assert (innerExpression != null) : "JetExpression should exists for " + stringTemplateExpression.toString();
        innerExpression.replace((PsiElement)expression2);
        expression2 = (JetExpression)expression2.replace((PsiElement)stringTemplateExpression);
        CodeInsightUtilBase.forcePsiPostprocessAndRestoreElement((PsiElement)expression2);
        int offset = expression2.getTextRange().getEndOffset();
        return new TextRange(offset, offset);
    }

    private String getCodeTemplate(JetExpression expression2) {
        if (expression2.getChildren().length > 0 || expression2 instanceof JetConstantExpression) {
            return "\"${a}\"";
        }
        return "\"$a\"";
    }
}

