/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.lang.ASTNode;
import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.editor.EditorPackage$KotlinSmartEnterHandler$7ffb2318;
import org.jetbrains.kotlin.idea.editor.fixers.FixersPackage$fixersUtil$f9a2ce21;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinDoWhileFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinForConditionFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinFunctionDeclarationBodyFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinFunctionParametersFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinIfConditionFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinMissingForOrWhileBodyFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinMissingIfBranchFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinMissingWhenBodyFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinWhenSubjectCaretFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinWhileConditionFixer;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetDeclarationWithBody;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetForExpression;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetIfExpression;
import org.jetbrains.kotlin.psi.JetLoopExpression;
import org.jetbrains.kotlin.psi.JetParameter;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"G\u0006)92j\u001c;mS:\u001cV.\u0019:u\u000b:$XM\u001d%b]\u0012dWM\u001d\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*!\u0011\u000eZ3b\u0015\u0019)G-\u001b;pe*i2+\\1si\u0016sG/\u001a:Qe>\u001cWm]:pe^KG\u000f\u001b$jq\u0016\u00148OC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\u0005Y\u0006twM\u0003\u0004=S:LGO\u0010\u0006\u0014O\u0016$8\u000b^1uK6,g\u000e^!u\u0007\u0006\u0014X\r\u001e\u0006\u0007\u000b\u0012LGo\u001c:\u000b\u000f=\u0004XM\\1qS*9\u0001o]5GS2,'b\u0002)tS\u001aKG.\u001a\u0006\u0004aNL'B\u0003)tS\u0016cW-\\3oi*QRn\u001c<f\u0007\u0006\u0014X\r^%og&$WM\u0011:bG\u0016\u001c\u0018JZ!os*!a-\u001b7f\u0015\u0011)f.\u001b;\u000b/I,w-[:uKJ,fN]3t_24X\rZ#se>\u0014(BB8gMN,GOC\u0002J]RTa\"[:KKR\u001cF/\u0019;f[\u0016tGOC\u0004C_>dW-\u00198\u000b3-{G\u000f\\5o!2\f\u0017N\\#oi\u0016\u0014\bK]8dKN\u001cxN\u001dK\u0002\u0015\t\u0001\u0012A\u0003\u0003\t\u0001A\u0011!\u0002\u0002\u0005\u0002!\rQA\u0001\u0003\u0002\u0011\t)!\u0001b\u0001\t\u0006\u0015\u0019AA\u0001\u0005\u0001\u0019\u0001)\u0011\u0001c\u0002\u0006\u0005\u0011\u0019\u0001\u0002B\u0003\u0003\t\u000fAI!B\u0002\u0005\t!\u0019A\u0002A\u0003\u0003\t\u000fAi!\u0002\u0002\u0005\u000b!\u0015Qa\u0001C\u0006\u0011\u0019a\u0001!\u0002\u0002\u0005\b!AQa\u0001C\u0007\u0011\u001fa\u0001!B\u0002\u0005\u000e!EA\u0002A\u0003\u0003\t\u001bA\t\"\u0002\u0002\u0005\f!1QA\u0001C\u0007\u0011\u001f)\u0011\u0001c\u0001\u0006\u0007\u0011M\u0001B\u0003\u0007\u0001\u000b\r!\u0019\u0002c\u0006\r\u0001\u0015\u0019A1\u0003E\r\u0019\u0001!1\u0001$\u0002\u001a\u0005\u0015\t\u0001\u0012\u0002\u000f\u000e[\u007f!!\u0002g\u0003\u001e\u0010\u0011\u0001\u0001RA\u0007\u0004\u000b\u0005Aa\u0001$\u0001Q\u0007\u0001iz\u0001\u0002\u0001\t\u000f5\u0019Q!\u0001\u0005\b\u0019\u0003\u00016\u0011A\u0011\u0004\u000b\u0005Ay\u0001$\u0001R\u0007\u001d!Y!C\u0001\t\u00115\t\u0001\u0012C\u0007\u0002\u0011%iK\u0004\u0002\u0006\u0019\u0013u5A\u0001\u0001E\u0003\u001b\t)\u0011\u0001\u0003\u0004Q\u0007\u0001ij\u0001\u0002\u0001\t\u00145\u0011Q!\u0001\u0005\b!\u000e\u0005\u0011EA\u0003\u0002\u0011)\t6a\u0002\u0003\n\u0013\u0005!\u0001!D\u0001\t\u00125\t\u0001\"C\u0017\u0014\t\rA*\"(\u0004\u0005\u0001!YQBA\u0003\u0002\u0011+\u00016\u0001A\u0011\u0003\u000b\u0005A!\"U\u0002\u0006\t+I\u0011\u0001\u0002\u0001\u000e\u0003\u0011\u0015QV\u0004\u0003\u0002+\t)\u0011\u0001c\u0004\u0019\u0019\u0005\u0012Q!\u0001\u0005\f#\u000e)A\u0001D\u0005\u0002\t\u0003i\u0011\u0001\u0003\u00056\u0017\u0015QAa9\u0001\u0019\u000b\u0005\u0012Q!\u0001E\u0003#\u000e\u0019A!B\u0005\u0002\t\u0001\u0001"})
public final class KotlinSmartEnterHandler
extends SmartEnterProcessorWithFixers {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(KotlinSmartEnterHandler.class);
    }

    @Nullable
    protected PsiElement getStatementAtCaret(@JetValueParameter(name="editor", type="?") @Nullable Editor editor, @JetValueParameter(name="psiFile", type="?") @Nullable PsiFile psiFile) {
        PsiElement atCaret = super.getStatementAtCaret(editor, psiFile);
        if (atCaret instanceof PsiWhiteSpace) {
            return null;
        }
        while (atCaret != null) {
            PsiElement psiElement = atCaret;
            if (Intrinsics.areEqual((Object)(psiElement != null ? Boolean.valueOf(this.isJetStatement(psiElement)) : null), (Object)true)) {
                return atCaret;
            }
            PsiElement psiElement2 = atCaret;
            if ((psiElement2 != null ? psiElement2.getParent() : null) instanceof JetFunctionLiteral) {
                return atCaret;
            }
            if (atCaret instanceof JetDeclaration) {
                PsiElement declaration;
                if (atCaret == null) {
                    Intrinsics.throwNpe();
                }
                if (!(declaration instanceof JetParameter && !EditorPackage$KotlinSmartEnterHandler$7ffb2318.isInLambdaExpression((JetParameter)declaration) || declaration.getParent() instanceof JetForExpression)) {
                    return atCaret;
                }
            }
            PsiElement psiElement3 = atCaret;
            atCaret = psiElement3 != null ? psiElement3.getParent() : null;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected void moveCaretInsideBracesIfAny(@JetValueParameter(name="editor") @NotNull Editor editor, @JetValueParameter(name="file") @NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        int caretOffset = editor.getCaretModel().getOffset();
        CharSequence chars = editor.getDocument().getCharsSequence();
        if (CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"{}")) {
            caretOffset += 2;
        } else if (CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"{\n}")) {
            caretOffset += 3;
        }
        caretOffset = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(caretOffset - 1), (String)" \t") + 1;
        if (CharArrayUtil.regionMatches((CharSequence)chars, (int)(caretOffset - "{}".length()), (CharSequence)"{}") || CharArrayUtil.regionMatches((CharSequence)chars, (int)(caretOffset - "{\n}".length()), (CharSequence)"{\n}")) {
            void $receiver;
            this.commit(editor);
            CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)file.getProject());
            boolean old = ((CommonCodeStyleSettings)settings).KEEP_SIMPLE_BLOCKS_IN_ONE_LINE;
            ((CommonCodeStyleSettings)settings).KEEP_SIMPLE_BLOCKS_IN_ONE_LINE = false;
            PsiElement psiElement = file.findElementAt(caretOffset - 1);
            JetBlockExpression elt = (JetBlockExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver, JetBlockExpression.class, (boolean)true);
            if (elt != null) {
                this.reformat((PsiElement)elt);
            }
            ((CommonCodeStyleSettings)settings).KEEP_SIMPLE_BLOCKS_IN_ONE_LINE = old;
            editor.getCaretModel().moveToOffset(caretOffset - 1);
        }
    }

    public final void registerUnresolvedError(@JetValueParameter(name="offset") int offset) {
        if (this.myFirstErrorOffset > offset) {
            this.myFirstErrorOffset = offset;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isJetStatement(@JetValueParameter(name="$receiver") PsiElement $receiver) {
        PsiElement psiElement;
        if ($receiver.getParent() instanceof JetBlockExpression) {
            ASTNode aSTNode = $receiver.getNode();
            if (EditorPackage$KotlinSmartEnterHandler$7ffb2318.getBRACES().contains((IElementType)(aSTNode != null ? aSTNode.getElementType() : null)) ^ true) {
                return true;
            }
        }
        if (!EditorPackage$KotlinSmartEnterHandler$7ffb2318.getBRANCH_CONTAINERS().contains((psiElement = $receiver.getParent()) != null && (psiElement = psiElement.getNode()) != null ? psiElement.getElementType() : null)) return false;
        if ($receiver instanceof JetBlockExpression) return false;
        return true;
    }

    public KotlinSmartEnterHandler() {
        this.addFixers(new SmartEnterProcessorWithFixers.Fixer[]{new KotlinIfConditionFixer(), new KotlinMissingIfBranchFixer(), new KotlinWhileConditionFixer(), new KotlinForConditionFixer(), new KotlinMissingForOrWhileBodyFixer(), new KotlinWhenSubjectCaretFixer(), new KotlinMissingWhenBodyFixer(), new KotlinDoWhileFixer(), new KotlinFunctionParametersFixer(), new KotlinFunctionDeclarationBodyFixer()});
        this.addEnterProcessors(new SmartEnterProcessorWithFixers.FixEnterProcessor[]{new KotlinPlainEnterProcessor()});
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={">\u0006)I2j\u001c;mS:\u0004F.Y5o\u000b:$XM\u001d)s_\u000e,7o]8s\u0015]Yu\u000e\u001e7j]Nk\u0017M\u001d;F]R,'\u000fS1oI2,'OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\u0011IG-Z1\u000b\r\u0015$\u0017\u000e^8s\u0015E1\u0015\u000e_#oi\u0016\u0014\bK]8dKN\u001cxN\u001d\u0006\u001e'6\f'\u000f^#oi\u0016\u0014\bK]8dKN\u001cxN],ji\"4\u0015\u000e_3sg*\u00191m\\7\u000b\u0011%tG/\u001a7mS*TA\u0001\\1oO*1A(\u001b8jizRq\u0001Z8F]R,'OC\u0004bi\u000e\u000b'/\u001a;\u000b\u0015A\u001b\u0018.\u00127f[\u0016tGOC\u0002qg&TAAZ5mK*9\u0001k]5GS2,'BB#eSR|'OC\u0004pa\u0016t\u0017\r]5\u000b\u00115|G-\u001b4jK\u0012TqAQ8pY\u0016\fgN\u0003\rhKR\u001cuN\u001c;s_2\u001cF/\u0019;f[\u0016tGO\u00117pG.TQaY1sKRT1!\u00138u\u0015\u001d)G.Z7f]RTQBS3u\u000bb\u0004(/Z:tS>t\u00077\u0001\u0006\u0003!\tQA\u0001\u0003\u0001\u0011\u0007)!\u0001\"\u0001\t\u0005\u0015\u0011A!\u0001E\u0003\u000b\t!\u0019\u0001C\u0002\u0006\u0007\u0011\u0011\u0001\u0012\u0001\u0007\u0001\u000b\r!)\u0001\u0003\u0001\r\u0001\u0015\t\u0001\u0012B\u0003\u0003\t\u000fAQ!\u0002\u0002\u0005\t!-Qa\u0001C\u0005\u0011\u0011a\u0001!B\u0002\u0005\u000b!\u001dA\u0002A\u0003\u0003\t\u0011A\u0001\"B\u0002\u0005\r!=A\u0002A\u0003\u0004\t\u0019A\u0011\u0002\u0004\u0001\u0006\u0005\u0011!\u0001BC\u0003\u0003\t\u001fA1!B\u0002\u0005\u0011!MA\u0002A\u0003\u0002\u0011\t)1\u0001B\u0005\t\u00171\u0001QA\u0001\u0003\u0007\u0011\u001f)!\u0001\u0002\u0004\t\u0013\u0015\u0011A\u0001\u0003E\n\u000b\r!\u0011\u0002#\u0007\r\u0001\u0015\u0011A!\u0001\u0005\t\u000b\r!A\u0002c\u0007\r\u0001\u0015\u0011A\u0001\u0004E\u000e\t\u0001a1!\u0007\u0002\u0006\u0003!-Q\u0016\r\u0003\f1\u001bij\u0001\u0002\u0001\t\u000f5\u0011Q!\u0001E\u0007!\u000e\u0001Qt\u0002\u0003\u0001\u0011#i1!B\u0001\t\u000f1\u0005\u0001k!\u0001\u001e\u000e\u0011\u0001\u0001bA\u0007\u0003\u000b\u0005A\t\u0002U\u0002\u0002;\u001b!\u0001\u0001#\u0006\u000e\u0005\u0015\t\u00012\u0003)\u0004\u0004\u0005\u0012Q!\u0001E\n#\u000eYAQB\u0005\u0002\t\u0003i\u0011\u0001\u0003\u0006\u000e\u0003!UQ\"\u0001\u0005\f\u001b\u0005!\t!l\u000f\u0005\u0003a]QT\u0002\u0003\u0001\u00111i!!B\u0001\t\u0018A\u001b\u0001!(\u0004\u0005\u0001!iQBA\u0003\u0002\u0011\u001b\u00016\u0011A\u0011\u0004\u000b\u0005AI\u0002$\u0001R\u0007\u001d!9\"C\u0001\t\u001b5\tAQA\u0007\u0002\u0011))4\"\u0002\u0006\u0005G\u0004Ab!\t\u0002\u0006\u0003!\u0019\u0011kA\u0002\u0005\r%\tA\u0001\u0001"})
    public static final class KotlinPlainEnterProcessor
    extends SmartEnterProcessorWithFixers.FixEnterProcessor {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(KotlinPlainEnterProcessor.class);
        }

        private final JetExpression getControlStatementBlock(@JetValueParameter(name="caret") int caret, @JetValueParameter(name="element") PsiElement element) {
            PsiElement psiElement = element;
            if (psiElement instanceof JetDeclarationWithBody) {
                return ((JetDeclarationWithBody)element).getBodyExpression();
            }
            if (psiElement instanceof JetIfExpression) {
                if (FixersPackage$fixersUtil$f9a2ce21.isWithCaret((PsiElement)((JetIfExpression)element).getThen(), caret)) {
                    return ((JetIfExpression)element).getThen();
                }
                if (FixersPackage$fixersUtil$f9a2ce21.isWithCaret((PsiElement)((JetIfExpression)element).getElse(), caret)) {
                    return ((JetIfExpression)element).getElse();
                }
            } else if (psiElement instanceof JetLoopExpression) {
                return ((JetLoopExpression)element).getBody();
            }
            return null;
        }

        public boolean doEnter(@JetValueParameter(name="atCaret") @NotNull PsiElement atCaret, @JetValueParameter(name="file", type="?") @Nullable PsiFile file, @JetValueParameter(name="editor") @NotNull Editor editor, @JetValueParameter(name="modified") boolean modified) {
            JetBlockExpression block;
            Intrinsics.checkParameterIsNotNull((Object)atCaret, (String)"atCaret");
            Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
            JetExpression jetExpression = this.getControlStatementBlock(editor.getCaretModel().getOffset(), atCaret);
            if (!(jetExpression instanceof JetBlockExpression)) {
                jetExpression = null;
            }
            if ((block = (JetBlockExpression)jetExpression) != null) {
                int n;
                PsiElement firstElement;
                PsiElement psiElement = block.getFirstChild();
                Object object = firstElement = psiElement != null ? psiElement.getNextSibling() : null;
                if (firstElement != null) {
                    TextRange textRange = firstElement.getTextRange();
                    if (textRange == null) {
                        Intrinsics.throwNpe();
                    }
                    n = textRange.getStartOffset() - 1;
                } else {
                    TextRange textRange = block.getTextRange();
                    if (textRange == null) {
                        Intrinsics.throwNpe();
                    }
                    n = textRange.getEndOffset();
                }
                int offset = n;
                editor.getCaretModel().moveToOffset(offset);
            }
            this.plainEnter(editor);
            return true;
        }
    }
}

