/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework.ui;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class ChooseModulePanel {
    private JPanel contentPane;
    private JRadioButton allModulesWithKtRadioButton;
    private JRadioButton singleModuleRadioButton;
    private JComboBox singleModuleComboBox;
    private JTextField allModulesNames;
    @NotNull
    private final Project project;
    @NotNull
    private final List<Module> modules;

    public ChooseModulePanel(@NotNull Project project, @NotNull List<Module> modules) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/framework/ui/ChooseModulePanel", "<init>"));
        }
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "org/jetbrains/kotlin/idea/framework/ui/ChooseModulePanel", "<init>"));
        }
        this.project = project;
        this.modules = modules;
        this.$$$setupUI$$$();
        DefaultComboBoxModel<String> comboBoxModel = new DefaultComboBoxModel<String>();
        for (Module module : modules) {
            comboBoxModel.addElement(module.getName());
        }
        this.singleModuleComboBox.setModel(comboBoxModel);
        this.singleModuleRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseModulePanel.this.updateComponents();
            }
        });
        this.allModulesWithKtRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseModulePanel.this.updateComponents();
            }
        });
        String fullList = StringUtil.join(modules, (Function)new Function<Module, String>(){

            public String fun(Module module) {
                return module.getName();
            }
        }, (String)", ");
        this.allModulesNames.setText(fullList);
        this.allModulesNames.setBorder(null);
        ButtonGroup modulesGroup = new ButtonGroup();
        modulesGroup.add(this.allModulesWithKtRadioButton);
        modulesGroup.add(this.singleModuleRadioButton);
        this.allModulesWithKtRadioButton.setSelected(true);
        this.updateComponents();
    }

    public JComponent getContentPane() {
        return this.contentPane;
    }

    private void updateComponents() {
        this.singleModuleComboBox.setEnabled(this.singleModuleRadioButton.isSelected());
    }

    public List<Module> getModulesToConfigure() {
        if (this.allModulesWithKtRadioButton.isSelected()) {
            return this.modules;
        }
        String selectedItem = (String)this.singleModuleComboBox.getSelectedItem();
        return Collections.singletonList(ModuleManager.getInstance((Project)this.project).findModuleByName(selectedItem));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JTextField jTextField;
        JComboBox jComboBox;
        JRadioButton jRadioButton2;
        JPanel jPanel;
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.singleModuleRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Single module:");
        jPanel.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.singleModuleComboBox = jComboBox = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox.setModel(defaultComboBoxModel);
        jPanel.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 3, 0, 2, 1, 6, null, null, null));
        this.allModulesNames = jTextField = new JTextField();
        ((Component)jTextField).setEnabled(true);
        jTextField.setEditable(false);
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), new Dimension(-1, 100)));
        this.allModulesWithKtRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("All modules containing Kotlin files: ");
        jPanel.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

