/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.joinLines;

import com.intellij.codeInsight.editorActions.JoinRawLinesHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetContainerNode;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetIfExpression;
import org.jetbrains.kotlin.psi.JetWhenEntry;
import org.jetbrains.kotlin.psi.PsiPackage;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"\b\u0006)\u0019#j\\5o\u00052|7m[%oi>\u001c\u0016N\\4mKN#\u0018\r^3nK:$\b*\u00198eY\u0016\u0014(bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\u0007W>$H.\u001b8\u000b\t%$W-\u0019\u0006\nU>Lg\u000eT5oKNT1DS8j]J\u000bw\u000fT5oKND\u0015M\u001c3mKJ$U\r\\3hCR,'bA2p[*A\u0011N\u001c;fY2L'NC\u0006d_\u0012,\u0017J\\:jO\"$(\"D3eSR|'/Q2uS>t7O\u0003\u0004=S:LGO\u0010\u0006\riJL(j\\5o\u0019&tWm\u001d\u0006\tI>\u001cW/\\3oi*AAi\\2v[\u0016tGOC\u0004pa\u0016t\u0017\r]5\u000b\r\u0015$\u0017\u000e^8s\u0015\u00111\u0017\u000e\\3\u000b\u000fA\u001b\u0018NR5mK*\u0019\u0001o]5\u000b\u000bM$\u0018M\u001d;\u000b\u0007%sGOC\u0002f]\u0012Tq\u0002\u001e:z\u0015>LgNU1x\u0019&tWm\u001d?\u000b\u0005A\t!\u0002\u0002\u0005\u0001!\tQA\u0001C\u0001\u0011\u0007)!\u0001B\u0001\t\u0005\u0015\u0011A1\u0001E\u0003\u000b\r!!\u0001\u0003\u0001\r\u0001\u0015\t\u0001rA\u0003\u0003\t\rAA!\u0002\u0002\u0005\b!%QA\u0001\u0003\u0005\u0011\u0015)1\u0001\"\u0003\t\u00071\u0001QA\u0001C\u0004\u0011\u001f)!\u0001b\u0003\t\u0011\u0015\u0019AA\u0002\u0005\b\u0019\u0001)!\u0001b\u0002\t\u0014\u0015\u0019Aa\u0002\u0005\n\u0019\u0001)\u0011\u0001c\u0001\u0006\u0007\u0011A\u0001R\u0003\u0007\u0001\u000b\t!a\u0001C\u0004\u0006\u0005\u00119\u0001\"\u0003\u0003\u0004\u0019\u000bI\"!B\u0001\t\u000b5~Ca\u0003\r\u0007;\u001b!\u0001\u0001#\u0004\u000e\u0005\u0015\t\u0001R\u0002)\u0004\u0001u5A\u0001\u0001E\t\u001b\t)\u0011\u0001c\u0004Q\u0007\u0003ij\u0001\u0002\u0001\t\u00155\u0011Q!\u0001E\t!\u000e\tQT\u0002\u0003\u0001\u0011-i!!B\u0001\t\u0012A\u001b\u0019!\t\u0002\u0006\u0003!E\u0011kA\u0006\u0005\r%\tAQA\u0007\u0002\u0011%i\u0011\u0001c\u0005\u000e\u0003\u0011\u0015Q\"\u0001C\u0003[?\"1\u0002g\u0006\u001e\u000e\u0011\u0001\u0001RB\u0007\u0003\u000b\u0005Ai\u0001U\u0002\u0001;\u001b!\u0001\u0001#\u0005\u000e\u0005\u0015\t\u0001r\u0002)\u0004\u0002u5A\u0001\u0001\u0005\u000b\u001b\t)\u0011\u0001#\u0005Q\u0007\u0005ij\u0001\u0002\u0001\t\u00175\u0011Q!\u0001E\t!\u000e\r\u0011EA\u0003\u0002\u0011#\t6a\u0003C\f\u0013\u0005!)!D\u0001\t\u00135\t\u00012C\u0007\u0002\t\u000bi\u0011\u0001\"\u00026\u0017\u0015QAa9\u0001\u0019\f\u0005\u0012Q!\u0001E\u0003#\u000e\u0019A1B\u0005\u0002\t\u0001\u0001"})
public final class JoinBlockIntoSingleStatementHandler
implements JoinRawLinesHandlerDelegate {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(JoinBlockIntoSingleStatementHandler.class);
    }

    public int tryJoinRawLines(@JetValueParameter(name="document") @NotNull Document document, @JetValueParameter(name="file") @NotNull PsiFile file, @JetValueParameter(name="start") int start, @JetValueParameter(name="end") int end) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (!(file instanceof JetFile)) {
            return -1;
        }
        if (start == 0) {
            return -1;
        }
        char c = KotlinPackage.get((CharSequence)document.getCharsSequence(), (int)start);
        int index2 = c == '\n' ? start - 1 : start;
        PsiElement psiElement = ((JetFile)file).findElementAt(index2);
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        PsiElement brace = psiElement;
        ASTNode aSTNode = brace.getNode();
        if (aSTNode == null) {
            Intrinsics.throwNpe();
        }
        if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)((Object)JetTokens.LBRACE)) ^ true) {
            return -1;
        }
        PsiElement psiElement2 = brace.getParent();
        if (!(psiElement2 instanceof JetBlockExpression)) {
            psiElement2 = null;
        }
        JetBlockExpression jetBlockExpression = (JetBlockExpression)psiElement2;
        if (jetBlockExpression == null) {
            return -1;
        }
        JetBlockExpression block = jetBlockExpression;
        JetElement jetElement = (JetElement)KotlinPackage.singleOrNull(block.getStatements());
        if (jetElement == null) {
            return -1;
        }
        JetElement statement = jetElement;
        PsiElement parent = block.getParent();
        if (!(parent instanceof JetContainerNode) && !(parent instanceof JetWhenEntry)) {
            return -1;
        }
        if (KotlinPackage.isNotEmpty((Object[])block.getNode().getChildren(JetTokens.COMMENTS))) {
            return -1;
        }
        PsiElement pparent = parent.getParent();
        if (pparent instanceof JetIfExpression && Intrinsics.areEqual((Object)block, (Object)((JetIfExpression)pparent).getThen()) && statement instanceof JetIfExpression && ((JetIfExpression)statement).getElse() == null) {
            if (((JetIfExpression)pparent).getElse() != null) {
                return -1;
            }
            JetExpression condition1 = ((JetIfExpression)pparent).getCondition();
            JetExpression condition2 = ((JetIfExpression)statement).getCondition();
            JetExpression body2 = ((JetIfExpression)statement).getThen();
            if (condition1 != null && condition2 != null && body2 != null) {
                JetExpression newCondition = PsiPackage.createExpressionByPattern(PsiPackage.JetPsiFactory(pparent), "$0 && $1", condition1, condition2);
                condition1.replace((PsiElement)newCondition);
                PsiElement newBody = block.replace((PsiElement)body2);
                TextRange textRange = newBody.getTextRange();
                if (textRange == null) {
                    Intrinsics.throwNpe();
                }
                return textRange.getStartOffset();
            }
        }
        PsiElement newStatement = block.replace((PsiElement)statement);
        TextRange textRange = newStatement.getTextRange();
        if (textRange == null) {
            Intrinsics.throwNpe();
        }
        return textRange.getStartOffset();
    }

    public int tryJoinLines(@JetValueParameter(name="document") @NotNull Document document, @JetValueParameter(name="file") @NotNull PsiFile file, @JetValueParameter(name="start") int start, @JetValueParameter(name="end") int end) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return -1;
    }
}

