/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.core.refactoring.SimpleCollectingValidator;
import org.jetbrains.kotlin.idea.quickfix.ChangeFunctionSignatureFix;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.ChangeSignaturePackage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetChangeSignatureConfiguration;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetMethodDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetMutableMethodDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetParameterInfo;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.psi.JetCallElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;

public class AddFunctionParametersFix
extends ChangeFunctionSignatureFix {
    private final JetCallElement callElement;
    private final boolean hasTypeMismatches;
    private final List<JetType> typesToShorten;

    public AddFunctionParametersFix(@NotNull JetCallElement callElement2, @NotNull FunctionDescriptor functionDescriptor, boolean hasTypeMismatches) {
        if (callElement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callElement", "org/jetbrains/kotlin/idea/quickfix/AddFunctionParametersFix", "<init>"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/idea/quickfix/AddFunctionParametersFix", "<init>"));
        }
        super((PsiElement)callElement2, functionDescriptor);
        this.typesToShorten = new ArrayList<JetType>();
        this.callElement = callElement2;
        this.hasTypeMismatches = hasTypeMismatches;
    }

    @NotNull
    public String getText() {
        String subjectSuffix;
        List<ValueParameterDescriptor> parameters2 = this.functionDescriptor.getValueParameters();
        List<? extends ValueArgument> arguments2 = this.callElement.getValueArguments();
        int newParametersCnt = arguments2.size() - parameters2.size();
        assert (newParametersCnt > 0);
        String string = subjectSuffix = newParametersCnt > 1 ? "s" : "";
        if (this.isConstructor()) {
            String className = this.functionDescriptor.getContainingDeclaration().getName().asString();
            if (this.hasTypeMismatches) {
                String string2 = JetBundle.message("change.constructor.signature", className);
                if (string2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/AddFunctionParametersFix", "getText"));
                }
                return string2;
            }
            String string3 = JetBundle.message("add.parameters.to.constructor", subjectSuffix, className);
            if (string3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/AddFunctionParametersFix", "getText"));
            }
            return string3;
        }
        String functionName = this.functionDescriptor.getName().asString();
        if (this.hasTypeMismatches) {
            String string4 = JetBundle.message("change.function.signature", functionName);
            if (string4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/AddFunctionParametersFix", "getText"));
            }
            return string4;
        }
        String string5 = JetBundle.message("add.parameters.to.function", subjectSuffix, functionName);
        if (string5 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/AddFunctionParametersFix", "getText"));
        }
        return string5;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/AddFunctionParametersFix", "isAvailable"));
        }
        if (!super.isAvailable(project, editor, file)) {
            return false;
        }
        int newParametersCnt = this.callElement.getValueArguments().size() - this.functionDescriptor.getValueParameters().size();
        return newParametersCnt > 0;
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    @Override
    protected void invoke(@NotNull Project project, Editor editor, JetFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/AddFunctionParametersFix", "invoke"));
        }
        BindingContext bindingContext2 = ResolvePackage.analyzeFully((JetFile)this.callElement.getContainingFile());
        ChangeSignaturePackage.runChangeSignature(project, this.functionDescriptor, this.addParameterConfiguration(), bindingContext2, (PsiElement)this.callElement, this.getText());
    }

    private JetChangeSignatureConfiguration addParameterConfiguration() {
        return new JetChangeSignatureConfiguration(){

            @Override
            @NotNull
            public JetMethodDescriptor configure(final @NotNull JetMethodDescriptor originalDescriptor, final @NotNull BindingContext bindingContext2) {
                if (originalDescriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalDescriptor", "org/jetbrains/kotlin/idea/quickfix/AddFunctionParametersFix$1", "configure"));
                }
                if (bindingContext2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/idea/quickfix/AddFunctionParametersFix$1", "configure"));
                }
                JetMethodDescriptor jetMethodDescriptor = ChangeSignaturePackage.modify(originalDescriptor, (Function1<? super JetMutableMethodDescriptor, ? extends Unit>)new Function1<JetMutableMethodDescriptor, Unit>(){

                    public Unit invoke(JetMutableMethodDescriptor descriptor2) {
                        List<ValueParameterDescriptor> parameters2 = AddFunctionParametersFix.this.functionDescriptor.getValueParameters();
                        List<? extends ValueArgument> arguments2 = AddFunctionParametersFix.this.callElement.getValueArguments();
                        SimpleCollectingValidator validator2 = new SimpleCollectingValidator();
                        for (int i = 0; i < arguments2.size(); ++i) {
                            ValueArgument argument = arguments2.get(i);
                            JetExpression expression2 = argument.getArgumentExpression();
                            if (i < parameters2.size()) {
                                validator2.validateName(parameters2.get(i).getName().asString());
                                JetType argumentType = expression2 != null ? bindingContext2.getType(expression2) : null;
                                JetType parameterType = parameters2.get(i).getType();
                                if (argumentType == null || JetTypeChecker.DEFAULT.isSubtypeOf(argumentType, parameterType)) continue;
                                descriptor2.getParameters().get(i).setCurrentTypeText(IdeDescriptorRenderers.SOURCE_CODE.renderType(argumentType));
                                AddFunctionParametersFix.this.typesToShorten.add(argumentType);
                                continue;
                            }
                            JetParameterInfo parameterInfo = ChangeFunctionSignatureFix.getNewParameterInfo(originalDescriptor.getBaseDescriptor(), bindingContext2, argument, validator2);
                            AddFunctionParametersFix.this.typesToShorten.add(parameterInfo.getOriginalType());
                            if (expression2 != null) {
                                parameterInfo.setDefaultValueForCall(expression2);
                            }
                            descriptor2.addParameter(parameterInfo);
                        }
                        return null;
                    }
                });
                if (jetMethodDescriptor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/AddFunctionParametersFix$1", "configure"));
                }
                return jetMethodDescriptor;
            }

            @Override
            public boolean performSilently(@NotNull Collection<? extends PsiElement> affectedFunctions2) {
                if (affectedFunctions2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "affectedFunctions", "org/jetbrains/kotlin/idea/quickfix/AddFunctionParametersFix$1", "performSilently"));
                }
                if (affectedFunctions2.size() != 1) {
                    return false;
                }
                PsiElement onlyFunction = affectedFunctions2.iterator().next();
                return !AddFunctionParametersFix.this.hasTypeMismatches && !AddFunctionParametersFix.this.isConstructor() && !AddFunctionParametersFix.this.hasOtherUsages(onlyFunction);
            }

            @Override
            public boolean forcePerformForSelectedFunctionOnly() {
                return false;
            }
        };
    }

    private boolean hasOtherUsages(@NotNull PsiElement function2) {
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/idea/quickfix/AddFunctionParametersFix", "hasOtherUsages"));
        }
        for (PsiReference reference : ReferencesSearch.search((PsiElement)function2)) {
            JetCallElement call = (JetCallElement)PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), JetCallElement.class);
            if (call == null || this.callElement.equals(call)) continue;
            return true;
        }
        return false;
    }

    private boolean isConstructor() {
        return this.functionDescriptor instanceof ConstructorDescriptor;
    }
}

