/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.quickfix.JetIntentionAction;
import org.jetbrains.kotlin.idea.quickfix.JetSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.ShortenReferences;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPropertyAccessor;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.PsiPackage;
import org.jetbrains.kotlin.types.JetType;

public class ChangeAccessorTypeFix
extends JetIntentionAction<JetPropertyAccessor> {
    private JetType type;

    public ChangeAccessorTypeFix(@NotNull JetPropertyAccessor element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/quickfix/ChangeAccessorTypeFix", "<init>"));
        }
        super(element);
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/ChangeAccessorTypeFix", "isAvailable"));
        }
        JetProperty property = (JetProperty)PsiTreeUtil.getParentOfType((PsiElement)this.element, JetProperty.class);
        if (property == null) {
            return false;
        }
        JetType type2 = QuickFixUtil.getDeclarationReturnType(property);
        if (super.isAvailable(project, editor, file) && type2 != null && !type2.isError()) {
            this.type = type2;
            return true;
        }
        return false;
    }

    @NotNull
    public String getText() {
        String string = JetBundle.message(((JetPropertyAccessor)this.element).isGetter() ? "change.getter.type" : "change.setter.type", IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES.renderType(this.type));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeAccessorTypeFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JetBundle.message("change.accessor.type", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeAccessorTypeFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, JetFile file) throws IncorrectOperationException {
        JetTypeReference typeReference;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/ChangeAccessorTypeFix", "invoke"));
        }
        JetTypeReference newTypeReference = PsiPackage.JetPsiFactory((PsiElement)file).createType(IdeDescriptorRenderers.SOURCE_CODE.renderType(this.type));
        if (((JetPropertyAccessor)this.element).isGetter()) {
            typeReference = ((JetPropertyAccessor)this.element).getReturnTypeReference();
        } else {
            JetParameter parameter = ((JetPropertyAccessor)this.element).getParameter();
            assert (parameter != null);
            typeReference = parameter.getTypeReference();
        }
        assert (typeReference != null);
        newTypeReference = (JetTypeReference)typeReference.replace((PsiElement)newTypeReference);
        ShortenReferences.DEFAULT.process(newTypeReference);
    }

    public static JetSingleIntentionActionFactory createFactory() {
        return new JetSingleIntentionActionFactory(){

            @Override
            public JetIntentionAction<JetPropertyAccessor> createAction(@NotNull Diagnostic diagnostic) {
                if (diagnostic == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/idea/quickfix/ChangeAccessorTypeFix$1", "createAction"));
                }
                JetPropertyAccessor accessor = QuickFixUtil.getParentElementOfType(diagnostic, JetPropertyAccessor.class);
                if (accessor == null) {
                    return null;
                }
                return new ChangeAccessorTypeFix(accessor);
            }
        };
    }
}

